/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.rbm;

import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.BaseNeuralNetwork;
import org.deeplearning4j.rbm.RBM;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;

public class CRBM
extends RBM {
    private static final long serialVersionUID = 598767790003731193L;

    private CRBM() {
    }

    private CRBM(DoubleMatrix input, int nVisible, int nHidden, DoubleMatrix W, DoubleMatrix hbias, DoubleMatrix vbias, RandomGenerator rng, double fanIn, RealDistribution dist) {
        super(input, nVisible, nHidden, W, hbias, vbias, rng, fanIn, dist);
        if (this.useAdaGrad) {
            this.wAdaGrad.setMasterStepSize(1.0E-4);
        }
    }

    @Override
    public DoubleMatrix propDown(DoubleMatrix h) {
        DoubleMatrix preSig = h.mmul(this.W.transpose()).addRowVector(this.vBias);
        return preSig;
    }

    @Override
    public Pair<DoubleMatrix, DoubleMatrix> sampleVisibleGivenHidden(DoubleMatrix h) {
        DoubleMatrix activationHidden = this.propDown(h);
        DoubleMatrix negativeEnergy = MatrixFunctions.exp((DoubleMatrix)activationHidden.neg());
        DoubleMatrix positiveEnergy = MatrixFunctions.exp((DoubleMatrix)activationHidden);
        DoubleMatrix v1Mean = MatrixUtil.oneDiv(MatrixUtil.oneMinus(negativeEnergy).sub(MatrixUtil.oneDiv(activationHidden)));
        DoubleMatrix v1Sample = MatrixUtil.log(MatrixUtil.oneMinus(MatrixUtil.uniform(this.rng, v1Mean.rows, v1Mean.columns).mul(MatrixUtil.oneMinus(positiveEnergy)))).div(activationHidden);
        return new Pair<DoubleMatrix, DoubleMatrix>(v1Mean, v1Sample);
    }

    public static class Builder
    extends BaseNeuralNetwork.Builder<CRBM> {
        public Builder() {
            this.clazz = CRBM.class;
        }
    }
}

