/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize;

import cc.mallet.optimize.InvalidOptimizableException;
import org.apache.commons.math3.util.FastMath;
import org.deeplearning4j.optimize.LineOptimizerMatrix;
import org.deeplearning4j.optimize.OptimizableByGradientValueMatrix;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;
import org.jblas.MatrixFunctions;
import org.jblas.SimpleBlas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedBackTrackLineSearch
implements LineOptimizerMatrix {
    private static Logger logger = LoggerFactory.getLogger((String)VectorizedBackTrackLineSearch.class.getName());
    OptimizableByGradientValueMatrix function;
    final int maxIterations = 100;
    final double stpmax = 100.0;
    final double EPS = 3.0E-12;
    private double relTolx = 1.0E-10;
    private double absTolx = 1.0E-4;
    final double ALF = 1.0E-4;

    public VectorizedBackTrackLineSearch(OptimizableByGradientValueMatrix optimizable) {
        this.function = optimizable;
    }

    public void setRelTolx(double tolx) {
        this.relTolx = tolx;
    }

    public void setAbsTolx(double tolx) {
        this.absTolx = tolx;
    }

    @Override
    public double optimize(DoubleMatrix line, double initialStep) {
        double fold;
        DoubleMatrix g = this.function.getValueGradient();
        DoubleMatrix x = this.function.getParameters();
        DoubleMatrix oldParameters = x.dup();
        double tmplam = 0.0;
        double alam2 = 0.0;
        double f2 = fold = this.function.getValue();
        if (logger.isDebugEnabled()) {
            logger.debug("ENTERING BACKTRACK\n");
            logger.debug("Entering BackTrackLnSrch, value=" + fold + ",\ndirection.oneNorm:" + line.norm1() + "  direction.infNorm:" + FastMath.max((double)Double.NEGATIVE_INFINITY, (double)MatrixFunctions.abs((DoubleMatrix)line).max()));
        }
        assert (!MatrixUtil.isNaN(g));
        double sum = line.norm2();
        if (sum > 100.0) {
            logger.warn("attempted step too big. scaling: sum= " + sum + ", stpmax= " + 100.0);
            line.muli(100.0 / sum);
        }
        double slope = SimpleBlas.dot((DoubleMatrix)g, (DoubleMatrix)line);
        logger.debug("slope = " + slope);
        if (slope < 0.0) {
            throw new InvalidOptimizableException("Slope = " + slope + " is negative");
        }
        if (slope == 0.0) {
            throw new InvalidOptimizableException("Slope = " + slope + " is zero");
        }
        DoubleMatrix maxOldParams = new DoubleMatrix(oldParameters.length);
        for (int i = 0; i < oldParameters.length; ++i) {
            maxOldParams.put(i, Math.max(Math.abs(oldParameters.get(i)), 1.0));
        }
        DoubleMatrix testMatrix = MatrixFunctions.abs((DoubleMatrix)line).div(maxOldParams);
        double test = testMatrix.max();
        double alamin = this.relTolx / test;
        double alam = 1.0;
        double oldAlam = 0.0;
        int iteration = 0;
        for (iteration = 0; iteration < 100; ++iteration) {
            double f;
            logger.debug("BackTrack loop iteration " + iteration + " : alam=" + alam + " oldAlam=" + oldAlam);
            logger.debug("before step, x.1norm: " + x.norm1() + "\nalam: " + alam + "\noldAlam: " + oldAlam);
            assert (alam != oldAlam) : "alam == oldAlam";
            x.addi(line.mul(alam - oldAlam));
            logger.debug("after step, x.1norm: " + x.norm1());
            if (alam < alamin || this.smallAbsDiff(oldParameters, x)) {
                this.function.setParameters(oldParameters);
                f = this.function.getValue();
                logger.warn("EXITING BACKTRACK: Jump too small (alamin=" + alamin + "). Exiting and using xold. Value=" + f);
                return 0.0;
            }
            this.function.setParameters(x);
            oldAlam = alam;
            f = this.function.getValue();
            logger.debug("value = " + f);
            if (f >= fold + 1.0E-4 * alam * slope) {
                logger.debug("EXITING BACKTRACK: value=" + f);
                if (f < fold) {
                    throw new IllegalStateException("Function did not increase: f=" + f + " < " + fold + "=fold");
                }
                return alam;
            }
            if (Double.isInfinite(f) || Double.isInfinite(f2)) {
                logger.warn("Value is infinite after jump " + oldAlam + ". f=" + f + ", f2=" + f2 + ". Scaling back step size...");
                tmplam = 0.2 * alam;
                if (alam < alamin) {
                    this.function.setParameters(oldParameters);
                    f = this.function.getValue();
                    logger.warn("EXITING BACKTRACK: Jump too small. Exiting and using xold. Value=" + f);
                    return 0.0;
                }
            } else if (alam == 1.0) {
                tmplam = -slope / (2.0 * (f - fold - slope));
            } else {
                double disc;
                double rhs1 = f - fold - alam * slope;
                double rhs2 = f2 - fold - alam2 * slope;
                assert (alam - alam2 != 0.0) : "FAILURE: dividing by alam-alam2. alam=" + alam;
                double a = (rhs1 / FastMath.pow((double)alam, (int)2) - rhs2 / FastMath.pow((double)alam2, (int)2)) / (alam - alam2);
                double b = (-alam2 * rhs1 / (alam * alam) + alam * rhs2 / (alam2 * alam2)) / (alam - alam2);
                tmplam = a == 0.0 ? -slope / (2.0 * b) : ((disc = b * b - 3.0 * a * slope) < 0.0 ? 0.5 * alam : (b <= 0.0 ? (-b + FastMath.sqrt((double)disc)) / (3.0 * a) : -slope / (b + FastMath.sqrt((double)disc))));
                if (tmplam > 0.5 * alam) {
                    tmplam = 0.5 * alam;
                }
            }
            alam2 = alam;
            f2 = f;
            logger.debug("tmplam:" + tmplam);
            alam = Math.max(tmplam, 0.1 * alam);
        }
        if (iteration >= 100) {
            throw new IllegalStateException("Too many iterations.");
        }
        return 0.0;
    }

    private boolean smallAbsDiff(DoubleMatrix x, DoubleMatrix xold) {
        for (int i = 0; i < x.length; ++i) {
            double comp = Math.abs(x.get(i) - xold.get(i));
            if (!(comp > this.absTolx)) continue;
            return false;
        }
        return true;
    }
}

