/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.dbn;

import java.util.List;
import org.apache.commons.math3.random.RandomGenerator;
import org.deeplearning4j.dbn.DBN;
import org.deeplearning4j.nn.BaseMultiLayerNetwork;
import org.deeplearning4j.nn.NeuralNetwork;
import org.deeplearning4j.rbm.CRBM;
import org.deeplearning4j.rbm.RBM;
import org.jblas.DoubleMatrix;

public class CDBN
extends DBN {
    private static final long serialVersionUID = 3838174630098935941L;

    public CDBN() {
    }

    public CDBN(int nIn, int[] hiddenLayerSizes, int nOuts, int nLayers, RandomGenerator rng, DoubleMatrix input, DoubleMatrix labels) {
        super(nIn, hiddenLayerSizes, nOuts, nLayers, rng, input, labels);
    }

    public CDBN(int nIns, int[] hiddenLayerSizes, int nOuts, int nLayers, RandomGenerator rng) {
        super(nIns, hiddenLayerSizes, nOuts, nLayers, rng);
    }

    @Override
    public NeuralNetwork createLayer(DoubleMatrix input, int nVisible, int nHidden, DoubleMatrix W, DoubleMatrix hBias, DoubleMatrix vBias, RandomGenerator rng, int index) {
        NeuralNetwork ret = null;
        ret = index == 0 ? (NeuralNetwork)new CRBM.Builder().useRegularization(this.isUseRegularization()).withDropOut(this.dropOut).withDistribution(this.getDist()).useAdaGrad(this.isUseAdaGrad()).normalizeByInputRows(this.normalizeByInputRows).withHBias(hBias).numberOfVisible(nVisible).numHidden(nHidden).withSparsity(this.getSparsity()).withInput(input).withL2(this.getL2()).fanIn(this.getFanIn()).renderWeights(this.getRenderWeightsEveryNEpochs()).withRandom(rng).withWeights(W).build() : (NeuralNetwork)new RBM.Builder().useAdaGrad(this.isUseAdaGrad()).normalizeByInputRows(this.normalizeByInputRows).useRegularization(this.isUseRegularization()).withDistribution(this.getDist()).withDropOut(this.dropOut).withHBias(hBias).numberOfVisible(nVisible).numHidden(nHidden).withSparsity(this.getSparsity()).withInput(input).withL2(this.getL2()).fanIn(this.getFanIn()).renderWeights(this.getRenderWeightsEveryNEpochs()).withRandom(rng).withWeights(W).build();
        if (this.gradientListeners.get(index) != null) {
            ret.setGradientListeners((List)this.gradientListeners.get(index));
        }
        return ret;
    }

    @Override
    public NeuralNetwork[] createNetworkLayers(int numLayers) {
        return new RBM[numLayers];
    }

    public static class Builder
    extends BaseMultiLayerNetwork.Builder<CDBN> {
        public Builder() {
            this.clazz = CDBN.class;
        }
    }
}

