/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.util.ArrayList;
import org.deeplearning4j.base.LFWLoader;
import org.deeplearning4j.datasets.DataSet;
import org.deeplearning4j.datasets.fetchers.BaseDataFetcher;

public class LFWDataFetcher
extends BaseDataFetcher {
    private static final long serialVersionUID = -7473748140401804666L;
    private LFWLoader loader;
    public static final int NUM_IMAGES = 13233;

    public LFWDataFetcher(int imageWidth, int imageHeight) {
        try {
            this.loader = new LFWLoader(imageWidth, imageHeight);
            this.loader.getIfNotExists();
            this.inputColumns = this.loader.getNumPixelColumns();
            this.numOutcomes = this.loader.getNumNames();
            this.totalExamples = 13233;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to fetch images", e);
        }
    }

    public LFWDataFetcher() {
        this(200, 200);
    }

    @Override
    public void fetch(int numExamples) {
        if (!this.hasMore()) {
            throw new IllegalStateException("Unable to get more; there are no more images");
        }
        ArrayList<DataSet> toConvert = new ArrayList<DataSet>();
        int i = 0;
        while (i < numExamples && this.hasMore()) {
            toConvert.add(this.loader.getDataFor(this.cursor));
            ++i;
            ++this.cursor;
        }
        this.initializeCurrFromList(toConvert);
    }

    @Override
    public DataSet next() {
        DataSet next = super.next();
        next.divideBy(255);
        next.normalizeZeroMeanZeroUnitVariance();
        return next;
    }
}

