/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import cc.mallet.optimize.BackTrackLineSearch;
import cc.mallet.optimize.LineOptimizer;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.Optimizer;
import cc.mallet.optimize.OptimizerEvaluator;
import cc.mallet.types.MatrixOps;
import org.deeplearning4j.optimize.NeuralNetEpochListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonZeroStoppingConjugateGradient
implements Optimizer {
    private static Logger logger = LoggerFactory.getLogger(NonZeroStoppingConjugateGradient.class);
    boolean converged = false;
    Optimizable.ByGradientValue optimizable;
    LineOptimizer.ByGradient lineMaximizer;
    double initialStepSize = 1.0;
    double tolerance = 0.001;
    double gradientTolerance = 0.001;
    int maxIterations = 1000;
    private String myName = "";
    private NeuralNetEpochListener listener;
    final double eps = 1.0E-10;
    private OptimizerEvaluator.ByGradient eval;
    double fp;
    double gg;
    double gam;
    double dgg;
    double step;
    double fret;
    double[] xi;
    double[] g;
    double[] h;
    int j;
    int iterations;

    public NonZeroStoppingConjugateGradient(Optimizable.ByGradientValue function, double initialStepSize) {
        this.initialStepSize = initialStepSize;
        this.optimizable = function;
        this.lineMaximizer = new BackTrackLineSearch(function);
        BackTrackLineSearch l = (BackTrackLineSearch)this.lineMaximizer;
        l.setAbsTolx(1.0E-10);
    }

    public NonZeroStoppingConjugateGradient(Optimizable.ByGradientValue function, NeuralNetEpochListener listener) {
        this(function, 0.01);
        this.listener = listener;
    }

    public NonZeroStoppingConjugateGradient(Optimizable.ByGradientValue function, double initialStepSize, NeuralNetEpochListener listener) {
        this(function, initialStepSize);
        this.listener = listener;
    }

    public NonZeroStoppingConjugateGradient(Optimizable.ByGradientValue function) {
        this(function, 0.01);
    }

    public Optimizable getOptimizable() {
        return this.optimizable;
    }

    public boolean isConverged() {
        return this.converged;
    }

    public void setEvaluator(OptimizerEvaluator.ByGradient eval) {
        this.eval = eval;
    }

    public void setLineMaximizer(LineOptimizer.ByGradient lineMaximizer) {
        this.lineMaximizer = lineMaximizer;
    }

    public void setInitialStepSize(double initialStepSize) {
        this.initialStepSize = initialStepSize;
    }

    public double getInitialStepSize() {
        return this.initialStepSize;
    }

    public double getStepSize() {
        return this.step;
    }

    public boolean optimize() {
        return this.optimize(this.maxIterations);
    }

    public void setTolerance(double t) {
        this.tolerance = t;
    }

    public boolean optimize(int numIterations) {
        this.myName = Thread.currentThread().getName();
        if (this.converged) {
            return true;
        }
        int n = this.optimizable.getNumParameters();
        long last = System.currentTimeMillis();
        if (this.xi == null) {
            this.fp = this.optimizable.getValue();
            this.xi = new double[n];
            this.g = new double[n];
            this.h = new double[n];
            this.optimizable.getValueGradient(this.xi);
            System.arraycopy(this.xi, 0, this.g, 0, n);
            System.arraycopy(this.xi, 0, this.h, 0, n);
            this.step = this.initialStepSize;
            this.iterations = 0;
        }
        long curr = 0L;
        for (int iterationCount = 0; iterationCount < numIterations; ++iterationCount) {
            curr = System.currentTimeMillis();
            if (this.listener != null) {
                this.listener.epochDone(iterationCount);
            }
            logger.info(this.myName + " ConjugateGradient: At iteration " + this.iterations + ", cost = " + this.fp + " -" + (curr - last));
            last = curr;
            try {
                this.step = this.lineMaximizer.optimize(this.xi, this.step);
            }
            catch (Throwable e) {
                logger.info(e.getMessage());
            }
            this.fret = this.optimizable.getValue();
            this.optimizable.getValueGradient(this.xi);
            if (0.0 < this.tolerance && 2.0 * Math.abs(this.fret - this.fp) <= this.tolerance * (Math.abs(this.fret) + Math.abs(this.fp) + 1.0E-10)) {
                logger.info("ConjugateGradient converged: old value= " + this.fp + " new value= " + this.fret + " tolerance=" + this.tolerance);
                this.converged = true;
                return true;
            }
            this.fp = this.fret;
            double twoNorm = MatrixOps.twoNorm((double[])this.xi);
            if (twoNorm < this.gradientTolerance) {
                logger.info("ConjugateGradient converged: gradient two norm " + twoNorm + ", less than " + this.gradientTolerance);
                this.converged = true;
                return true;
            }
            this.gg = 0.0;
            this.dgg = 0.0;
            this.j = 0;
            while (this.j < this.xi.length) {
                this.gg += this.g[this.j] * this.g[this.j];
                this.dgg += this.xi[this.j] * (this.xi[this.j] - this.g[this.j]);
                ++this.j;
            }
            this.gam = this.dgg / this.gg;
            this.j = 0;
            while (this.j < this.xi.length) {
                this.g[this.j] = this.xi[this.j];
                this.h[this.j] = this.xi[this.j] + this.gam * this.h[this.j];
                ++this.j;
            }
            assert (!MatrixOps.isNaN((double[])this.h));
            if (MatrixOps.dotProduct((double[])this.xi, (double[])this.h) > 0.0) {
                MatrixOps.set((double[])this.xi, (double[])this.h);
            } else {
                logger.warn("Reverting back to GA");
                MatrixOps.set((double[])this.h, (double[])this.xi);
            }
            ++this.iterations;
            if (this.iterations > this.maxIterations) {
                logger.info("Too many iterations in ConjugateGradient.java");
                this.converged = true;
                return true;
            }
            if (this.eval == null) continue;
            this.eval.evaluate(this.optimizable, this.iterations);
        }
        return false;
    }

    public void reset() {
        this.xi = null;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }
}

