/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.deeplearning4j.base.MnistFetcher;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.datasets.MnistManager;
import org.deeplearning4j.datasets.fetchers.BaseDataFetcher;
import org.deeplearning4j.util.ArrayUtil;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;

public class MnistDataFetcher
extends BaseDataFetcher {
    private transient MnistManager man;
    public static final int NUM_EXAMPLES = 60000;

    public MnistDataFetcher() throws IOException {
        int[][] image;
        if (!new File("/tmp/mnist").exists()) {
            new MnistFetcher().downloadAndUntar();
        }
        this.man = new MnistManager("/tmp/MNIST/train-images-idx1-ubyte", "/tmp/MNIST/train-labels-idx1-ubyte");
        this.numOutcomes = 10;
        this.totalExamples = 60000;
        this.cursor = 1;
        this.man.setCurrent(this.cursor);
        try {
            image = this.man.readImage();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read image");
        }
        this.inputColumns = ArrayUtil.flatten(image).length;
    }

    @Override
    public void fetch(int numExamples) {
        if (!this.hasMore()) {
            throw new IllegalStateException("Unable to get more; there are no more images");
        }
        ArrayList<Pair<DoubleMatrix, DoubleMatrix>> toConvert = new ArrayList<Pair<DoubleMatrix, DoubleMatrix>>();
        int i = 0;
        while (i < numExamples && this.hasMore()) {
            if (this.man == null) {
                try {
                    this.man = new MnistManager("/tmp/MNIST/train-images-idx1-ubyte", "/tmp/MNIST/train-labels-idx1-ubyte");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.man.setCurrent(this.cursor);
            try {
                DoubleMatrix in = MatrixUtil.toMatrix(ArrayUtil.flatten(this.man.readImage()));
                for (int d = 0; d < in.length; ++d) {
                    if (in.get(d) > 30.0) {
                        in.put(d, 1.0);
                        continue;
                    }
                    in.put(d, 0.0);
                }
                DoubleMatrix out = this.createOutputVector(this.man.readLabel());
                boolean found = false;
                for (int col = 0; col < out.length; ++col) {
                    if (!(out.get(col) > 0.0)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IllegalStateException("Found a matrix without an outcome");
                }
                toConvert.add(new Pair<DoubleMatrix, DoubleMatrix>(in, out));
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read image");
            }
            ++i;
            ++this.cursor;
        }
        this.initializeCurrFromList(toConvert);
    }

    @Override
    public void reset() {
        this.cursor = 1;
    }
}

