/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.base;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.util.MatrixUtil;
import org.jblas.DoubleMatrix;
import org.springframework.core.io.ClassPathResource;

public class IrisUtils {
    public static List<Pair<DoubleMatrix, DoubleMatrix>> loadIris(int from, int to) throws IOException {
        int i;
        ClassPathResource resource = new ClassPathResource("/iris.dat");
        List lines = IOUtils.readLines((InputStream)resource.getInputStream());
        ArrayList<Pair<DoubleMatrix, DoubleMatrix>> list = new ArrayList<Pair<DoubleMatrix, DoubleMatrix>>();
        DoubleMatrix ret = DoubleMatrix.ones((int)to, (int)4);
        ArrayList<String> outcomeTypes = new ArrayList<String>();
        double[][] outcomes = new double[lines.size()][3];
        for (i = from; i < to; ++i) {
            String line = (String)lines.get(i);
            String[] split = line.split(",");
            IrisUtils.addRow(ret, i, split);
            String outcome = split[split.length - 1];
            if (!outcomeTypes.contains(outcome)) {
                outcomeTypes.add(outcome);
            }
            double[] rowOutcome = new double[3];
            rowOutcome[outcomeTypes.indexOf((Object)outcome)] = 1.0;
            outcomes[i] = rowOutcome;
        }
        MatrixUtil.columnNormalizeBySum(ret);
        ret = MatrixUtil.roundToTheNearest(ret, 10000.0);
        MatrixUtil.discretizeColumns(ret, 4);
        ret = ret.mul(0.01);
        for (i = 0; i < ret.rows; ++i) {
            list.add(new Pair<DoubleMatrix, DoubleMatrix>(ret.getRow(i), new DoubleMatrix(outcomes[i])));
        }
        return list;
    }

    public static Pair<DoubleMatrix, DoubleMatrix> loadIris() throws IOException {
        ClassPathResource resource = new ClassPathResource("/iris.dat");
        List lines = IOUtils.readLines((InputStream)resource.getInputStream());
        Collections.shuffle(lines);
        Collections.rotate(lines, 3);
        DoubleMatrix ret = DoubleMatrix.ones((int)lines.size(), (int)4);
        ArrayList<String> outcomeTypes = new ArrayList<String>();
        double[][] outcomes = new double[lines.size()][3];
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            String[] split = line.split(",");
            IrisUtils.addRow(ret, i, split);
            String outcome = split[split.length - 1];
            if (!outcomeTypes.contains(outcome)) {
                outcomeTypes.add(outcome);
            }
            double[] rowOutcome = new double[3];
            rowOutcome[outcomeTypes.indexOf((Object)outcome)] = 1.0;
            outcomes[i] = rowOutcome;
        }
        MatrixUtil.columnNormalizeBySum(ret);
        ret = MatrixUtil.roundToTheNearest(ret, 10000.0);
        MatrixUtil.discretizeColumns(ret, 4);
        ret = ret.mul(0.01);
        return new Pair<DoubleMatrix, DoubleMatrix>(ret, new DoubleMatrix(outcomes));
    }

    public static Pair<DoubleMatrix, DoubleMatrix> loadIris(int rows) throws IOException {
        ClassPathResource resource = new ClassPathResource("/iris.dat");
        List lines = IOUtils.readLines((InputStream)resource.getInputStream());
        Collections.shuffle(lines);
        Collections.rotate(lines, 3);
        Random rand = new Random(1L);
        DoubleMatrix ret = DoubleMatrix.ones((int)rows, (int)4);
        ArrayList<String> outcomeTypes = new ArrayList<String>();
        double[][] outcomes = new double[rows][3];
        for (int i = 0; i < rows; ++i) {
            String line = i >= lines.size() ? (String)lines.get(rand.nextInt(lines.size())) : (String)lines.get(i);
            String[] split = line.split(",");
            IrisUtils.addRow(ret, i, split);
            String outcome = split[split.length - 1];
            if (!outcomeTypes.contains(outcome)) {
                outcomeTypes.add(outcome);
            }
            double[] rowOutcome = new double[3];
            rowOutcome[outcomeTypes.indexOf((Object)outcome)] = 1.0;
            outcomes[i] = rowOutcome;
        }
        return new Pair<DoubleMatrix, DoubleMatrix>(ret, new DoubleMatrix(outcomes));
    }

    private static void addRow(DoubleMatrix ret, int row, String[] line) {
        double[] vector = new double[4];
        for (int i = 0; i < 4; ++i) {
            vector[i] = Double.parseDouble(line[i]);
        }
        ret.putRow(row, new DoubleMatrix(vector));
    }
}

