/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.common.resources;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.NonNull;
import org.deeplearning4j.common.resources.ResourceType;
import org.nd4j.base.Preconditions;

public class DL4JResources {
    @Deprecated
    public static final String DL4J_RESOURCES_DIR_PROPERTY = "org.deeplearning4j.resources.directory";
    @Deprecated
    public static final String DL4J_BASE_URL_PROPERTY = "org.deeplearning4j.resources.baseurl";
    private static final String DL4J_DEFAULT_URL = "https://dl4jdata.blob.core.windows.net/";
    private static File baseDirectory;
    private static String baseURL;

    public static void setBaseDownloadURL(@NonNull String baseDownloadURL) {
        if (baseDownloadURL == null) {
            throw new NullPointerException("baseDownloadURL is marked @NonNull but is null");
        }
        baseURL = baseDownloadURL;
    }

    public static String getBaseDownloadURL() {
        return baseURL;
    }

    public static URL getURL(String relativeToBase) throws MalformedURLException {
        return new URL(DL4JResources.getURLString(relativeToBase));
    }

    public static String getURLString(String relativeToBase) {
        if (relativeToBase.startsWith("/")) {
            relativeToBase = relativeToBase.substring(1);
        }
        return baseURL + relativeToBase;
    }

    public static void resetBaseDirectoryLocation() {
        String property = System.getProperty(DL4J_RESOURCES_DIR_PROPERTY);
        baseDirectory = property != null ? new File(property) : new File(System.getProperty("user.home"), ".deeplearning4j");
        if (!baseDirectory.exists()) {
            baseDirectory.mkdirs();
        }
    }

    public static void setBaseDirectory(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        Preconditions.checkState((f.exists() && f.isDirectory() ? 1 : 0) != 0, (String)"Specified base directory does not exist and/or is not a directory: %s", (Object)f.getAbsolutePath());
        baseDirectory = f;
    }

    public static File getBaseDirectory() {
        return baseDirectory;
    }

    public static File getDirectory(ResourceType resourceType, String resourceName) {
        File f = new File(baseDirectory, resourceType.resourceName());
        f = new File(f, resourceName);
        f.mkdirs();
        return f;
    }

    static {
        DL4JResources.resetBaseDirectoryLocation();
        String property = System.getProperty(DL4J_BASE_URL_PROPERTY);
        baseURL = property != null ? property : DL4J_DEFAULT_URL;
    }
}

