/*
 * Decompiled with CFR 0.152.
 */
package org.decampo.xirr;

import java.util.function.DoubleUnaryOperator;
import org.decampo.xirr.NonconvergenceException;
import org.decampo.xirr.OverflowException;
import org.decampo.xirr.ZeroValuedDerivativeException;

public class NewtonRaphson {
    public static final double TOLERANCE = 1.0E-7;
    private final DoubleUnaryOperator func;
    private final DoubleUnaryOperator derivative;
    private final double tolerance;
    private final long iterations;

    public static Builder builder() {
        return new Builder();
    }

    public NewtonRaphson(DoubleUnaryOperator func, DoubleUnaryOperator derivative, double tolerance, long iterations) {
        this.func = func;
        this.derivative = derivative;
        this.tolerance = tolerance;
        this.iterations = iterations;
    }

    public double findRoot(double guess) {
        return this.inverse(0.0, guess);
    }

    public double inverse(double target, double guess) {
        return new Calculation().solve(guess, target);
    }

    class Calculation {
        private double guess;
        private long i;
        private double candidate;
        private double value;
        private Double derivativeValue;

        Calculation() {
        }

        public double getGuess() {
            return this.guess;
        }

        public void setGuess(double guess) {
            this.guess = guess;
        }

        public long getIteration() {
            return this.i + 1L;
        }

        public double getCandidate() {
            return this.candidate;
        }

        public void setCandidate(double candidate) {
            this.candidate = candidate;
            if (!Double.isFinite(candidate)) {
                throw new OverflowException("Candidate overflow", this);
            }
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
            if (!Double.isFinite(value)) {
                throw new OverflowException("Function value overflow", this);
            }
        }

        public Double getDerivativeValue() {
            return this.derivativeValue;
        }

        public void setDerivativeValue(Double derivativeValue) {
            this.derivativeValue = derivativeValue;
            if (!Double.isFinite(derivativeValue)) {
                throw new OverflowException("Derivative value overflow", this);
            }
            if (derivativeValue == 0.0) {
                throw new ZeroValuedDerivativeException(this);
            }
        }

        public String toString() {
            return "{guess=" + this.guess + ", iteration=" + this.i + ", candidate=" + this.candidate + ", value=" + this.value + ", derivative=" + this.derivativeValue + '}';
        }

        double solve(double guess, double target) {
            this.setGuess(guess);
            this.setCandidate(guess);
            this.i = 0L;
            while (this.i < NewtonRaphson.this.iterations) {
                this.setValue(NewtonRaphson.this.func.applyAsDouble(this.candidate) - target);
                if (Math.abs(this.value) < NewtonRaphson.this.tolerance) {
                    return this.candidate;
                }
                this.setDerivativeValue(NewtonRaphson.this.derivative.applyAsDouble(this.candidate));
                this.setCandidate(this.candidate - this.value / this.derivativeValue);
                ++this.i;
            }
            throw new NonconvergenceException(guess, NewtonRaphson.this.iterations);
        }
    }

    public static class Builder {
        private DoubleUnaryOperator func;
        private DoubleUnaryOperator derivative;
        private double tolerance = 1.0E-7;
        private long iterations = 10000L;

        public Builder withFunction(DoubleUnaryOperator func) {
            this.func = func;
            return this;
        }

        public Builder withDerivative(DoubleUnaryOperator derivative) {
            this.derivative = derivative;
            return this;
        }

        public Builder withTolerance(double tolerance) {
            this.tolerance = tolerance;
            return this;
        }

        public Builder withIterations(long iterations) {
            this.iterations = iterations;
            return this;
        }

        public NewtonRaphson build() {
            return new NewtonRaphson(this.func, this.derivative, this.tolerance, this.iterations);
        }

        public double findRoot(double guess) {
            return this.build().findRoot(guess);
        }
    }
}

