/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send.embedded.personnel;

import java.util.ArrayList;
import java.util.List;
import org.dbflute.mail.Postcard;
import org.dbflute.mail.send.SMailPostalMotorbike;
import org.dbflute.mail.send.SMailPostalPersonnel;
import org.dbflute.mail.send.SMailPostie;
import org.dbflute.mail.send.SMailReceptionist;
import org.dbflute.mail.send.SMailTextProofreader;
import org.dbflute.mail.send.embedded.postie.SMailHonestPostie;
import org.dbflute.mail.send.embedded.proofreader.SMailBatchProofreader;
import org.dbflute.mail.send.embedded.proofreader.SMailPmCommentProofreader;
import org.dbflute.mail.send.embedded.receptionist.SMailConventionReceptionist;
import org.dbflute.mail.send.supplement.async.SMailAsyncStrategy;
import org.dbflute.mail.send.supplement.filter.SMailAddressFilter;
import org.dbflute.mail.send.supplement.filter.SMailBodyTextFilter;
import org.dbflute.mail.send.supplement.filter.SMailCancelFilter;
import org.dbflute.mail.send.supplement.filter.SMailSubjectFilter;
import org.dbflute.mail.send.supplement.header.SMailMailHeaderStrategy;
import org.dbflute.mail.send.supplement.inetaddr.SMailInternetAddressCreator;
import org.dbflute.mail.send.supplement.label.SMailLabelStrategy;
import org.dbflute.mail.send.supplement.logging.SMailLoggingStrategy;
import org.dbflute.mail.send.supplement.retry.SMailRetryStrategy;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfTypeUtil;

public class SMailDogmaticPostalPersonnel
implements SMailPostalPersonnel {
    public static final String CLASSPATH_BASEDIR = "mail";
    protected final SMailReceptionist receptionist = this.createReceptionist();
    protected final SMailTextProofreader proofreader = this.createProofreader();
    protected final OptionalThing<SMailCancelFilter> cancelFilter = this.createCancelFilter();
    protected final OptionalThing<SMailAddressFilter> addressFilter = this.createAddressFilter();
    protected final OptionalThing<SMailSubjectFilter> subjectFilter = this.createSubjectFilter();
    protected final OptionalThing<SMailBodyTextFilter> bodyTextFilter = this.createBodyTextFilter();
    protected final OptionalThing<SMailAsyncStrategy> asyncStrategy = this.createAsyncStrategy();
    protected final OptionalThing<SMailRetryStrategy> retryStrategy = this.createRetryStrategy();
    protected final OptionalThing<SMailLabelStrategy> labelStrategy = this.createLabelStrategy();
    protected final OptionalThing<SMailLoggingStrategy> loggingStrategy = this.createLoggingStrategy();
    protected final OptionalThing<SMailMailHeaderStrategy> mailHeaderStrategy = this.createMailHeaderStrategy();
    protected final OptionalThing<SMailInternetAddressCreator> internetAddressCreator = this.createInternetAddressCreator();
    protected boolean training;

    @Override
    public void workingDispose() {
        this.receptionist.workingDispose();
        this.proofreader.workingDispose();
    }

    protected SMailReceptionist createReceptionist() {
        return this.createConventionReceptionist();
    }

    protected SMailConventionReceptionist createConventionReceptionist() {
        return this.newMailConventionReceptionist().asClasspathBase(CLASSPATH_BASEDIR);
    }

    protected SMailConventionReceptionist newMailConventionReceptionist() {
        return new SMailConventionReceptionist();
    }

    protected SMailTextProofreader createProofreader() {
        ArrayList<SMailTextProofreader> readerList = new ArrayList<SMailTextProofreader>(4);
        this.setupProofreader(readerList);
        return new SMailBatchProofreader(readerList);
    }

    protected void setupProofreader(List<SMailTextProofreader> readerList) {
        readerList.add(this.createTemplateProofreader());
    }

    protected SMailTextProofreader createTemplateProofreader() {
        return this.newMailPmCommentProofreader();
    }

    protected SMailPmCommentProofreader newMailPmCommentProofreader() {
        return new SMailPmCommentProofreader();
    }

    protected OptionalThing<SMailCancelFilter> createCancelFilter() {
        return OptionalThing.empty();
    }

    protected OptionalThing<SMailAddressFilter> createAddressFilter() {
        return OptionalThing.empty();
    }

    protected OptionalThing<SMailSubjectFilter> createSubjectFilter() {
        return OptionalThing.empty();
    }

    protected OptionalThing<SMailBodyTextFilter> createBodyTextFilter() {
        return OptionalThing.empty();
    }

    protected OptionalThing<SMailLabelStrategy> createLabelStrategy() {
        return OptionalThing.empty();
    }

    protected OptionalThing<SMailAsyncStrategy> createAsyncStrategy() {
        return OptionalThing.empty();
    }

    protected OptionalThing<SMailRetryStrategy> createRetryStrategy() {
        return OptionalThing.empty();
    }

    protected OptionalThing<SMailLoggingStrategy> createLoggingStrategy() {
        return OptionalThing.empty();
    }

    protected OptionalThing<SMailMailHeaderStrategy> createMailHeaderStrategy() {
        return OptionalThing.empty();
    }

    protected OptionalThing<SMailInternetAddressCreator> createInternetAddressCreator() {
        return OptionalThing.empty();
    }

    public SMailDogmaticPostalPersonnel asTraining() {
        this.training = true;
        return this;
    }

    @Override
    public SMailReceptionist selectReceptionist(Postcard postcard) {
        return this.receptionist;
    }

    @Override
    public SMailTextProofreader selectProofreader(Postcard postcard) {
        return this.proofreader;
    }

    @Override
    public SMailPostie selectPostie(Postcard postcard, SMailPostalMotorbike motorbike) {
        SMailHonestPostie postie = this.newMailHonestPostie(motorbike);
        this.cancelFilter.ifPresent(filter -> postie.withCancelFilter((SMailCancelFilter)filter));
        this.addressFilter.ifPresent(filter -> postie.withAddressFilter((SMailAddressFilter)filter));
        this.subjectFilter.ifPresent(filter -> postie.withSubjectFilter((SMailSubjectFilter)filter));
        this.bodyTextFilter.ifPresent(filter -> postie.withBodyTextFilter((SMailBodyTextFilter)filter));
        this.labelStrategy.ifPresent(filter -> postie.withLabelStrategy((SMailLabelStrategy)filter));
        this.asyncStrategy.ifPresent(strategy -> postie.withAsyncStrategy((SMailAsyncStrategy)strategy));
        this.retryStrategy.ifPresent(strategy -> postie.withRetryStrategy((SMailRetryStrategy)strategy));
        this.loggingStrategy.ifPresent(strategy -> postie.withLoggingStrategy((SMailLoggingStrategy)strategy));
        this.mailHeaderStrategy.ifPresent(strategy -> postie.withMailHeaderStrategy((SMailMailHeaderStrategy)strategy));
        this.internetAddressCreator.ifPresent(creator -> postie.withInternetAddressCreator((SMailInternetAddressCreator)creator));
        return this.training ? postie.asTraining() : postie;
    }

    protected SMailHonestPostie newMailHonestPostie(SMailPostalMotorbike motorbike) {
        return new SMailHonestPostie(motorbike);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DfTypeUtil.toClassTitle((Object)this));
        sb.append(":{").append(this.receptionist);
        sb.append(", ").append(this.proofreader).append(this.training ? ", *training" : "");
        sb.append("}@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    public boolean isTraining() {
        return this.training;
    }
}

