/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.diffmap;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.dbflute.exception.DfPropFileReadFailureException;
import org.dbflute.exception.DfPropFileWriteFailureException;
import org.dbflute.helper.dfmap.DfMapFile;
import org.dbflute.helper.message.ExceptionMessageBuilder;

public class DfDiffMapFile {
    public Map<String, Object> readMap(InputStream ins) {
        DfMapFile mapFile = this.createMapFile();
        try {
            return mapFile.readMap(ins);
        }
        catch (Exception e) {
            this.throwDfPropFileReadFailureException(ins, e);
            return null;
        }
    }

    protected void throwDfPropFileReadFailureException(InputStream ins, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to read the diff-map file.");
        br.addItem("Advice");
        br.addElement("Make sure the map-string is correct in the file.");
        br.addElement("For exapmle, the number of start and end braces are the same.");
        br.addItem("DBFlute Property");
        br.addElement(ins);
        String msg = br.buildExceptionMessage();
        throw new DfPropFileReadFailureException(msg, e);
    }

    public void writeMap(OutputStream ous, Map<String, Object> map) {
        DfMapFile mapFile = this.createMapFile();
        try {
            mapFile.writeMap(ous, map);
        }
        catch (Exception e) {
            this.throwDfPropFileWriteFailureException(ous, e);
        }
    }

    protected void throwDfPropFileWriteFailureException(OutputStream ous, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to write the diff-map file.");
        br.addItem("DBFlute Property");
        br.addElement(ous);
        String msg = br.buildExceptionMessage();
        throw new DfPropFileWriteFailureException(msg, e);
    }

    protected DfMapFile createMapFile() {
        return new DfMapFile();
    }
}

