/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.dbway;

import java.util.HashMap;
import java.util.Map;
import org.dbflute.dbway.DBWay;
import org.dbflute.dbway.WayOfDB2;
import org.dbflute.dbway.WayOfDerby;
import org.dbflute.dbway.WayOfFirebird;
import org.dbflute.dbway.WayOfH2;
import org.dbflute.dbway.WayOfMSAccess;
import org.dbflute.dbway.WayOfMySQL;
import org.dbflute.dbway.WayOfOracle;
import org.dbflute.dbway.WayOfPostgreSQL;
import org.dbflute.dbway.WayOfSQLServer;
import org.dbflute.dbway.WayOfSQLite;
import org.dbflute.dbway.WayOfSybase;
import org.dbflute.dbway.WayOfUnknown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DBDef {
    MySQL("mysql", null, new WayOfMySQL()),
    PostgreSQL("postgresql", "postgre", new WayOfPostgreSQL()),
    Oracle("oracle", null, new WayOfOracle()),
    DB2("db2", null, new WayOfDB2()),
    SQLServer("sqlserver", "mssql", new WayOfSQLServer()),
    H2("h2", null, new WayOfH2()),
    Derby("derby", null, new WayOfDerby()),
    SQLite("sqlite", null, new WayOfSQLite()),
    MSAccess("msaccess", null, new WayOfMSAccess()),
    Firebird("firebird", null, new WayOfFirebird()),
    Sybase("sybase", null, new WayOfSybase()),
    Unknown("unknown", null, new WayOfUnknown());

    private static final Logger _log;
    private static final Map<String, DBDef> _codeValueMap;
    private static final Map<String, DBDef> _codeAliasValueMap;
    private final String _code;
    private final String _codeAlias;
    private DBWay _dbway;
    private boolean _locked = true;

    public static DBDef codeOf(String code) {
        if (code == null) {
            return null;
        }
        String lowerCaseCode = code.toLowerCase();
        DBDef def = _codeValueMap.get(lowerCaseCode);
        if (def == null) {
            def = _codeAliasValueMap.get(lowerCaseCode);
        }
        return def;
    }

    private DBDef(String code, String codeAlias, DBWay dbway) {
        this._code = code;
        this._codeAlias = codeAlias;
        this._dbway = dbway;
    }

    public String code() {
        return this._code;
    }

    private String codeAlias() {
        return this._codeAlias;
    }

    public DBWay dbway() {
        return this._dbway;
    }

    public void switchDBWay(DBWay dbway) {
        if (dbway == null) {
            String msg = "The argument 'dbway' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this.assertUnlocked();
        String oldName = this._dbway.getClass().getSimpleName();
        if (_log.isInfoEnabled()) {
            _log.info("...Switching DB way from " + oldName + " to " + dbway);
        }
        this._dbway = dbway;
        this.lock();
    }

    public void lock() {
        if (this._locked) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("...Locking the singleton world of the DB definition!");
        }
        this._locked = true;
    }

    public void unlock() {
        if (!this._locked) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info("...Unlocking the singleton world of the DB definition!");
        }
        this._locked = false;
    }

    public boolean isLocked() {
        return this._locked;
    }

    protected void assertUnlocked() {
        if (!this.isLocked()) {
            return;
        }
        throw new IllegalStateException("The DB definition is locked.");
    }

    static {
        _log = LoggerFactory.getLogger(DBDef.class);
        _codeValueMap = new HashMap<String, DBDef>();
        for (DBDef value : DBDef.values()) {
            _codeValueMap.put(value.code().toLowerCase(), value);
        }
        _codeAliasValueMap = new HashMap<String, DBDef>();
        for (DBDef value : DBDef.values()) {
            if (value.codeAlias() == null) continue;
            _codeAliasValueMap.put(value.codeAlias().toLowerCase(), value);
        }
    }
}

