/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.sqlclause.join;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dbflute.cbean.sqlclause.join.FixedConditionResolver;
import org.dbflute.cbean.sqlclause.query.QueryClause;
import org.dbflute.dbmeta.name.ColumnRealName;

public class LeftOuterJoinInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String _foreignAliasName;
    protected String _foreignTableDbName;
    protected String _localAliasName;
    protected String _localTableDbName;
    protected Map<ColumnRealName, ColumnRealName> _joinOnMap;
    protected LeftOuterJoinInfo _localJoinInfo;
    protected String _relationPath;
    protected boolean _pureFK;
    protected boolean _notNullFKColumn;
    protected final List<QueryClause> _inlineWhereClauseList = new ArrayList<QueryClause>();
    protected final List<QueryClause> _additionalOnClauseList = new ArrayList<QueryClause>();
    protected String _fixedCondition;
    protected FixedConditionResolver _fixedConditionResolver;
    protected boolean _fixedConditionOverRelation;
    protected boolean _innerJoin;
    protected boolean _underInnerJoin;
    protected boolean _whereUsedJoin;
    protected boolean _underOverRelation;

    public boolean hasInlineOrOnClause() {
        return !this._inlineWhereClauseList.isEmpty() || !this._additionalOnClauseList.isEmpty();
    }

    public boolean hasFixedCondition() {
        return this._fixedCondition != null && this._fixedCondition.trim().length() > 0;
    }

    public void resolveFixedCondition() {
        if (this.hasFixedCondition() && this._fixedConditionResolver != null) {
            this._fixedConditionOverRelation = this._fixedConditionResolver.hasOverRelation(this._fixedCondition);
            this._fixedCondition = this._fixedConditionResolver.resolveVariable(this._fixedCondition, false);
            this.determineUnderOverRelation();
        }
    }

    public boolean hasFixedConditionOverRelation() {
        return this._fixedConditionOverRelation;
    }

    public String resolveFixedInlineView(String foreignTableSqlName, boolean canBeInnerJoin) {
        if (this.hasFixedCondition() && this._fixedConditionResolver != null) {
            return this._fixedConditionResolver.resolveFixedInlineView(foreignTableSqlName, canBeInnerJoin);
        }
        return foreignTableSqlName.toString();
    }

    protected void determineUnderOverRelation() {
        if (this.hasFixedConditionOverRelation()) {
            for (LeftOuterJoinInfo current = this._localJoinInfo; current != null; current = current.getLocalJoinInfo()) {
                current.setUnderOverRelation(true);
            }
        }
    }

    public boolean isCountableJoin() {
        return this.isInnerJoin() || this.isUnderInnerJoin() || this.isWhereUsedJoin();
    }

    public boolean isStructuralPossibleInnerJoin() {
        if (!this.isPureStructuralPossibleInnerJoin()) {
            return false;
        }
        for (LeftOuterJoinInfo current = this._localJoinInfo; current != null; current = current.getLocalJoinInfo()) {
            if (current.isTraceStructuralPossibleInnerJoin()) continue;
            return false;
        }
        return true;
    }

    protected boolean isPureStructuralPossibleInnerJoin() {
        return !this.hasInlineOrOnClause() && this._pureFK && this._notNullFKColumn;
    }

    protected boolean isTraceStructuralPossibleInnerJoin() {
        return this.isInnerJoin() || this.isPureStructuralPossibleInnerJoin();
    }

    public String getForeignAliasName() {
        return this._foreignAliasName;
    }

    public void setForeignAliasName(String foreignAliasName) {
        this._foreignAliasName = foreignAliasName;
    }

    public String getForeignTableDbName() {
        return this._foreignTableDbName;
    }

    public void setForeignTableDbName(String foreignTableDbName) {
        this._foreignTableDbName = foreignTableDbName;
    }

    public String getLocalAliasName() {
        return this._localAliasName;
    }

    public void setLocalAliasName(String localAliasName) {
        this._localAliasName = localAliasName;
    }

    public String getLocalTableDbName() {
        return this._localTableDbName;
    }

    public void setLocalTableDbName(String localTableDbName) {
        this._localTableDbName = localTableDbName;
    }

    public Map<ColumnRealName, ColumnRealName> getJoinOnMap() {
        return this._joinOnMap;
    }

    public void setJoinOnMap(Map<ColumnRealName, ColumnRealName> joinOnMap) {
        this._joinOnMap = joinOnMap;
    }

    public LeftOuterJoinInfo getLocalJoinInfo() {
        return this._localJoinInfo;
    }

    public void setLocalJoinInfo(LeftOuterJoinInfo localJoinInfo) {
        this._localJoinInfo = localJoinInfo;
    }

    public String getRelationPath() {
        return this._relationPath;
    }

    public void setRelationPath(String relationPath) {
        this._relationPath = relationPath;
    }

    public boolean getPureFK() {
        return this._pureFK;
    }

    public void setPureFK(boolean pureFK) {
        this._pureFK = pureFK;
    }

    public boolean getNotNullFKColumn() {
        return this._notNullFKColumn;
    }

    public void setNotNullFKColumn(boolean notNullFKColumn) {
        this._notNullFKColumn = notNullFKColumn;
    }

    public List<QueryClause> getInlineWhereClauseList() {
        return this._inlineWhereClauseList;
    }

    public void addInlineWhereClause(QueryClause inlineWhereClause) {
        this._inlineWhereClauseList.add(inlineWhereClause);
    }

    public List<QueryClause> getAdditionalOnClauseList() {
        return this._additionalOnClauseList;
    }

    public void addAdditionalOnClause(QueryClause additionalOnClause) {
        this._additionalOnClauseList.add(additionalOnClause);
    }

    public String getFixedCondition() {
        return this._fixedCondition;
    }

    public void setFixedCondition(String fixedCondition) {
        this._fixedCondition = fixedCondition;
    }

    public FixedConditionResolver getFixedConditionResolver() {
        return this._fixedConditionResolver;
    }

    public void setFixedConditionResolver(FixedConditionResolver fixedConditionResolver) {
        this._fixedConditionResolver = fixedConditionResolver;
    }

    public boolean isInnerJoin() {
        return this._innerJoin;
    }

    public void setInnerJoin(boolean innerJoin) {
        this._innerJoin = innerJoin;
    }

    public boolean isUnderInnerJoin() {
        return this._underInnerJoin;
    }

    public void setUnderInnerJoin(boolean underInnerJoin) {
        this._underInnerJoin = underInnerJoin;
    }

    public boolean isWhereUsedJoin() {
        return this._whereUsedJoin;
    }

    public void setWhereUsedJoin(boolean whereUsedJoin) {
        this._whereUsedJoin = whereUsedJoin;
    }

    public boolean isUnderOverRelation() {
        return this._underOverRelation;
    }

    public void setUnderOverRelation(boolean underOverRelation) {
        this._underOverRelation = underOverRelation;
    }
}

