/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.chelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dbflute.cbean.ConditionQuery;
import org.dbflute.cbean.sqlclause.join.FixedConditionResolver;
import org.dbflute.cbean.sqlclause.subquery.SubQueryIndentProcessor;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.DBMetaProvider;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.info.ForeignInfo;
import org.dbflute.dbmeta.name.TableSqlName;
import org.dbflute.exception.DBMetaNotFoundException;
import org.dbflute.exception.FixedConditionIllegalOverRelationException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.util.Srl;

public class HpFixedConditionQueryResolver
implements FixedConditionResolver {
    public static final String LOCAL_ALIAS_MARK = "$$localAlias$$";
    public static final String FOREIGN_ALIAS_MARK = "$$foreignAlias$$";
    public static final String SQ_BEGIN_MARK = "$$sqbegin$$";
    public static final String SQ_END_MARK = "$$sqend$$";
    public static final String INLINE_MARK = "$$inline$$";
    public static final String LOCATION_BASE_MARK = "$$locationBase$$";
    public static final String OPTIMIZED_MARK = "$$optimized$$";
    protected final ConditionQuery _localCQ;
    protected final ConditionQuery _foreignCQ;
    protected final DBMetaProvider _dbmetaProvider;
    protected String _resolvedFixedCondition;
    protected Map<String, InlineViewResource> _inlineViewResourceMap;
    protected String _inlineViewOptimizedCondition;
    protected boolean _inlineViewOptimizationWholeCondition;
    protected Set<Integer> _inlineViewOptimizedLineNumberSet;

    public HpFixedConditionQueryResolver(ConditionQuery localCQ, ConditionQuery foreignCQ, DBMetaProvider dbmetaProvider) {
        this._localCQ = localCQ;
        this._foreignCQ = foreignCQ;
        this._dbmetaProvider = dbmetaProvider;
    }

    @Override
    public String resolveVariable(String fixedCondition, boolean fixedInline) {
        String inlineCondition;
        String filtered;
        fixedCondition = this.filterLocationMark(fixedCondition, fixedInline);
        this.analyzeInlineViewOptimization(fixedCondition, fixedInline);
        fixedCondition = this.filterBasicMark(fixedCondition, fixedInline);
        fixedCondition = this.filterSubQueryIndentMark(fixedCondition, fixedInline, false);
        fixedCondition = this.resolveOverRelation(fixedCondition, fixedInline);
        String delimiter = this.getInlineMark();
        String resolvedFixedCondition = fixedCondition.contains(delimiter) ? ((filtered = Srl.rtrim(inlineCondition = Srl.substringFirstFront(fixedCondition, delimiter))).trim().length() > 0 ? filtered : OPTIMIZED_MARK) : (this._inlineViewOptimizationWholeCondition ? OPTIMIZED_MARK : fixedCondition);
        this._resolvedFixedCondition = resolvedFixedCondition;
        return this._resolvedFixedCondition;
    }

    protected void analyzeInlineViewOptimization(String fixedCondition, boolean fixedInline) {
        if (fixedInline) {
            return;
        }
        if (!this.hasFixedInlineView(fixedCondition)) {
            return;
        }
        if (this.doAnalyzeInlineViewOptimizationMark(fixedCondition)) {
            return;
        }
        if (this.doAnalyzeInlineViewOptimizationWhole(fixedCondition)) {
            return;
        }
        if (this.doAnalyzeInlineViewOptimizationPart(fixedCondition)) {
            return;
        }
    }

    protected boolean hasFixedInlineView(String fixedCondition) {
        String relationBeginMark = this.getRelationBeginMark();
        String foreignTableMark = this.getForeignTableMark();
        String foreignOverMark = relationBeginMark + foreignTableMark;
        return fixedCondition.contains(foreignOverMark);
    }

    protected boolean doAnalyzeInlineViewOptimizationMark(String fixedCondition) {
        String delimiter = this.getInlineMark();
        if (fixedCondition.contains(delimiter)) {
            String inlineCondition = Srl.substringFirstRear(fixedCondition, delimiter);
            String filtered = this.removePrefixConnector(inlineCondition);
            this._inlineViewOptimizedCondition = filtered.trim().length() > 0 ? filtered : null;
            return true;
        }
        return false;
    }

    protected boolean doAnalyzeInlineViewOptimizationWhole(String fixedCondition) {
        this._inlineViewOptimizationWholeCondition = this.canBeInlineViewOptimization(fixedCondition);
        if (this._inlineViewOptimizationWholeCondition) {
            this._inlineViewOptimizedCondition = fixedCondition;
            return true;
        }
        return false;
    }

    protected boolean doAnalyzeInlineViewOptimizationPart(String fixedCondition) {
        String ifCommentMark = "/*IF";
        if (fixedCondition.contains("/*IF")) {
            return false;
        }
        List<String> lineList = Srl.splitList(fixedCondition, this.ln());
        String previous = null;
        ArrayList<String> optLineList = new ArrayList<String>();
        ArrayList<Integer> optLineNumberList = new ArrayList<Integer>(lineList.size());
        int lineNumber = 1;
        for (String current : lineList) {
            if (this.isCandidateOfOptimization(previous) && this.isOptimizationHitLine(previous, current, lineNumber)) {
                optLineList.add(previous);
                optLineNumberList.add(lineNumber - 1);
            }
            previous = current;
            ++lineNumber;
        }
        if (this.isCandidateOfOptimization(previous) && this.startsWithConnector(previous)) {
            optLineList.add(previous);
            optLineNumberList.add(lineNumber - 1);
        }
        if (!optLineNumberList.isEmpty()) {
            this._inlineViewOptimizedLineNumberSet = new HashSet<Integer>(optLineNumberList);
        }
        if (!optLineList.isEmpty()) {
            StringBuilder optSb = new StringBuilder();
            for (String line : optLineList) {
                if (optSb.length() > 0) {
                    optSb.append(this.ln());
                }
                optSb.append(line);
            }
            this._inlineViewOptimizedCondition = this.removePrefixConnector(optSb.toString());
            return true;
        }
        return false;
    }

    protected boolean isCandidateOfOptimization(String previous) {
        return previous != null && this.canBeInlineViewOptimization(previous) && !this.hasUnclosedBrace(previous);
    }

    protected boolean isOptimizationHitLine(String previous, String current, int lineNumber) {
        if (lineNumber == 2 || lineNumber >= 3 && this.startsWithConnector(previous)) {
            return this.startsWithConnector(current);
        }
        return false;
    }

    protected boolean canBeInlineViewOptimization(String fixedCondition) {
        String relationBeginMark = this.getRelationBeginMark();
        String foreignTableMark = this.getForeignTableMark();
        String foreignOverMark = relationBeginMark + foreignTableMark;
        String foreignAliasMark = this.getForeignAliasMark();
        if (!Srl.containsAny(fixedCondition, foreignOverMark, foreignAliasMark)) {
            return false;
        }
        String removedCondition = this.replaceString(fixedCondition, foreignOverMark, "");
        if (removedCondition.contains(relationBeginMark)) {
            return false;
        }
        String localAliasMark = this.getLocalAliasMark();
        return !removedCondition.contains(localAliasMark);
    }

    protected String filterBasicMark(String fixedCondition, boolean fixedInline) {
        String localAliasName = this._localCQ.xgetAliasName();
        String foreignAliasName = this._foreignCQ.xgetAliasName();
        fixedCondition = this.replaceString(fixedCondition, "$$alias$$", foreignAliasName);
        fixedCondition = this.replaceString(fixedCondition, this.getLocalAliasMark(), localAliasName);
        if (!this._inlineViewOptimizationWholeCondition) {
            fixedCondition = this.replaceString(fixedCondition, this.getForeignAliasMark(), foreignAliasName);
        }
        return fixedCondition;
    }

    protected String filterSubQueryIndentMark(String fixedCondition, boolean fixedInline, boolean optimized) {
        String sqBeginMark = this.getSqBeginMark();
        String sqEndMark = this.getSqEndMark();
        if (!fixedCondition.contains(sqBeginMark) || !fixedCondition.contains(sqEndMark)) {
            return fixedCondition;
        }
        String sqEndIndent = this.calculateSqEndIndent(fixedInline, optimized);
        String indentFrom = "\n)" + sqEndMark;
        String indentTo = "\n" + sqEndIndent + ")" + sqEndMark;
        fixedCondition = Srl.replace(fixedCondition, indentFrom, indentTo);
        SubQueryIndentProcessor processor = new SubQueryIndentProcessor();
        String foreignAliasName = this._foreignCQ.xgetAliasName();
        String subQueryIdentity = "fixed_" + foreignAliasName;
        String beginMark = processor.resolveSubQueryBeginMark(subQueryIdentity);
        fixedCondition = Srl.replace(fixedCondition, sqBeginMark, beginMark);
        String endMark = processor.resolveSubQueryEndMark(subQueryIdentity);
        fixedCondition = Srl.replace(fixedCondition, sqEndMark, endMark);
        return fixedCondition;
    }

    protected String calculateSqEndIndent(boolean fixedInline, boolean optimized) {
        String indent = fixedInline ? "                            " : (optimized ? "        " : "         ");
        return indent;
    }

    protected String filterLocationMark(String fixedCondition, boolean fixedInline) {
        String locationBase = this._localCQ.xgetLocationBase();
        return this.replaceString(fixedCondition, this.getLocationBaseMark() + ".", "pmb." + locationBase);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String resolveOverRelation(String fixedCondition, boolean fixedInline) {
        String resolvedClause;
        String relationBeginMark = this.getRelationBeginMark();
        String relationEndMark = this.getRelationEndMark();
        String remainder = resolvedClause = fixedCondition;
        while (true) {
            ConditionQuery columnTargetCQ;
            String relationVariable;
            Srl.IndexOfInfo relationEndIndex;
            block20: {
                ConditionQuery referrerQuery;
                String notice;
                DBMeta pointDBMeta;
                ConditionQuery relationPointCQ;
                String targetRelation;
                String pointTable;
                block18: {
                    String notice2;
                    String secondArg;
                    block19: {
                        Srl.IndexOfInfo relationBeginIndex;
                        if ((relationBeginIndex = Srl.indexOfFirst(remainder, relationBeginMark)) == null || (relationEndIndex = Srl.indexOfFirst(remainder = relationBeginIndex.substringRear(), relationEndMark)) == null) break block18;
                        String relationExp = relationEndIndex.substringFront();
                        relationVariable = relationBeginMark + relationExp + relationEndMark;
                        Srl.IndexOfInfo separatorIndex = Srl.indexOfFirst(relationExp, ".");
                        if (separatorIndex != null) {
                            pointTable = separatorIndex.substringFrontTrimmed();
                            String separatorRear = separatorIndex.substringRearTrimmed();
                            Srl.IndexOfInfo argIndex = Srl.indexOfFirst(separatorRear, ",");
                            targetRelation = argIndex != null ? argIndex.substringFrontTrimmed() : separatorRear;
                            secondArg = argIndex != null ? argIndex.substringRearTrimmed() : null;
                        } else {
                            Srl.IndexOfInfo argIndex = Srl.indexOfFirst(relationExp, ",");
                            pointTable = argIndex != null ? argIndex.substringFrontTrimmed() : Srl.trim(relationExp);
                            targetRelation = null;
                            String string = secondArg = argIndex != null ? argIndex.substringRearTrimmed() : null;
                        }
                        if (!Srl.equalsPlain(pointTable, this.getLocalTableMark())) break block19;
                        relationPointCQ = this._localCQ;
                        if (targetRelation == null) {
                            notice2 = "The relation on fixed condition is required if the table is not referrer.";
                            this.throwIllegalFixedConditionOverRelationException(notice2, pointTable, null, fixedCondition);
                            return null;
                        }
                        columnTargetCQ = this.invokeColumnTargetCQ(relationPointCQ, targetRelation);
                        break block20;
                    }
                    if (Srl.equalsPlain(pointTable, this.getForeignTableMark())) {
                        List<ForeignInfo> joinInfoList;
                        InlineViewResource resource;
                        columnTargetCQ = relationPointCQ = this._foreignCQ;
                        if (targetRelation == null) {
                            notice2 = "The relation on fixed condition is required if the table is not referrer.";
                            this.throwIllegalFixedConditionOverRelationException(notice2, pointTable, null, fixedCondition);
                            return null;
                        }
                        if (this._inlineViewResourceMap == null) {
                            this._inlineViewResourceMap = new LinkedHashMap<String, InlineViewResource>();
                        }
                        if (this._inlineViewResourceMap.containsKey(targetRelation)) {
                            resource = this._inlineViewResourceMap.get(targetRelation);
                        } else {
                            resource = new InlineViewResource();
                            this._inlineViewResourceMap.put(targetRelation, resource);
                        }
                        Srl.IndexOfInfo rearIndex = Srl.indexOfFirst(relationEndIndex.substringRearTrimmed(), ".");
                        if (rearIndex == null || rearIndex.getIndex() > 0) {
                            String notice3 = "The OverRelation variable should continue to column after the variable.";
                            this.throwIllegalFixedConditionOverRelationException(notice3, pointTable, targetRelation, fixedCondition);
                            return null;
                        }
                        String columnStart = rearIndex.substringRear();
                        Srl.IndexOfInfo indexInfo = Srl.indexOfFirst(columnStart, " ", ",", ")", "\n", "\t");
                        String columnName = indexInfo != null ? indexInfo.substringFront() : columnStart;
                        String resolvedColumn = secondArg != null ? secondArg + " as " + columnName : columnName;
                        resource.addAdditionalColumn(resolvedColumn);
                        if (!resource.hasJoinInfo()) {
                            List<String> traceList = Srl.splitList(targetRelation, ".");
                            DBMeta currentDBMeta = this._dbmetaProvider.provideDBMeta(this._foreignCQ.asTableDbName());
                            for (String trace : traceList) {
                                ForeignInfo foreignInfo = currentDBMeta.findForeignInfo(trace);
                                resource.addJoinInfo(foreignInfo);
                                currentDBMeta = foreignInfo.getForeignDBMeta();
                            }
                        }
                        if (!(joinInfoList = resource.getJoinInfoList()).isEmpty()) {
                            ForeignInfo latestForeignInfo = joinInfoList.get(joinInfoList.size() - 1);
                            resource.addOptimizedVariable(relationVariable, latestForeignInfo);
                        }
                        break block20;
                    } else {
                        try {
                            pointDBMeta = this._dbmetaProvider.provideDBMeta(pointTable);
                        }
                        catch (DBMetaNotFoundException e) {
                            notice = "The table for relation on fixed condition does not exist.";
                            this.throwIllegalFixedConditionOverRelationException(notice, pointTable, targetRelation, fixedCondition, e);
                            return null;
                        }
                    }
                }
                return this.adjustOptimizedLine(resolvedClause);
                for (referrerQuery = this._localCQ.xgetReferrerQuery(); referrerQuery != null && !Srl.equalsPlain(pointDBMeta.getTableDbName(), referrerQuery.asTableDbName()); referrerQuery = referrerQuery.xgetReferrerQuery()) {
                }
                relationPointCQ = referrerQuery;
                if (relationPointCQ == null) {
                    notice = "The table for relation on fixed condition was not found in the scope.";
                    this.throwIllegalFixedConditionOverRelationException(notice, pointTable, targetRelation, fixedCondition);
                    return null;
                }
                columnTargetCQ = targetRelation != null ? this.invokeColumnTargetCQ(relationPointCQ, targetRelation) : relationPointCQ;
            }
            String relationAlias = columnTargetCQ.xgetAliasName();
            resolvedClause = this.replaceString(resolvedClause, relationVariable, relationAlias);
            remainder = relationEndIndex.substringRear();
        }
    }

    protected ConditionQuery invokeColumnTargetCQ(ConditionQuery relationPointCQ, String targetRelation) {
        return relationPointCQ.invokeForeignCQ(targetRelation);
    }

    protected String adjustOptimizedLine(String resolvedClause) {
        if (this._inlineViewOptimizedLineNumberSet == null) {
            return resolvedClause;
        }
        List<String> lineList = Srl.splitList(resolvedClause, this.ln());
        ArrayList<String> filteredList = new ArrayList<String>();
        int lineNumber = 1;
        for (String line : lineList) {
            if (!this._inlineViewOptimizedLineNumberSet.contains(lineNumber)) {
                filteredList.add(line);
            }
            ++lineNumber;
        }
        StringBuilder filteredSb = new StringBuilder();
        for (String line : filteredList) {
            if (filteredSb.length() > 0) {
                filteredSb.append(this.ln());
            }
            filteredSb.append(line);
        }
        return this.removePrefixConnector(filteredSb.toString());
    }

    @Override
    public String resolveFixedInlineView(String foreignTableSqlName, boolean treatedAsInnerJoin) {
        if (this._inlineViewResourceMap == null || this._inlineViewResourceMap.isEmpty()) {
            return foreignTableSqlName;
        }
        String baseAlias = "dffixedbase";
        String baseIndent = treatedAsInnerJoin ? "               " : "                    ";
        StringBuilder joinSb = new StringBuilder();
        HashMap<ForeignInfo, String> relationMap = new HashMap<ForeignInfo, String>();
        ArrayList<String> additionalRealColumnList = new ArrayList<String>();
        String resolvedFixedCondition = this._resolvedFixedCondition;
        String optimizedCondition = this._inlineViewOptimizedCondition;
        int groupIndex = 0;
        for (InlineViewResource resource : this._inlineViewResourceMap.values()) {
            List<ForeignInfo> joinInfoList = resource.getJoinInfoList();
            String aliasBase = "dffixedjoin";
            String preForeignAlias = null;
            String foreignAlias = null;
            int joinIndex = 0;
            HashMap<ForeignInfo, String> foreignAliasMap = new HashMap<ForeignInfo, String>(joinInfoList.size());
            for (ForeignInfo joinInfo : joinInfoList) {
                if (relationMap.containsKey(joinInfo)) {
                    preForeignAlias = (String)relationMap.get(joinInfo);
                    continue;
                }
                DBMeta foreignDBMeta = joinInfo.getForeignDBMeta();
                TableSqlName foreignTable = foreignDBMeta.getTableSqlName();
                String localAlias = preForeignAlias != null ? preForeignAlias : "dffixedbase";
                preForeignAlias = foreignAlias = "dffixedjoin_" + groupIndex + "_" + joinIndex;
                joinSb.append(this.ln()).append(baseIndent);
                joinSb.append("     left outer join ").append(foreignTable).append(" ").append(foreignAlias);
                joinSb.append(" on ");
                Map<ColumnInfo, ColumnInfo> columnInfoMap = joinInfo.getLocalForeignColumnInfoMap();
                int columnIndex = 0;
                for (Map.Entry<ColumnInfo, ColumnInfo> localForeignEntry : columnInfoMap.entrySet()) {
                    ColumnInfo localColumnInfo = localForeignEntry.getKey();
                    ColumnInfo foreignColumninfo = localForeignEntry.getValue();
                    if (columnIndex > 0) {
                        joinSb.append(" and ");
                    }
                    joinSb.append(localAlias).append(".").append(localColumnInfo.getColumnSqlName());
                    joinSb.append(" = ").append(foreignAlias).append(".").append(foreignColumninfo.getColumnSqlName());
                    ++columnIndex;
                }
                foreignAliasMap.put(joinInfo, foreignAlias);
                relationMap.put(joinInfo, foreignAlias);
                ++joinIndex;
            }
            if (optimizedCondition != null) {
                optimizedCondition = this.resolvedOptimizedCondition(optimizedCondition, resource, foreignAliasMap);
            }
            this.collectAdditionalRealColumnList(additionalRealColumnList, resolvedFixedCondition, resource, foreignAlias);
            ++groupIndex;
        }
        if (optimizedCondition != null) {
            optimizedCondition = this.replaceString(optimizedCondition, this.getForeignAliasMark(), "dffixedbase");
            optimizedCondition = this.filterSubQueryIndentMark(optimizedCondition, false, true);
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("(select ").append("dffixedbase").append(".*");
        for (String columnName : additionalRealColumnList) {
            sqlSb.append(", ").append(columnName);
        }
        sqlSb.append(this.ln()).append(baseIndent);
        sqlSb.append("   from ").append(foreignTableSqlName).append(" ").append("dffixedbase");
        sqlSb.append((CharSequence)joinSb);
        if (optimizedCondition != null) {
            this.buildOptimizedInlineWhereClause(optimizedCondition, baseIndent, sqlSb);
        }
        sqlSb.append(this.ln()).append(baseIndent);
        sqlSb.append(")");
        return sqlSb.toString();
    }

    protected String resolvedOptimizedCondition(String optimizedCondition, InlineViewResource resource, Map<ForeignInfo, String> foreignAliasMap) {
        Set<String> additionalColumnSet = resource.getAdditionalColumnSet();
        if (additionalColumnSet == null) {
            return optimizedCondition;
        }
        HashMap<String, String> optimizedReverseColumnMap = null;
        for (String columnName : additionalColumnSet) {
            String delimiter = " as ";
            if (!columnName.contains(" as ")) continue;
            if (optimizedReverseColumnMap == null) {
                optimizedReverseColumnMap = new HashMap<String, String>(additionalColumnSet.size());
            }
            String physicalName = Srl.substringLastFront(columnName, " as ");
            String logicalName = Srl.substringLastRear(columnName, " as ");
            optimizedReverseColumnMap.put(logicalName, physicalName);
        }
        optimizedCondition = this.resolveOptimizedForeignAlias(optimizedCondition, resource, foreignAliasMap);
        optimizedCondition = this.reverseOptimizedColumnAlias(optimizedCondition, optimizedReverseColumnMap);
        return optimizedCondition;
    }

    protected String resolveOptimizedForeignAlias(String optimizedCondition, InlineViewResource resource, Map<ForeignInfo, String> foreignAliasMap) {
        if (optimizedCondition == null) {
            return null;
        }
        Map<String, ForeignInfo> optimizedVariableMap = resource.getOptimizedVariableMap();
        if (optimizedVariableMap == null) {
            return optimizedCondition;
        }
        for (Map.Entry<String, ForeignInfo> entry : optimizedVariableMap.entrySet()) {
            String relationVariable = entry.getKey();
            ForeignInfo foreignInfo = entry.getValue();
            String inlineAlias = foreignAliasMap.get(foreignInfo);
            optimizedCondition = this.replaceString(optimizedCondition, relationVariable, inlineAlias);
        }
        return optimizedCondition;
    }

    protected String reverseOptimizedColumnAlias(String optimizedCondition, Map<String, String> optimizedReverseColumnMap) {
        if (optimizedReverseColumnMap != null) {
            for (Map.Entry<String, String> entry : optimizedReverseColumnMap.entrySet()) {
                String logicalName = entry.getKey();
                String physicalName = entry.getValue();
                optimizedCondition = this.replaceString(optimizedCondition, "." + logicalName, "." + physicalName);
            }
        }
        return optimizedCondition;
    }

    protected void collectAdditionalRealColumnList(List<String> additionalRealColumnList, String resolvedFixedCondition, InlineViewResource resource, String foreignAlias) {
        Set<String> additionalColumnSet = resource.getAdditionalColumnSet();
        if (additionalColumnSet == null) {
            return;
        }
        for (String columnName : additionalColumnSet) {
            String columnMark;
            String delimiter = " as ";
            if (columnName.contains(" as ")) {
                String logicalName = Srl.substringLastRear(columnName, " as ");
                columnMark = "." + logicalName;
            } else {
                columnMark = "." + columnName;
            }
            if (resolvedFixedCondition == null || !resolvedFixedCondition.contains(columnMark)) continue;
            additionalRealColumnList.add(foreignAlias + "." + columnName);
        }
    }

    protected void buildOptimizedInlineWhereClause(String optimizedCondition, String baseIndent, StringBuilder sqlSb) {
        sqlSb.append(this.ln()).append(baseIndent);
        sqlSb.append("  where ");
        String sqBeginMark = "--#df:sqbegin#";
        String sqEndMark = "--#df:sqend#";
        List<String> lineList = Srl.splitList(optimizedCondition, this.ln());
        boolean subQueryIndentScope = false;
        int index = 0;
        for (String line : lineList) {
            if (line.contains("--#df:sqend#")) {
                subQueryIndentScope = false;
            }
            if (index == 0) {
                sqlSb.append(line);
            } else {
                String trimmedLine;
                sqlSb.append(this.ln());
                if (!subQueryIndentScope) {
                    sqlSb.append(baseIndent);
                }
                if ((trimmedLine = line.trim()).startsWith("and ")) {
                    sqlSb.append("    ").append(trimmedLine);
                } else {
                    sqlSb.append(line);
                }
            }
            if (line.contains("--#df:sqbegin#")) {
                subQueryIndentScope = true;
            }
            ++index;
        }
    }

    protected void throwIllegalFixedConditionOverRelationException(String notice, String tableName, String relationName, String fixedCondition) {
        this.throwIllegalFixedConditionOverRelationException(notice, tableName, relationName, fixedCondition, null);
    }

    protected void throwIllegalFixedConditionOverRelationException(String notice, String pointTable, String targetRelation, String fixedCondition, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Point Table");
        br.addElement(pointTable);
        br.addItem("Target Relation");
        br.addElement(targetRelation);
        br.addItem("Fixed Condition");
        br.addElement(fixedCondition);
        br.addItem("BizOneToOne's Local");
        br.addElement(this._localCQ.asTableDbName());
        String msg = br.buildExceptionMessage();
        throw new FixedConditionIllegalOverRelationException(msg, e);
    }

    @Override
    public boolean hasOverRelation(String fixedCondition) {
        String relationBeginMark = this.getRelationBeginMark();
        String relationEndMark = this.getRelationEndMark();
        return Srl.containsAll(fixedCondition, relationBeginMark, relationEndMark);
    }

    protected String getLocalAliasMark() {
        return LOCAL_ALIAS_MARK;
    }

    protected String getForeignAliasMark() {
        return FOREIGN_ALIAS_MARK;
    }

    protected String getSqBeginMark() {
        return SQ_BEGIN_MARK;
    }

    protected String getSqEndMark() {
        return SQ_END_MARK;
    }

    protected String getInlineMark() {
        return INLINE_MARK;
    }

    protected String getLocationBaseMark() {
        return LOCATION_BASE_MARK;
    }

    protected String getRelationBeginMark() {
        return "$$over(";
    }

    protected String getRelationEndMark() {
        return ")$$";
    }

    protected String getLocalTableMark() {
        return "$localTable";
    }

    protected String getForeignTableMark() {
        return "$foreignTable";
    }

    protected boolean isOneLine(String fixedCondition) {
        return !fixedCondition.contains(this.ln());
    }

    protected boolean hasUnclosedBrace(String line) {
        return line.contains("(") && !line.contains(")");
    }

    protected boolean startsWithConnector(String line) {
        return line.trim().startsWith("and ");
    }

    protected String removePrefixConnector(String clause) {
        return Srl.ltrim(Srl.ltrim(Srl.ltrim(clause), "and "));
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return Srl.replace(text, fromText, toText);
    }

    protected String ln() {
        return DBFluteSystem.ln();
    }

    protected static class InlineViewResource {
        protected Set<String> _additionalColumnSet;
        protected List<ForeignInfo> _joinInfoList;
        protected Map<String, ForeignInfo> _optimizedVariableMap;

        protected InlineViewResource() {
        }

        public Set<String> getAdditionalColumnSet() {
            return this._additionalColumnSet;
        }

        public void addAdditionalColumn(String additionalColumn) {
            if (this._additionalColumnSet == null) {
                this._additionalColumnSet = new LinkedHashSet<String>();
            }
            this._additionalColumnSet.add(additionalColumn);
        }

        public boolean hasJoinInfo() {
            return this._joinInfoList != null && !this._joinInfoList.isEmpty();
        }

        public List<ForeignInfo> getJoinInfoList() {
            return this._joinInfoList;
        }

        public void addJoinInfo(ForeignInfo joinInfo) {
            if (this._joinInfoList == null) {
                this._joinInfoList = new ArrayList<ForeignInfo>();
            }
            this._joinInfoList.add(joinInfo);
        }

        public Map<String, ForeignInfo> getOptimizedVariableMap() {
            return this._optimizedVariableMap;
        }

        public void addOptimizedVariable(String relationVariable, ForeignInfo foreignInfo) {
            if (this._optimizedVariableMap == null) {
                this._optimizedVariableMap = new HashMap<String, ForeignInfo>();
            }
            this._optimizedVariableMap.put(relationVariable, foreignInfo);
        }
    }
}

