/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.core.command;

import java.util.List;
import org.dbflute.bhv.core.SqlExecution;
import org.dbflute.bhv.core.SqlExecutionCreator;
import org.dbflute.bhv.core.command.AbstractEntityUpdateCommand;
import org.dbflute.bhv.writable.InsertOption;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.s2dao.metadata.TnBeanMetaData;
import org.dbflute.s2dao.sqlcommand.TnInsertEntityDynamicCommand;

public class InsertEntityCommand
extends AbstractEntityUpdateCommand {
    protected InsertOption<? extends ConditionBean> _insertOption;

    @Override
    public String getCommandName() {
        return "insert";
    }

    @Override
    public boolean isInsert() {
        return true;
    }

    @Override
    public SqlExecutionCreator createSqlExecutionCreator() {
        this.assertStatus("createSqlExecutionCreator");
        return () -> {
            TnBeanMetaData bmd = this.createBeanMetaData();
            return this.createInsertEntitySqlExecution(bmd);
        };
    }

    protected SqlExecution createInsertEntitySqlExecution(TnBeanMetaData bmd) {
        SqlExecution nonPrimaryKeySqlExecution = this.createNonPrimaryInsertSqlExecution(bmd);
        if (nonPrimaryKeySqlExecution != null) {
            return nonPrimaryKeySqlExecution;
        }
        String[] propertyNames = this.getPersistentPropertyNames(bmd);
        return this.createInsertEntityDynamicCommand(bmd, propertyNames);
    }

    protected TnInsertEntityDynamicCommand createInsertEntityDynamicCommand(TnBeanMetaData bmd, String[] propertyNames) {
        TnInsertEntityDynamicCommand cmd = this.newInsertEntityDynamicCommand();
        cmd.setBeanMetaData(bmd);
        cmd.setTargetDBMeta(this.findDBMeta());
        cmd.setPropertyNames(propertyNames);
        return cmd;
    }

    protected TnInsertEntityDynamicCommand newInsertEntityDynamicCommand() {
        return new TnInsertEntityDynamicCommand(this._dataSource, this._statementFactory);
    }

    protected SqlExecution createNonPrimaryInsertSqlExecution(TnBeanMetaData bmd) {
        DBMeta dbmeta = this.findDBMeta();
        if (dbmeta.hasPrimaryKey()) {
            return null;
        }
        List<ColumnInfo> columnInfoList = dbmeta.getColumnInfoList();
        StringBuilder columnDefSb = new StringBuilder();
        for (ColumnInfo columnInfo : columnInfoList) {
            columnDefSb.append(", ").append(columnInfo.getColumnSqlName());
        }
        columnDefSb.delete(0, ", ".length()).insert(0, "(").append(")");
        StringBuilder columnValuesSb = new StringBuilder();
        for (ColumnInfo columnInfo : columnInfoList) {
            columnValuesSb.append(", /*pmb.").append(columnInfo.getPropertyName()).append("*/null");
        }
        columnValuesSb.delete(0, ", ".length()).insert(0, "(").append(")");
        String string = "insert into " + dbmeta.getTableSqlName() + columnDefSb + " values" + columnValuesSb;
        return this.createOutsideSqlExecuteExecution(this._entity.getClass(), string);
    }

    @Override
    protected Object[] doGetSqlExecutionArgument() {
        return new Object[]{this._entity, this._insertOption};
    }

    public void setInsertOption(InsertOption<? extends ConditionBean> insertOption) {
        this._insertOption = insertOption;
    }
}

