/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.seg.ansj;

import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.splitWord.analysis.BaseAnalysis;
import org.ansj.splitWord.analysis.IndexAnalysis;
import org.ansj.splitWord.analysis.NlpAnalysis;
import org.ansj.splitWord.analysis.ToAnalysis;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.TermEntityImpl;
import org.datayoo.tripod.seg.TripodSegment;
import org.datayoo.tripod.seg.ansj.AnsjSegmentMode;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.library.Library;

public class AnsjSegmenter
implements TripodSegment {
    protected AnsjSegmentMode segmentMode = AnsjSegmentMode.ACCURATE;
    protected Forest[] forests;

    public AnsjSegmenter() {
    }

    public AnsjSegmenter(AnsjSegmentMode segmentMode) {
        if (segmentMode == null) {
            return;
        }
        this.segmentMode = segmentMode;
    }

    public AnsjSegmenter(AnsjSegmentMode segmentMode, String[] libPaths) throws Exception {
        this(segmentMode);
        if (libPaths != null) {
            this.forests = new Forest[libPaths.length];
            for (int i = 0; i < libPaths.length; ++i) {
                this.forests[i] = Library.makeForest((String)libPaths[i]);
            }
        }
    }

    @Override
    public TermEntity[] segment(String text) {
        if (text == null || text.isEmpty()) {
            return new TermEntity[0];
        }
        Result result = this.segmentMode == AnsjSegmentMode.ACCURATE ? ToAnalysis.parse((String)text, (Forest[])this.forests) : (this.segmentMode == AnsjSegmentMode.BASE ? BaseAnalysis.parse((String)text) : (this.segmentMode == AnsjSegmentMode.NLP ? NlpAnalysis.parse((String)text, (Forest[])this.forests) : IndexAnalysis.parse((String)text, (Forest[])this.forests)));
        return this.toTermEntities(result);
    }

    protected TermEntity[] toTermEntities(Result result) {
        TermEntity[] termEntities = new TermEntity[result.size()];
        int i = 0;
        for (Term term : result) {
            TermEntityImpl te = new TermEntityImpl(term.getName(), term.getOffe());
            te.setPartOfSpeech(term.getNatureStr());
            termEntities[i++] = te;
        }
        return termEntities;
    }
}

