/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.logic;

import java.util.List;
import java.util.Map;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.Operand;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.operand.DecratorOperand;

public class OrOperand
extends DecratorOperand {
    protected Operand lOperand;
    protected Operand rOperand;

    public OrOperand(List<Operand> operands, ExpressionMetadata expressionMetadata, TripodContext context) {
        super(operands, expressionMetadata, context);
        if (operands.size() != 2) {
            throw new IllegalArgumentException("Invalid or operand!");
        }
        this.lOperand = operands.get(0);
        this.rOperand = operands.get(1);
    }

    @Override
    public double operate(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        double score = this.lOperand.operate(documentEntity, termDistance, hitMap);
        if (score > 0.0) {
            if (this.context.isScoring()) {
                return score * (double)this.boost;
            }
            return 1.0;
        }
        score = this.rOperand.operate(documentEntity, termDistance, hitMap);
        if (score > 0.0) {
            if (this.context.isScoring()) {
                return score * (double)this.boost;
            }
            return 1.0;
        }
        return -1.0;
    }
}

