/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.factory;

import java.util.LinkedList;
import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.Operand;
import org.datayoo.tripod.Paren.ParenOperand;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.bool.BoolOperand;
import org.datayoo.tripod.bool.MustNotOperand;
import org.datayoo.tripod.bool.MustOperand;
import org.datayoo.tripod.comp.InOperand;
import org.datayoo.tripod.comp.PhraseOperand;
import org.datayoo.tripod.comp.RangeOperand;
import org.datayoo.tripod.comp.TermFuzzyOperand;
import org.datayoo.tripod.comp.TermMatchOperand;
import org.datayoo.tripod.comp.TermWildcardOperand;
import org.datayoo.tripod.logic.AndOperand;
import org.datayoo.tripod.logic.NotOperand;
import org.datayoo.tripod.logic.OrOperand;
import org.datayoo.tripod.metadata.BinaryMetadata;
import org.datayoo.tripod.metadata.BoolMetadata;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionType;
import org.datayoo.tripod.metadata.FieldMetadata;
import org.datayoo.tripod.metadata.InMetadata;
import org.datayoo.tripod.metadata.RangeMetadata;
import org.datayoo.tripod.metadata.SuffixMetadata;
import org.datayoo.tripod.metadata.TermMetadata;
import org.datayoo.tripod.metadata.UnaryMetadata;
import org.datayoo.tripod.metadata.WildcardMetadata;

public abstract class OperandFactory {
    public static BoolOperand createOperand(BoolMetadata boolMetadata, TripodContext tripodContext) {
        Validate.notNull((Object)boolMetadata, (String)"boolMetadata is null!", (Object[])new Object[0]);
        Validate.notNull((Object)tripodContext, (String)"tripodContext is null!", (Object[])new Object[0]);
        return (BoolOperand)OperandFactory.createOperand(null, (ExpressionMetadata)boolMetadata, tripodContext);
    }

    protected static Operand createOperand(String field, ExpressionMetadata expressionMetadata, TripodContext tripodContext) {
        if (expressionMetadata.getExpressionType() == ExpressionType.SPACE_OR) {
            return OperandFactory.createBoolOperand(field, (BoolMetadata)expressionMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.AND) {
            return OperandFactory.createAndOperand(field, (BinaryMetadata)expressionMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.OR) {
            return OperandFactory.createOrOperand(field, (BinaryMetadata)expressionMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.NOT) {
            return OperandFactory.createNotOperand(field, (UnaryMetadata)expressionMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.MUST) {
            return OperandFactory.createMustOperand(field, (UnaryMetadata)expressionMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.MINUS) {
            return OperandFactory.createMustNotOperand(field, (UnaryMetadata)expressionMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.FIELD) {
            FieldMetadata fieldMetadata = (FieldMetadata)expressionMetadata;
            return OperandFactory.createOperand(fieldMetadata.getField(), fieldMetadata.getExpr(), tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.PAREN) {
            UnaryMetadata unaryMetadata = (UnaryMetadata)expressionMetadata;
            return OperandFactory.createParenOperand(field, unaryMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.RANGE) {
            RangeMetadata rangeMetadata = (RangeMetadata)expressionMetadata;
            return OperandFactory.createRangeOperand(field, rangeMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.IN) {
            InMetadata inMetadata = (InMetadata)expressionMetadata;
            return OperandFactory.createInOperand(field, inMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.PHRASE) {
            return OperandFactory.createPhraseOperand(field, expressionMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.PROXIMITY) {
            return OperandFactory.createPhraseOperand(field, expressionMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.WILDCARD) {
            WildcardMetadata wildcardMetadata = (WildcardMetadata)expressionMetadata;
            return OperandFactory.createTermWildcardOperand(field, wildcardMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.FUZZY) {
            SuffixMetadata suffixMetadata = (SuffixMetadata)expressionMetadata;
            return OperandFactory.createTermFuzzyOperand(field, suffixMetadata, tripodContext);
        }
        if (expressionMetadata.getExpressionType() == ExpressionType.TERM) {
            TermMetadata termMetadata = (TermMetadata)expressionMetadata;
            return OperandFactory.createTermMatchOperand(field, termMetadata, tripodContext);
        }
        throw new IllegalArgumentException(String.format("Invalid expression type '%s'!", expressionMetadata.getExpressionType()));
    }

    protected static BoolOperand createBoolOperand(String field, BoolMetadata boolMetadata, TripodContext tripodContext) {
        LinkedList<Operand> operands = new LinkedList<Operand>();
        for (ExpressionMetadata expressionMetadata : boolMetadata.getBoolExprs()) {
            if (boolMetadata.getBoost() != 1) {
                expressionMetadata.setBoost(boolMetadata.getBoost());
            }
            Operand operand = OperandFactory.createOperand(field, expressionMetadata, tripodContext);
            operands.add(operand);
        }
        return new BoolOperand(operands, (ExpressionMetadata)boolMetadata, tripodContext);
    }

    protected static AndOperand createAndOperand(String field, BinaryMetadata andMetadata, TripodContext tripodContext) {
        LinkedList<Operand> operands = new LinkedList<Operand>();
        Operand operand = OperandFactory.createOperand(field, andMetadata.getlExpr(), tripodContext);
        operands.add(operand);
        operand = OperandFactory.createOperand(field, andMetadata.getrExpr(), tripodContext);
        operands.add(operand);
        return new AndOperand(operands, (ExpressionMetadata)andMetadata, tripodContext);
    }

    protected static OrOperand createOrOperand(String field, BinaryMetadata orMetadata, TripodContext tripodContext) {
        LinkedList<Operand> operands = new LinkedList<Operand>();
        Operand operand = OperandFactory.createOperand(field, orMetadata.getlExpr(), tripodContext);
        operands.add(operand);
        operand = OperandFactory.createOperand(field, orMetadata.getrExpr(), tripodContext);
        operands.add(operand);
        return new OrOperand(operands, (ExpressionMetadata)orMetadata, tripodContext);
    }

    protected static NotOperand createNotOperand(String field, UnaryMetadata unaryMetadata, TripodContext tripodContext) {
        LinkedList<Operand> operands = new LinkedList<Operand>();
        Operand operand = OperandFactory.createOperand(field, unaryMetadata.getExpr(), tripodContext);
        operands.add(operand);
        return new NotOperand(operands, (ExpressionMetadata)unaryMetadata, tripodContext);
    }

    protected static ParenOperand createParenOperand(String field, UnaryMetadata unaryMetadata, TripodContext tripodContext) {
        LinkedList<Operand> operands = new LinkedList<Operand>();
        Operand operand = OperandFactory.createOperand(field, unaryMetadata.getExpr(), tripodContext);
        operands.add(operand);
        return new ParenOperand(operands, (ExpressionMetadata)unaryMetadata, tripodContext);
    }

    protected static MustOperand createMustOperand(String field, UnaryMetadata unaryMetadata, TripodContext tripodContext) {
        LinkedList<Operand> operands = new LinkedList<Operand>();
        Operand operand = OperandFactory.createOperand(field, unaryMetadata.getExpr(), tripodContext);
        operands.add(operand);
        return new MustOperand(operands, (ExpressionMetadata)unaryMetadata, tripodContext);
    }

    protected static MustNotOperand createMustNotOperand(String field, UnaryMetadata unaryMetadata, TripodContext tripodContext) {
        LinkedList<Operand> operands = new LinkedList<Operand>();
        Operand operand = OperandFactory.createOperand(field, unaryMetadata.getExpr(), tripodContext);
        operands.add(operand);
        return new MustNotOperand(operands, (ExpressionMetadata)unaryMetadata, tripodContext);
    }

    protected static Operand createTermMatchOperand(String field, TermMetadata termMetadata, TripodContext tripodContext) {
        return new TermMatchOperand(field, termMetadata, tripodContext);
    }

    protected static Operand createTermWildcardOperand(String field, WildcardMetadata wildcardMetadata, TripodContext tripodContext) {
        return new TermWildcardOperand(field, wildcardMetadata, tripodContext);
    }

    protected static Operand createTermFuzzyOperand(String field, SuffixMetadata suffixMetadata, TripodContext tripodContext) {
        return new TermFuzzyOperand(field, suffixMetadata, tripodContext);
    }

    protected static Operand createPhraseOperand(String field, ExpressionMetadata expressionMetadata, TripodContext tripodContext) {
        return new PhraseOperand(field, expressionMetadata, tripodContext);
    }

    protected static Operand createRangeOperand(String field, RangeMetadata rangeMetadata, TripodContext tripodContext) {
        return new RangeOperand(field, rangeMetadata, tripodContext);
    }

    protected static Operand createInOperand(String field, InMetadata inMetadata, TripodContext tripodContext) {
        LinkedList<Operand> operands = new LinkedList<Operand>();
        for (ExpressionMetadata expressionMetadata : inMetadata.getExpressions()) {
            Operand operand = OperandFactory.createOperand(field, expressionMetadata, tripodContext);
            operands.add(operand);
        }
        return new InOperand(operands, inMetadata, tripodContext);
    }
}

