/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.engine;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.DocumentEntityImpl;
import org.datayoo.tripod.FieldMetadata;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.IdfCounter;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.bool.BoolOperand;
import org.datayoo.tripod.engine.TripodContextImpl;
import org.datayoo.tripod.factory.OperandFactory;
import org.datayoo.tripod.metadata.BoolMetadata;
import org.datayoo.tripod.parser.TripodExpressionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tripod {
    protected static final Logger logger = LoggerFactory.getLogger(Tripod.class);
    protected String name;
    protected String rule;
    protected TripodContext context;
    protected boolean privateContext = false;
    protected BoolOperand boolOperand;

    public Tripod(String name, List<FieldMetadata> allFields, FieldMetadata defaultFieldMetadata, IdfCounter idfCounter, String rule) {
        Validate.notEmpty((CharSequence)name, (String)"name is empty!", (Object[])new Object[0]);
        this.name = name;
        this.rule = rule;
        this.context = new TripodContextImpl(allFields, defaultFieldMetadata, idfCounter);
        ((TripodContextImpl)this.context).setScoring(true);
        this.privateContext = true;
        BoolMetadata boolMetadata = TripodExpressionParser.parseFromString((String)rule);
        this.boolOperand = OperandFactory.createOperand(boolMetadata, this.context);
    }

    public Tripod(String name, TripodContext context, String rule) {
        Validate.notEmpty((CharSequence)name, (String)"name is empty!", (Object[])new Object[0]);
        this.name = name;
        this.rule = rule;
        BoolMetadata boolMetadata = TripodExpressionParser.parseFromString((String)rule);
        this.boolOperand = OperandFactory.createOperand(boolMetadata, context);
        this.context = context;
    }

    public double match(Map<String, TermEntity[]> dataMap) {
        return this.match(dataMap, true, null);
    }

    public double match(Map<String, TermEntity[]> dataMap, boolean termDistance) {
        return this.match(dataMap, termDistance, null);
    }

    public double match(Map<String, TermEntity[]> dataMap, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        Validate.notEmpty(dataMap, (String)"dataMap is empty!", (Object[])new Object[0]);
        DocumentEntityImpl documentEntity = new DocumentEntityImpl(dataMap, this.context.isScoring());
        return this.match(documentEntity, termDistance, hitMap);
    }

    public double match(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        if (this.privateContext) {
            this.context.calcIdf(documentEntity.getAllTerms());
        }
        try {
            return this.boolOperand.operate(documentEntity, termDistance, hitMap);
        }
        catch (Throwable t) {
            logger.info(String.format("yooler '%s' execute failed!", this.name));
            return 0.0;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getRule() {
        return this.rule;
    }

    public TripodContext getContext() {
        return this.context;
    }
}

