/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.FieldMetadata;
import org.datayoo.tripod.IdfCounter;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.engine.TripodEngine;
import org.datayoo.tripod.engine.TripodListener;
import org.datayoo.tripod.parser.TripodExpressionParser;
import org.datayoo.tripod.seg.TripodSegment;

public class SegmentableTripodEngine {
    protected TripodEngine tripodEngine;
    protected TripodSegment tripodSegment;
    protected Set<String> segmentFields = new HashSet<String>();

    public SegmentableTripodEngine(List<FieldMetadata> allFields, FieldMetadata defaultFieldMetadata, IdfCounter idfCounter, TripodSegment tripodSegment) {
        this.tripodEngine = new TripodEngine(allFields, defaultFieldMetadata, idfCounter);
        Validate.notNull((Object)tripodSegment, (String)"tripodSegment is null!", (Object[])new Object[0]);
        this.tripodSegment = tripodSegment;
        this.segmentFields.add(defaultFieldMetadata.getField());
    }

    public SegmentableTripodEngine setScoring(boolean scoring) {
        this.tripodEngine.setScoring(scoring);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTripodRule(String name, String rule, TripodListener tripodListener) {
        this.tripodEngine.addTripodRule(name, rule, tripodListener);
        Set<String> set = this.segmentFields;
        synchronized (set) {
            this.segmentFields.addAll(TripodExpressionParser.extractSegmentFields((String)rule));
        }
    }

    public String removeTripodRule(String name) {
        return this.tripodEngine.removeTripodRule(name);
    }

    public void match(Map<String, Object> dataMap) {
        Map<String, TermEntity[]> segmentedMap = this.segmentFields(dataMap);
        this.tripodEngine.match(segmentedMap, true, false);
    }

    public void match(Map<String, Object> dataMap, boolean termDistance) {
        Map<String, TermEntity[]> segmentedMap = this.segmentFields(dataMap);
        this.tripodEngine.match(segmentedMap, termDistance, false);
    }

    public void match(Map<String, Object> dataMap, boolean termDistance, boolean retHit) {
        Map<String, TermEntity[]> segmentedMap = this.segmentFields(dataMap);
        this.tripodEngine.match(segmentedMap, true, retHit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, TermEntity[]> segmentFields(Map<String, Object> dataMap) {
        HashMap<String, TermEntity[]> segmentedMap = new HashMap<String, TermEntity[]>();
        Set<String> set = this.segmentFields;
        synchronized (set) {
            for (String field : this.segmentFields) {
                Object v = dataMap.get(field);
                if (v == null) continue;
                if (v instanceof TermEntity[]) {
                    segmentedMap.put(field, (TermEntity[])v);
                    continue;
                }
                segmentedMap.put(field, this.tripodSegment.segment(v.toString()));
            }
        }
        return segmentedMap;
    }
}

