/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.comp;

import java.util.List;
import java.util.Map;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.WildcardMetadata;
import org.datayoo.tripod.operand.AtomOperand;
import org.datayoo.tripod.utils.WildcardMatcher;

public class TermWildcardOperand
extends AtomOperand {
    protected WildcardMatcher wildcardMatcher;

    public TermWildcardOperand(String field, WildcardMetadata wildcardMetadata, TripodContext context) {
        super(field, (ExpressionMetadata)wildcardMetadata, context);
        this.wildcardMatcher = new WildcardMatcher(wildcardMetadata.getWildcard());
    }

    @Override
    public double operate(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        double score = 0.0;
        List<HitToken> hits = this.getHits(hitMap, this.field);
        for (TermEntity termEntity : documentEntity.getTermEntities(this.field)) {
            if (!this.wildcardMatcher.isMatch(termEntity.getTerm())) continue;
            if (hits == null) {
                return this.score(documentEntity, termEntity);
            }
            score += this.score(documentEntity, termEntity);
            HitToken hit = new HitToken(termEntity.getOffset(), termEntity.getOffset() + termEntity.getTerm().length());
            hit.setToken(termEntity.getTerm());
            hits.add(hit);
        }
        if (score == 0.0) {
            return -1.0;
        }
        return score;
    }
}

