/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.comp;

import java.util.List;
import java.util.Map;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.TermMetadata;
import org.datayoo.tripod.operand.AtomOperand;

public class TermMatchOperand
extends AtomOperand {
    protected String term;

    public TermMatchOperand(String field, TermMetadata termMetadata, TripodContext context) {
        super(field, (ExpressionMetadata)termMetadata, context);
        this.term = termMetadata.getTerm();
    }

    @Override
    public double operate(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        List<HitToken> hits = this.getHits(hitMap, this.field);
        List<TermEntity> termEntities = documentEntity.findTerm(this.field, this.term);
        if (termEntities == null || termEntities.size() == 0) {
            return -1.0;
        }
        double score = this.score(documentEntity, termEntities.get(0));
        if (score > 0.0 && hits != null) {
            for (TermEntity termEntity : termEntities) {
                HitToken hit = new HitToken(termEntity.getOffset(), termEntity.getOffset() + termEntity.getTerm().length());
                hit.setToken(termEntity.getTerm());
                hits.add(hit);
            }
        }
        return score;
    }
}

