/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.comp;

import java.util.List;
import java.util.Map;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.metadata.ExpressionType;
import org.datayoo.tripod.metadata.PhraseMetadata;
import org.datayoo.tripod.metadata.SuffixMetadata;
import org.datayoo.tripod.operand.AtomOperand;

public class PhraseOperand
extends AtomOperand {
    protected String[] terms;
    protected int distance = 1;

    public PhraseOperand(String field, ExpressionMetadata expressionMetadata, TripodContext context) {
        super(field, expressionMetadata, context);
        int distance = 1;
        if (expressionMetadata.getExpressionType() == ExpressionType.PROXIMITY) {
            SuffixMetadata suffixMetadata = (SuffixMetadata)expressionMetadata;
            expressionMetadata = suffixMetadata.getExpr();
            distance = suffixMetadata.getNumber().intValue() + 1;
        }
        if (expressionMetadata.getExpressionType() != ExpressionType.PHRASE) {
            throw new IllegalArgumentException("Invalid expression type!");
        }
        PhraseMetadata phraseMetadata = (PhraseMetadata)expressionMetadata;
        this.init(phraseMetadata.getPhrase(), distance);
    }

    protected void init(String phrase, int distance) {
        this.terms = phrase.split(" ");
        if (this.terms.length < 2) {
            throw new IllegalArgumentException("It's not a phrase!");
        }
        this.distance = distance;
    }

    @Override
    public double operate(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        DoubleRef dr = new DoubleRef();
        int[][] posAries = this.findPos(documentEntity, termDistance, dr);
        if (posAries == null) {
            return -1.0;
        }
        int[] posAry = new int[this.terms.length];
        List<HitToken> hits = this.getHits(hitMap, this.field);
        if (this.calcDistance(posAries, 0, posAry, documentEntity, termDistance, hits)) {
            if (this.context.isScoring()) {
                return dr.d;
            }
            return 1.0;
        }
        return -1.0;
    }

    protected int[][] findPos(DocumentEntity documentEntity, boolean termDistance, DoubleRef score) {
        int[][] posAries = new int[this.terms.length][];
        for (int i = 0; i < this.terms.length; ++i) {
            List<TermEntity> termEntities = documentEntity.findTerm(this.field, this.terms[i]);
            if (termEntities == null || termEntities.size() == 0) {
                return null;
            }
            int[] posAry = new int[termEntities.size()];
            posAries[i] = posAry;
            int j = 0;
            for (TermEntity termEntity : termEntities) {
                posAry[j] = termDistance ? termEntity.getIndex() : termEntity.getOffset();
                ++j;
            }
            if (!this.context.isScoring()) continue;
            score.d += this.score(documentEntity, termEntities.get(0));
        }
        return posAries;
    }

    protected boolean calcDistance(int[][] posAries, int level, int[] posAry, DocumentEntity documentEntity, boolean termDistance, List<HitToken> hits) {
        int hitSize = hits == null ? 0 : hits.size();
        for (int i = 0; i < posAries[level].length; ++i) {
            posAry[level] = posAries[level][i];
            if (level == this.terms.length - 1) {
                if (termDistance) {
                    if (!this.calcTermDistance(posAry)) continue;
                    if (hits == null) {
                        return true;
                    }
                    this.fillHits(posAry, documentEntity, termDistance, hits);
                    continue;
                }
                if (!this.calcCharDistance(posAry)) continue;
                if (hits == null) {
                    return true;
                }
                this.fillHits(posAry, documentEntity, termDistance, hits);
                continue;
            }
            if (!this.calcDistance(posAries, level + 1, posAry, documentEntity, termDistance, hits) || hits != null) continue;
            return true;
        }
        return hits != null && hits.size() != hitSize;
    }

    protected void fillHits(int[] posAry, DocumentEntity documentEntity, boolean termDistance, List<HitToken> hits) {
        int bt = 0;
        int et = 0;
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int i = 0; i < posAry.length; ++i) {
            if (posAry[i] > max) {
                max = posAry[i];
                et = i;
            }
            if (posAry[i] >= min) continue;
            min = posAry[i];
            bt = i;
        }
        int begin = 0;
        int end = 0;
        TermEntity[] entities = documentEntity.getTermEntities(this.field);
        if (termDistance) {
            begin = entities[min].getOffset();
            end = entities[max].getOffset() + entities[max].getTerm().length();
        } else {
            begin = min;
            end = max + this.terms[et].length();
        }
        HitToken hit = new HitToken(begin, end);
        hit.setToken(this.extractPhrase(begin, end, entities));
        hits.add(hit);
    }

    protected String extractPhrase(int begin, int end, TermEntity[] termEntities) {
        StringBuilder sbud = new StringBuilder();
        int pos = -1;
        for (int i = 0; i <= termEntities.length; ++i) {
            if (termEntities[i].getOffset() < begin) continue;
            if (termEntities[i].getOffset() > end) break;
            if (termEntities[i].getOffset() < pos) continue;
            if (pos > 0 && termEntities[i].getOffset() - pos > 0) {
                this.stuff(sbud, termEntities[i].getOffset() - pos);
            }
            sbud.append(termEntities[i].getTerm());
            pos = termEntities[i].getOffset() + termEntities[i].getTerm().length();
        }
        return sbud.toString();
    }

    protected void stuff(StringBuilder sbud, int length) {
        for (int i = 0; i < length; ++i) {
            sbud.append('.');
        }
    }

    protected boolean calcTermDistance(int[] findPos) {
        int i;
        boolean[] bAry = new boolean[findPos.length];
        for (i = 0; i < bAry.length; ++i) {
            bAry[i] = false;
        }
        for (i = 0; i < findPos.length; ++i) {
            int dist = Integer.MAX_VALUE;
            int inx = 0;
            for (int j = i + 1; j < findPos.length; ++j) {
                int tmp1 = Math.abs(findPos[i] + this.terms[i].length() - findPos[j]);
                int tmp2 = Math.abs(findPos[i] - findPos[j] + this.terms[j].length());
                if ((tmp1 = Math.min(tmp1, tmp2)) != (dist = Math.min(dist, tmp1))) continue;
                inx = j;
            }
            if (dist > this.distance) continue;
            bAry[i] = true;
            bAry[inx] = true;
        }
        for (i = 0; i < bAry.length; ++i) {
            if (bAry[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean calcCharDistance(int[] findPos) {
        int i;
        boolean[] bAry = new boolean[findPos.length];
        for (i = 0; i < bAry.length; ++i) {
            bAry[i] = false;
        }
        for (i = 0; i < findPos.length; ++i) {
            int dist = Integer.MAX_VALUE;
            int inx = 0;
            for (int j = i + 1; j < findPos.length; ++j) {
                int tmp = Math.abs(findPos[i] - findPos[j]);
                if (tmp != (dist = Math.min(dist, tmp))) continue;
                inx = j;
            }
            if (dist > this.distance) continue;
            bAry[i] = true;
            bAry[inx] = true;
        }
        for (i = 0; i < bAry.length; ++i) {
            if (bAry[i]) continue;
            return false;
        }
        return true;
    }

    protected class DoubleRef {
        double d = 0.0;

        protected DoubleRef() {
        }
    }
}

