/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod.bool;

import java.util.List;
import java.util.Map;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.HitToken;
import org.datayoo.tripod.Operand;
import org.datayoo.tripod.TripodContext;
import org.datayoo.tripod.metadata.ExpressionMetadata;
import org.datayoo.tripod.operand.DecratorOperand;

public class MustNotOperand
extends DecratorOperand {
    protected Operand mustNotOperand;

    public MustNotOperand(List<Operand> operands, ExpressionMetadata expressionMetadata, TripodContext tripodContext) {
        super(operands, expressionMetadata, tripodContext);
        if (operands.size() != 1) {
            throw new IllegalArgumentException("Invalid must not operand!");
        }
        this.mustNotOperand = operands.get(0);
    }

    @Override
    public double operate(DocumentEntity documentEntity, boolean termDistance, Map<String, List<HitToken>> hitMap) {
        double d = this.mustNotOperand.operate(documentEntity, termDistance, hitMap);
        if (d > 0.0) {
            return -1.0;
        }
        if (this.context.isScoring()) {
            return 1.0 / Math.sqrt(documentEntity.getTermsCount());
        }
        return 1.0;
    }
}

