/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Validate;
import org.datayoo.tripod.IdfCounter;

public class IdfCounterImpl
implements IdfCounter {
    protected AtomicLong totalDocs;
    protected Map<String, Integer> termDocs = Collections.synchronizedMap(new TreeMap());

    public IdfCounterImpl() {
        this.totalDocs = new AtomicLong(0L);
    }

    public IdfCounterImpl(long totalDocs, Map<String, Integer> termDocs) {
        this.totalDocs = new AtomicLong(totalDocs);
        this.termDocs = termDocs;
    }

    @Override
    public void count(Set<String> terms) {
        this.totalDocs.getAndIncrement();
        for (String term : terms) {
            Integer i = this.termDocs.get(term);
            if (i == null) {
                this.termDocs.put(term, 1);
                continue;
            }
            this.termDocs.put(term, i + 1);
        }
    }

    @Override
    public double idf(String term) {
        Integer num = this.termDocs.get(term);
        if (num == null) {
            return 0.0;
        }
        return Math.log((double)this.totalDocs.get() / (double)(num + 1)) + 1.0;
    }

    @Override
    public long getTotalDocs() {
        return this.totalDocs.get();
    }

    @Override
    public Map<String, Integer> getTermDocs() {
        return this.termDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String fileName) throws IOException, ClassNotFoundException {
        Validate.notEmpty((CharSequence)fileName, (String)"fileName is empty!", (Object[])new Object[0]);
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileName));){
            long l = ois.readLong();
            this.totalDocs = new AtomicLong(l);
            this.termDocs = (Map)ois.readObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String fileName) throws IOException {
        Validate.notEmpty((CharSequence)fileName, (String)"fileName is empty!", (Object[])new Object[0]);
        IdfCounterImpl idfCounter = new IdfCounterImpl();
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));){
            oos.writeLong(this.totalDocs.get());
            oos.writeObject(this.termDocs);
        }
    }
}

