/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.tripod;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.datayoo.tripod.DocumentEntity;
import org.datayoo.tripod.TermEntity;

public class DocumentEntityImpl
implements DocumentEntity {
    protected Map<String, TermEntity[]> entityMap;
    protected Map<String, Map<String, List<TermEntity>>> entityTermMap = new HashMap<String, Map<String, List<TermEntity>>>();
    protected Map<String, Double> tfs = new TreeMap<String, Double>();

    public DocumentEntityImpl(Map<String, TermEntity[]> entityMap, boolean scoring) {
        this.entityMap = entityMap;
        this.initEntityTermMap();
        if (scoring) {
            this.caculateTfs();
        }
    }

    protected void caculateTfs() {
        this.fillTfs();
        for (Map.Entry<String, Double> entry : this.tfs.entrySet()) {
            entry.setValue(Math.sqrt(entry.getValue()));
        }
    }

    protected void initEntityTermMap() {
        for (Map.Entry<String, TermEntity[]> entry : this.entityMap.entrySet()) {
            Map<String, List<TermEntity>> termMap = this.entityTermMap.get(entry.getKey());
            if (termMap == null) {
                termMap = new TreeMap<String, List<TermEntity>>();
                this.entityTermMap.put(entry.getKey(), termMap);
            }
            this.initTermMap(termMap, entry.getValue());
        }
    }

    protected void initTermMap(Map<String, List<TermEntity>> termMap, TermEntity[] termEntities) {
        for (int i = 0; i < termEntities.length; ++i) {
            List<TermEntity> entities = termMap.get(termEntities[i].getTerm());
            if (entities == null) {
                entities = new LinkedList<TermEntity>();
                termMap.put(termEntities[i].getTerm(), entities);
            }
            entities.add(termEntities[i]);
        }
    }

    protected void fillTfs() {
        for (TermEntity[] termEntities : this.entityMap.values()) {
            for (int i = 0; i < termEntities.length; ++i) {
                String term = termEntities[i].getTerm();
                Double d = this.tfs.get(term);
                if (d == null) {
                    this.tfs.put(term, 1.0);
                    continue;
                }
                this.tfs.put(term, d + 1.0);
            }
        }
    }

    @Override
    public List<TermEntity> findTerm(String field, String term) {
        Map<String, List<TermEntity>> termMap = this.entityTermMap.get(field);
        if (termMap == null) {
            return null;
        }
        return termMap.get(term);
    }

    @Override
    public double getTermFrequency(String term) {
        if (this.tfs.size() == 0) {
            return 0.0;
        }
        Double d = this.tfs.get(term);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public int getTermsCount() {
        return this.tfs.size();
    }

    @Override
    public TermEntity[] getTermEntities(String field) {
        return this.entityMap.get(field);
    }

    @Override
    public Set<String> getTerms(String field) {
        Map<String, List<TermEntity>> termMap = this.entityTermMap.get(field);
        if (termMap != null) {
            return termMap.keySet();
        }
        return null;
    }

    @Override
    public Set<String> getAllTerms() {
        return this.tfs.keySet();
    }
}

