/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql.mongodb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Filter;
import org.datayoo.moql.MoqlTranslationException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.Selector;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.Group;
import org.datayoo.moql.core.HavingImpl;
import org.datayoo.moql.core.Join;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.Order;
import org.datayoo.moql.core.OrderImpl;
import org.datayoo.moql.core.RecordSetOperator;
import org.datayoo.moql.core.SelectorImpl;
import org.datayoo.moql.core.SetlectorImpl;
import org.datayoo.moql.core.Table;
import org.datayoo.moql.core.Tables;
import org.datayoo.moql.core.group.GroupRecordSetOperator;
import org.datayoo.moql.core.join.LeftJoin;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.metadata.LimitMetadata;
import org.datayoo.moql.metadata.OrderType;
import org.datayoo.moql.operand.constant.BooleanConstant;
import org.datayoo.moql.operand.constant.DoubleConstant;
import org.datayoo.moql.operand.constant.LongConstant;
import org.datayoo.moql.operand.constant.StringConstant;
import org.datayoo.moql.operand.expression.AbstractOperationExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.ParenExpression;
import org.datayoo.moql.operand.expression.logic.AndExpression;
import org.datayoo.moql.operand.expression.logic.LogicOperator;
import org.datayoo.moql.operand.expression.logic.NotExpression;
import org.datayoo.moql.operand.expression.member.MemberVariableExpression;
import org.datayoo.moql.operand.expression.relation.BetweenExpression;
import org.datayoo.moql.operand.expression.relation.EqualExpression;
import org.datayoo.moql.operand.expression.relation.ExistsExpression;
import org.datayoo.moql.operand.expression.relation.InExpression;
import org.datayoo.moql.operand.expression.relation.IsExpression;
import org.datayoo.moql.operand.expression.relation.LikeExpression;
import org.datayoo.moql.operand.expression.relation.RelationOperator;
import org.datayoo.moql.operand.function.AbstractFunction;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.operand.selector.ColumnSelectorOperand;
import org.datayoo.moql.operand.variable.Variable;
import org.datayoo.moql.sql.FunctionTranslator;
import org.datayoo.moql.sql.SqlTranslator;
import org.datayoo.moql.sql.mongodb.MongoFunctionTranslator;
import org.datayoo.moql.sql.mongodb.TextTranslator;
import org.datayoo.moql.util.StringFormater;

public class MongoDBTranslator
implements SqlTranslator {
    public static final String JE_QUERY_TYPE = "queryType";
    public static final String JE_QUERY_COLLECTION = "queryCollection";
    public static final String JE_COUNT = "$count";
    public static final Set<String> exceptionFunctions = new HashSet<String>();
    protected Map<String, MongoFunctionTranslator> functionTranslators = new HashMap<String, MongoFunctionTranslator>();
    protected static Gson gson;

    public MongoDBTranslator() {
        this.functionTranslators.put("text", new TextTranslator());
    }

    @Override
    public String translate2Sql(Selector selector) {
        return this.translate2Sql(selector, new HashMap<String, Object>());
    }

    @Override
    public String translate2Sql(Selector selector, Map<String, Object> translationContext) {
        Validate.notNull((Object)selector, (String)"selector is null!", (Object[])new Object[0]);
        if (selector instanceof SelectorImpl) {
            return this.translate2Sql((SelectorImpl)selector);
        }
        return this.translate2Sql((SetlectorImpl)selector, translationContext);
    }

    protected String translate2Sql(SelectorImpl selector) {
        this.checkGrammer(selector);
        JsonArray jsonArray = new JsonArray();
        JsonObject queryType = new JsonObject();
        if (this.isAggregations(selector)) {
            queryType.addProperty(JE_QUERY_TYPE, "aggregate");
            jsonArray.add((JsonElement)queryType);
            this.translateTable(selector.getTables(), jsonArray);
            JsonArray aggs = new JsonArray();
            this.translate2Aggs(selector, aggs);
            this.putObject((JsonElement)jsonArray, "aggs", (JsonElement)aggs);
        } else {
            queryType.addProperty(JE_QUERY_TYPE, "find");
            jsonArray.add((JsonElement)queryType);
            this.translateTable(selector.getTables(), jsonArray);
            this.translate2Query(selector, jsonArray);
        }
        return gson.toJson((JsonElement)jsonArray);
    }

    protected void checkGrammer(SelectorImpl selector) {
        if (selector.getTables().getTablesMetadata().getTables().size() > 1) {
            throw new MoqlTranslationException("The sql querys more than 1 table!");
        }
    }

    protected boolean isAggregations(SelectorImpl selector) {
        if (this.isAggregations(selector.getTables())) {
            return true;
        }
        RecordSetOperator recordSetOperator = selector.getRecordSetOperator();
        if (recordSetOperator instanceof Group) {
            return true;
        }
        Columns columns = recordSetOperator.getColumns();
        if (columns.getColumnsMetadata().isDistinct()) {
            throw new UnsupportedOperationException("Unsupported 'distinct' clause!Please use 'groupBy' clause instead!");
        }
        return false;
    }

    protected boolean isAggregations(Tables tables) {
        if (tables.getQueryable() instanceof LeftJoin) {
            LeftJoin leftJoin = (LeftJoin)tables.getQueryable();
            if (leftJoin.getOn() == null) {
                throw new UnsupportedOperationException("Unsupported 'left join' clause without 'on' clause!");
            }
            if (leftJoin.getRightQueryable() instanceof Table && leftJoin.getOn().getOperand() instanceof EqualExpression) {
                return true;
            }
        }
        return false;
    }

    protected void translateTable(Tables tables, JsonArray jsonArray) {
        String tableName = null;
        if (tables.getQueryable() instanceof Table) {
            Table table = (Table)tables.getQueryable();
            tableName = table.getTableMetadata().getValue();
        } else {
            Join join = (Join)tables.getQueryable();
            tableName = ((Table)join.getLeftQueryable()).getTableMetadata().getValue();
        }
        JsonPrimitive jp = new JsonPrimitive(tableName);
        this.putObject((JsonElement)jsonArray, JE_QUERY_COLLECTION, (JsonElement)jp);
    }

    protected void translate2Query(SelectorImpl selector, JsonArray jsonArray) {
        if (this.isSelectCount(selector.getRecordSetOperator())) {
            this.translateSelectCount(jsonArray);
        } else {
            this.translateProjectionClause(selector.getRecordSetOperator(), null, jsonArray);
        }
        if (selector.getWhere() != null) {
            this.translateWhereClause(selector.getWhere(), jsonArray);
        }
        if (selector.getOrder() != null) {
            this.translateOrderClause(selector.getOrder(), jsonArray);
        }
        if (selector.getLimit() != null) {
            this.translateLimitClause(selector.getLimit(), jsonArray);
        }
    }

    protected boolean isSelectCount(RecordSetOperator recordSetOperator) {
        Column column;
        Columns columns = recordSetOperator.getColumns();
        return columns.getColumns().size() == 1 && (column = (Column)columns.getColumns().get(0)).getOperand() instanceof Function && column.getOperand().getName().equals("count");
    }

    protected void translateSelectCount(JsonArray jsonArray) {
        JsonObject jo = new JsonObject();
        jo.add(JE_COUNT, (JsonElement)new JsonObject());
        jsonArray.add((JsonElement)jo);
    }

    protected void translateProjectionClause(RecordSetOperator recordSetOperator, String leftJoinTableAlias, JsonArray jsonArray) {
        if (this.isSelectAll(recordSetOperator)) {
            return;
        }
        JsonObject projection = new JsonObject();
        boolean idProjected = false;
        for (Column column : recordSetOperator.getColumns().getColumns()) {
            if (column.getOperand() instanceof ColumnSelectorOperand) {
                throw new UnsupportedOperationException("Unsupported nested selector in select clause!");
            }
            if (column.getOperand() instanceof Function) {
                throw new UnsupportedOperationException("Unsupported function in select clause!");
            }
            if (leftJoinTableAlias != null && this.isLeftJoinProjection(column.getColumnMetadata(), leftJoinTableAlias)) continue;
            String value = column.getColumnMetadata().getName();
            int index = value.indexOf(40);
            if (index == -1) {
                index = value.indexOf(46);
                value = value.substring(index + 1);
            }
            if (value.equals("_id")) {
                idProjected = true;
            }
            projection.addProperty(value, (Number)1);
        }
        if (!idProjected) {
            projection.addProperty("_id", (Number)0);
        }
        JsonObject jo = new JsonObject();
        jo.add("$project", (JsonElement)projection);
        jsonArray.add((JsonElement)jo);
    }

    protected boolean isLeftJoinProjection(ColumnMetadata columnMetadata, String leftJoinTableAlias) {
        String prefix;
        String name = columnMetadata.getName();
        int index = name.indexOf(46);
        return index != -1 && (prefix = name.substring(0, index)).equals(leftJoinTableAlias);
    }

    protected boolean isSelectAll(RecordSetOperator recordSetOperator) {
        Columns columns = recordSetOperator.getColumns();
        for (Column column : columns.getColumns()) {
            String value = column.getColumnMetadata().getValue();
            if (!value.endsWith(".*")) continue;
            return true;
        }
        return false;
    }

    protected void translateWhereClause(Condition condition, JsonArray jsonArray) {
        JsonObject whereClause = new JsonObject();
        this.translateOperand(condition.getOperand(), (JsonElement)whereClause);
        JsonObject jo = new JsonObject();
        jo.add("$match", (JsonElement)whereClause);
        jsonArray.add((JsonElement)jo);
    }

    protected void translateLimitClause(Limit limit, JsonArray jsonArray) {
        if (limit == null) {
            return;
        }
        JsonObject jsonObject = new JsonObject();
        LimitMetadata limitMetadata = limit.getLimitMetadata();
        jsonObject.addProperty("$limit", (Number)limitMetadata.getValue());
        jsonArray.add((JsonElement)jsonObject);
        if (limitMetadata.getOffset() != 0) {
            jsonObject = new JsonObject();
            jsonObject.addProperty("$skip", (Number)limitMetadata.getOffset());
            jsonArray.add((JsonElement)jsonObject);
        }
    }

    protected void translateOrderClause(Order order, JsonArray jsonArray) {
        if (order == null) {
            return;
        }
        JsonObject sortObject = new JsonObject();
        OrderImpl orderImpl = (OrderImpl)order;
        Column[] columns = orderImpl.getOrderColumns();
        OrderType[] orderTypes = orderImpl.getOrderTypes();
        for (int i = 0; i < columns.length; ++i) {
            int o = 1;
            if (orderTypes[i].name().equalsIgnoreCase("desc")) {
                o = -1;
            }
            this.translateOrderColumn(columns[i], o, sortObject);
        }
        JsonObject jo = new JsonObject();
        jo.add("$sort", (JsonElement)sortObject);
        jsonArray.add((JsonElement)jo);
    }

    protected void translateOrderColumn(Column column, int od, JsonObject sortObject) {
        if (column.getOperand() instanceof Function) {
            this.translateFunction((AbstractFunction)column.getOperand(), (JsonElement)sortObject);
        } else {
            sortObject.addProperty(this.getFieldName(column.getOperand().getName()), (Number)od);
        }
    }

    protected void translate2Aggs(SelectorImpl selector, JsonArray jsonArray) {
        boolean leftJoin = this.isLeftJoin(selector.getTables());
        if (leftJoin) {
            this.translateLeftJoin(selector.getTables(), jsonArray);
            this.translateProjectionClause(selector.getRecordSetOperator(), this.getLeftJoinTableAlias(selector.getTables()), jsonArray);
        }
        if (selector.getWhere() != null) {
            this.translateWhereClause(selector.getWhere(), jsonArray);
        }
        if (!leftJoin) {
            this.translateGroupClause(selector, jsonArray);
        }
        if (selector.getHaving() != null) {
            this.translateHavingClause((HavingImpl)selector.getHaving(), (JsonElement)jsonArray);
        }
        if (selector.getOrder() != null) {
            this.translateOrderClause(selector.getOrder(), jsonArray);
        }
        if (selector.getLimit() != null) {
            this.translateLimitClause(selector.getLimit(), jsonArray);
        }
    }

    protected boolean isLeftJoin(Tables tables) {
        return tables.getQueryable() instanceof LeftJoin;
    }

    protected String getLeftJoinTableAlias(Tables tables) {
        LeftJoin leftJoin = (LeftJoin)tables.getQueryable();
        Table table = (Table)leftJoin.getLeftQueryable();
        return table.getTableMetadata().getValue();
    }

    protected void translateLeftJoin(Tables tables, JsonArray jsonArray) {
        LeftJoin leftJoin = (LeftJoin)tables.getQueryable();
        Table table = (Table)leftJoin.getRightQueryable();
        EqualExpression expression = (EqualExpression)leftJoin.getOn().getOperand();
        JsonObject lookup = new JsonObject();
        lookup.addProperty("from", table.getTableMetadata().getValue());
        lookup.addProperty("localField", this.getFieldName(expression.getLeftOperand().getName()));
        lookup.addProperty("foreignField", this.getFieldName(expression.getRightOperand().getName()));
        lookup.addProperty("as", table.getTableMetadata().getValue());
        this.putObject((JsonElement)jsonArray, "$lookup", (JsonElement)lookup);
    }

    protected String getFieldName(String name) {
        int inx = name.lastIndexOf(46);
        if (inx != -1) {
            return name.substring(inx + 1);
        }
        return name;
    }

    protected void translateGroupClause(SelectorImpl selector, JsonArray jsonArray) {
        GroupRecordSetOperator groupRecordSetOperator = (GroupRecordSetOperator)selector.getRecordSetOperator();
        Column[] columns = groupRecordSetOperator.getGroupColumns();
        JsonObject group = new JsonObject();
        this.translateGroupColumns(columns, group);
        columns = groupRecordSetOperator.getNonGroupColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            AbstractFunction function = (AbstractFunction)columns[i].getOperand();
            JsonObject func = new JsonObject();
            if (!this.isCountFunction((Function)function)) {
                this.translateFunction((AbstractFunction)columns[i].getOperand(), (JsonElement)func);
            } else {
                this.translateCountFunction(func);
            }
            group.add(this.getFieldName(columns[i].getColumnMetadata().getName()), (JsonElement)func);
        }
        this.putObject((JsonElement)jsonArray, "$group", (JsonElement)group);
    }

    protected void translateGroupColumns(Column[] columns, JsonObject group) {
        JsonObject jo = new JsonObject();
        for (int i = 0; i < columns.length; ++i) {
            ColumnMetadata columnMetadata = columns[i].getColumnMetadata();
            jo.add(this.getFieldName(columnMetadata.getName()), this.translateUnaryOperand(columns[i].getOperand()));
        }
        group.add("_id", (JsonElement)jo);
    }

    protected boolean isCountFunction(Function function) {
        return function.getName().equals("count");
    }

    protected void translateCountFunction(JsonObject func) {
        func.addProperty("$sum", (Number)1);
    }

    protected void putObject(JsonElement jsonElement, String name, JsonElement valueJson) {
        if (jsonElement instanceof JsonObject) {
            ((JsonObject)jsonElement).add(name, valueJson);
        } else {
            JsonObject jo = new JsonObject();
            jo.add(name, valueJson);
            ((JsonArray)jsonElement).add((JsonElement)jo);
        }
    }

    protected void translateOperand(Operand operand, JsonElement jsonElement) {
        if (operand instanceof AbstractOperationExpression) {
            AbstractOperationExpression expression = (AbstractOperationExpression)operand;
            if (expression.getExpressionType() == ExpressionType.LOGIC) {
                this.translateLogicExpression(expression, jsonElement);
            } else if (expression.getExpressionType() == ExpressionType.RELATION) {
                this.translateRelationExpression(expression, jsonElement);
            } else if (expression.getExpressionType() == ExpressionType.ARITHMETIC) {
                throw new MoqlTranslationException(StringFormater.format((String)"The expression '{}' does not support!", (Object[])new Object[]{expression.getExpressionType().toString()}));
            }
        } else if (operand instanceof ParenExpression) {
            ParenExpression parenExpression = (ParenExpression)operand;
            this.translateParenExpression(parenExpression, jsonElement);
        } else if (operand instanceof AbstractFunction) {
            AbstractFunction function = (AbstractFunction)operand;
            this.translateFunction(function, jsonElement);
        } else {
            throw new MoqlTranslationException(StringFormater.format((String)"The operand '{}' does not support!", (Object[])new Object[]{operand.getOperandType().toString()}));
        }
    }

    protected void translateLogicExpression(AbstractOperationExpression expression, JsonElement jsonElement) {
        if (expression.getOperator() == LogicOperator.NOT) {
            this.translateNotExpression((NotExpression)expression, jsonElement);
        } else if (expression.getOperator() == LogicOperator.AND) {
            this.translateLogicBinaryExpression("$and", expression.getLeftOperand(), expression.getRightOperand(), jsonElement);
        } else {
            this.translateLogicBinaryExpression("$or", expression.getLeftOperand(), expression.getRightOperand(), jsonElement);
        }
    }

    protected void translateNotExpression(NotExpression expression, JsonElement jsonElement) {
        if (!this.translateNotOperand(expression.getRightOperand(), jsonElement)) {
            throw new UnsupportedOperationException(String.format("Does't support NotExpression as '%s'!", expression.toString()));
        }
    }

    protected boolean translateNotOperand(Operand operand, JsonElement jsonElement) {
        if (operand instanceof IsExpression) {
            IsExpression isExpression = (IsExpression)operand;
            this.translateIsExpression(isExpression.getLeftOperand(), jsonElement, true);
        } else if (operand instanceof AbstractOperationExpression) {
            AbstractOperationExpression expression = (AbstractOperationExpression)operand;
            if (expression.getExpressionType() == ExpressionType.LOGIC) {
                JsonArray norArray;
                if (expression.getOperator() == LogicOperator.AND && this.translate2Nor((AndExpression)expression, norArray = new JsonArray())) {
                    this.putObject(jsonElement, "$nor", (JsonElement)norArray);
                    return true;
                }
                return false;
            }
            if (expression.getExpressionType() == ExpressionType.RELATION && expression.getOperator() == RelationOperator.IN) {
                this.translateInExpression("$nin", (InExpression)expression, jsonElement);
            } else {
                JsonObject tmp = new JsonObject();
                this.translateOperand(operand, (JsonElement)tmp);
                this.repackNotExpression(tmp, jsonElement);
            }
        } else {
            if (operand instanceof ParenExpression) {
                operand = ((ParenExpression)operand).getOperand();
                return this.translateNotOperand(operand, jsonElement);
            }
            return false;
        }
        return true;
    }

    protected void repackNotExpression(JsonObject tmp, JsonElement jsonElement) {
        Map.Entry entry = (Map.Entry)tmp.entrySet().iterator().next();
        JsonObject field = new JsonObject();
        field.add("$not", (JsonElement)entry.getValue());
        this.putObject(jsonElement, (String)entry.getKey(), (JsonElement)field);
    }

    protected boolean translate2Nor(AndExpression andExpression, JsonArray norArray) {
        if (!this.translate2Nor(andExpression.getLeftOperand(), norArray)) {
            return false;
        }
        return this.translate2Nor(andExpression.getRightOperand(), norArray);
    }

    protected boolean translate2Nor(Operand operand, JsonArray norArray) {
        if (operand instanceof AbstractOperationExpression) {
            AbstractOperationExpression expression = (AbstractOperationExpression)operand;
            if (expression.getExpressionType() == ExpressionType.LOGIC) {
                if (expression.getOperator() != LogicOperator.AND) {
                    return false;
                }
                if (!this.translate2Nor((AndExpression)expression, norArray)) {
                    return false;
                }
            } else if (expression.getExpressionType() == ExpressionType.RELATION) {
                this.translateOperand((Operand)expression, (JsonElement)norArray);
            }
        } else {
            return false;
        }
        return true;
    }

    protected void translateLogicBinaryExpression(String operator, Operand lOperand, Operand rOperand, JsonElement jsonElement) {
        JsonArray logicArray = new JsonArray();
        this.translateOperand(lOperand, (JsonElement)logicArray);
        this.translateOperand(rOperand, (JsonElement)logicArray);
        this.putObject(jsonElement, operator, (JsonElement)logicArray);
    }

    protected void translateRelationExpression(AbstractOperationExpression expression, JsonElement jsonElement) {
        if (expression.getOperator() == RelationOperator.EQ) {
            this.translateRelationExpression("$eq", expression, jsonElement);
        } else if (expression.getOperator() == RelationOperator.GT) {
            this.translateRelationExpression("$gt", expression, jsonElement);
        } else if (expression.getOperator() == RelationOperator.GE) {
            this.translateRelationExpression("$gte", expression, jsonElement);
        } else if (expression.getOperator() == RelationOperator.LT) {
            this.translateRelationExpression("$lt", expression, jsonElement);
        } else if (expression.getOperator() == RelationOperator.LE) {
            this.translateRelationExpression("$lte", expression, jsonElement);
        } else if (expression.getOperator() == RelationOperator.NE) {
            this.translateRelationExpression("$ne", expression, jsonElement);
        } else if (expression.getOperator() == RelationOperator.BETWEEN) {
            this.translateBetweenExpression((BetweenExpression)expression, jsonElement);
        } else if (expression.getOperator() == RelationOperator.LIKE) {
            this.translateLikeExpression(expression.getLeftOperand(), expression.getRightOperand(), jsonElement);
        } else if (expression.getOperator() == RelationOperator.IN) {
            this.translateInExpression("$in", (InExpression)expression, jsonElement);
        } else if (expression.getOperator() == RelationOperator.IS) {
            this.translateIsExpression(expression.getLeftOperand(), jsonElement, false);
        } else if (expression.getOperator() == RelationOperator.EXISTS) {
            this.translateExistsExpression((ExistsExpression)expression, jsonElement);
        } else {
            this.translateOperand(expression.getRightOperand(), jsonElement);
        }
    }

    protected void translateRelationExpression(String operator, AbstractOperationExpression expression, JsonElement jsonElement) {
        JsonObject jo = new JsonObject();
        jo.add(operator, this.translateUnaryOperand(expression.getRightOperand()));
        this.putObject(jsonElement, this.getFieldName(expression.getLeftOperand().getName()), (JsonElement)jo);
    }

    protected void translateParenExpression(ParenExpression expression, JsonElement jsonElement) {
        this.translateOperand(expression.getOperand(), jsonElement);
    }

    protected JsonElement translateUnaryOperand(Operand operand) {
        String name = operand.getName();
        if (operand instanceof MemberVariableExpression) {
            int index = name.indexOf(46);
            if (index != -1) {
                return new JsonPrimitive("$" + name.substring(index + 1));
            }
        } else {
            if (operand instanceof Variable) {
                return new JsonPrimitive("$" + name);
            }
            if (operand instanceof StringConstant) {
                return new JsonPrimitive(name.substring(1, name.length() - 1));
            }
            if (operand instanceof LongConstant) {
                return new JsonPrimitive((Number)Long.valueOf(name));
            }
            if (operand instanceof DoubleConstant) {
                return new JsonPrimitive((Number)Double.valueOf(name));
            }
            if (operand instanceof BooleanConstant) {
                return new JsonPrimitive(Boolean.valueOf(name));
            }
            if (operand instanceof AbstractFunction) {
                if (!exceptionFunctions.contains(operand.getName())) {
                    JsonObject function = new JsonObject();
                    this.translateFunction((AbstractFunction)operand, (JsonElement)function);
                    return function;
                }
                return new JsonPrimitive(operand.toString().replace('\'', '\"'));
            }
        }
        return new JsonPrimitive(name);
    }

    protected void translateBetweenExpression(BetweenExpression expression, JsonElement jsonElement) {
        JsonObject cmp = new JsonObject();
        int i = 0;
        for (Operand rOperand : expression.getrOperands()) {
            if (i == 0) {
                cmp.add("$gte", this.translateUnaryOperand(rOperand));
                ++i;
                continue;
            }
            cmp.add("$lt", this.translateUnaryOperand(rOperand));
        }
        this.putObject(jsonElement, this.getFieldName(expression.getLeftOperand().getName()), (JsonElement)cmp);
    }

    protected void translateLikeExpression(Operand lOperand, Operand rOperand, JsonElement jsonElement) {
        JsonObject regex = new JsonObject();
        regex.addProperty("$regex", LikeExpression.translatePattern2Regex((String)rOperand.operate((EntityMap)null).toString()));
        JsonElement je = regex.get("$regex");
        StringBuilder sbud = new StringBuilder();
        sbud.append(je.getAsString());
        regex.addProperty("$regex", sbud.toString());
        this.putObject(jsonElement, this.getFieldName(lOperand.getName()), (JsonElement)regex);
    }

    protected void translateInExpression(String operator, InExpression expression, JsonElement jsonElement) {
        JsonObject in = new JsonObject();
        JsonArray array = new JsonArray();
        for (Operand rOperand : expression.getrOperands()) {
            array.add(this.translateUnaryOperand(rOperand));
        }
        in.add(operator, (JsonElement)array);
        this.putObject(jsonElement, this.getFieldName(expression.getLeftOperand().getName()), (JsonElement)in);
    }

    protected void translateIsExpression(Operand lOperand, JsonElement jsonElement, boolean isNot) {
        JsonObject is = new JsonObject();
        if (!isNot) {
            is.add("$eq", null);
        } else {
            is.add("$ne", null);
        }
        this.putObject(jsonElement, this.getFieldName(lOperand.getName()), (JsonElement)is);
    }

    protected void translateExistsExpression(ExistsExpression existsExpression, JsonElement jsonElement) {
        JsonObject exists = new JsonObject();
        exists.addProperty("$exists", Boolean.valueOf(true));
        this.putObject(jsonElement, this.getFieldName(existsExpression.getRightOperand().getName()), (JsonElement)exists);
    }

    protected void translateFunction(AbstractFunction function, JsonElement jsonObject) {
        MongoFunctionTranslator functionTranslator = this.functionTranslators.get(function.getName());
        if (functionTranslator == null) {
            if (function.getParameters().size() == 1) {
                JsonElement je = this.translateUnaryOperand((Operand)function.getParameters().get(0));
                this.putObject(jsonObject, "$" + function.getName(), je);
            } else {
                JsonArray jv = new JsonArray();
                for (int i = 0; i < function.getParameterCount(); ++i) {
                    jv.add(this.translateUnaryOperand((Operand)function.getParameters().get(i)));
                }
                this.putObject(jsonObject, "$" + function.getName(), (JsonElement)jv);
            }
        } else {
            functionTranslator.translate((Function)function, jsonObject);
        }
    }

    protected void translateHavingClause(HavingImpl having, JsonElement jsonElement) {
        JsonObject match = new JsonObject();
        this.translateOperand(having.getCondition().getOperand(), (JsonElement)match);
        this.putObject(jsonElement, "$match", (JsonElement)match);
    }

    protected String translate2Sql(SetlectorImpl setlector, Map<String, Object> translationContext) {
        throw new UnsupportedOperationException("pending...");
    }

    @Override
    public String translate2Condition(Filter filter) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public String translate2Condition(Filter filter, Map<String, Object> translationContext) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public synchronized void addFunctionTranslator(FunctionTranslator functionTranslator) {
        this.functionTranslators.put(functionTranslator.getFunctionName(), (MongoFunctionTranslator)functionTranslator);
    }

    @Override
    public synchronized void addAllFunctionTranslator(List<FunctionTranslator> functiionTranslators) {
        for (FunctionTranslator functionTranslator : functiionTranslators) {
            this.functionTranslators.put(functionTranslator.getFunctionName(), (MongoFunctionTranslator)functionTranslator);
        }
    }

    @Override
    public synchronized FunctionTranslator removeFunctionTranslator(String functionName) {
        return this.functionTranslators.remove(functionName);
    }

    @Override
    public synchronized List<FunctionTranslator> getFunctionTranslators() {
        return new LinkedList<FunctionTranslator>(this.functionTranslators.values());
    }

    static {
        exceptionFunctions.add("ISODate");
        gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
    }
}

