/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql.es;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.sql.es.AbstractESFunctionTranslator;

public class MatchPhraseTranslator
extends AbstractESFunctionTranslator {
    public static final String FUNCTION_NAME = "matchPhrase";

    public MatchPhraseTranslator() {
        super(FUNCTION_NAME);
    }

    @Override
    protected void innerTranslate(Function function, JsonElement jsonObject) {
        if (function.getParameterCount() != 2 && function.getParameterCount() != 3) {
            throw new IllegalArgumentException("Error function! The matchPhrase function's format should be matchPhrase(field, queryString) or matchPhrase(field, queryString, analyzer)!");
        }
        List parameters = function.getParameters();
        String fieldString = this.getOperandName((Operand)parameters.get(0));
        String field = this.getOperandName(fieldString);
        if (parameters.size() == 2) {
            JsonObject matchPhrase = new JsonObject();
            matchPhrase.addProperty(field, this.getOperandName((Operand)parameters.get(1)));
            this.putObject(jsonObject, "match_phrase", matchPhrase);
        } else {
            JsonObject matchPhrase = new JsonObject();
            JsonObject inPhrase = new JsonObject();
            inPhrase.addProperty("query", this.getOperandName((Operand)parameters.get(1)));
            inPhrase.addProperty("analyzer", this.getOperandName((Operand)parameters.get(2)));
            matchPhrase.add(field, (JsonElement)inPhrase);
            this.putObject(jsonObject, "match_phrase", matchPhrase);
        }
    }
}

