/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql.es;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.sql.es.AbstractESFunctionTranslator;

public class KNNTranslator
extends AbstractESFunctionTranslator {
    public static final String FUNCTION_NAME = "knn";

    public KNNTranslator() {
        super(FUNCTION_NAME);
    }

    @Override
    protected void innerTranslate(Function function, JsonElement jsonObject) {
        if (function.getParameterCount() != 4) {
            throw new IllegalArgumentException("Error function! The match function's format should be match(fields,query_vector,k,num_candidates)!");
        }
        JsonObject knn = new JsonObject();
        List parameters = function.getParameters();
        this.putObject((JsonElement)knn, "field", this.trimChar(((Operand)parameters.get(0)).toString(), "'"));
        String vector = this.trimChar(((Operand)parameters.get(1)).toString(), "'");
        vector = this.trimChar(vector, "[");
        vector = this.trimChar(vector, "]");
        String[] vectors = StringUtils.split((String)vector, (String)",");
        double[] queryVector = new double[vectors.length];
        for (int i = 0; i < vectors.length; ++i) {
            queryVector[i] = Double.parseDouble(vectors[i]);
        }
        JsonArray jsonArray = new Gson().toJsonTree((Object)queryVector).getAsJsonArray();
        knn.add("query_vector", (JsonElement)jsonArray);
        this.putObject((JsonElement)knn, "k", parameters.get(2));
        this.putObject((JsonElement)knn, "num_candidates", parameters.get(3));
        this.putObject(jsonObject, FUNCTION_NAME, knn);
    }

    private String trimChar(String str, String replaceChar) {
        if (str.startsWith(replaceChar)) {
            str = str.substring(1);
        }
        if (str.endsWith(replaceChar)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

