/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql.es;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.Filter;
import org.datayoo.moql.MoqlTranslationException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.Selector;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.ColumnsRecordSetOperator;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.Group;
import org.datayoo.moql.core.HavingImpl;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.Order;
import org.datayoo.moql.core.OrderImpl;
import org.datayoo.moql.core.RecordSetOperator;
import org.datayoo.moql.core.SelectorImpl;
import org.datayoo.moql.core.SetlectorImpl;
import org.datayoo.moql.core.group.GroupRecordSetOperator;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.metadata.ColumnsMetadata;
import org.datayoo.moql.metadata.LimitMetadata;
import org.datayoo.moql.metadata.OrderType;
import org.datayoo.moql.metadata.SelectorMetadata;
import org.datayoo.moql.operand.constant.StringConstant;
import org.datayoo.moql.operand.expression.AbstractOperationExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.ParenExpression;
import org.datayoo.moql.operand.expression.logic.LogicOperator;
import org.datayoo.moql.operand.expression.logic.NotExpression;
import org.datayoo.moql.operand.expression.member.MemberVariableExpression;
import org.datayoo.moql.operand.expression.relation.BetweenExpression;
import org.datayoo.moql.operand.expression.relation.InExpression;
import org.datayoo.moql.operand.expression.relation.IsExpression;
import org.datayoo.moql.operand.expression.relation.LikeExpression;
import org.datayoo.moql.operand.expression.relation.RelationOperator;
import org.datayoo.moql.operand.function.AbstractFunction;
import org.datayoo.moql.operand.function.AggregationFunction;
import org.datayoo.moql.operand.function.Count;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.sql.FunctionTranslator;
import org.datayoo.moql.sql.SqlTranslator;
import org.datayoo.moql.sql.es.ESFunctionTranslator;
import org.datayoo.moql.sql.es.FuzzyTranslator;
import org.datayoo.moql.sql.es.IdsTranslator;
import org.datayoo.moql.sql.es.KNNTranslator;
import org.datayoo.moql.sql.es.MatchPhrasePrefixTranslator;
import org.datayoo.moql.sql.es.MatchPhraseTranslator;
import org.datayoo.moql.sql.es.MatchTranslator;
import org.datayoo.moql.sql.es.MoreLikeTranslator;
import org.datayoo.moql.sql.es.RegExpTranslator;
import org.datayoo.moql.sql.es.TermsSetTranslator;
import org.datayoo.moql.sql.es.TypeTranslator;
import org.datayoo.moql.util.StringFormater;

public class ElasticSearchTranslator
implements SqlTranslator {
    protected Map<String, ESFunctionTranslator> functionTranslators = new HashMap<String, ESFunctionTranslator>();
    protected static Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();

    public ElasticSearchTranslator() {
        this.functionTranslators.put("match", new MatchTranslator());
        this.functionTranslators.put("matchPhrase", new MatchPhraseTranslator());
        this.functionTranslators.put("matchPhrasePrefix", new MatchPhrasePrefixTranslator());
        this.functionTranslators.put("termsSet", new TermsSetTranslator());
        this.functionTranslators.put("regex", new RegExpTranslator());
        this.functionTranslators.put("fuzzy", new FuzzyTranslator());
        this.functionTranslators.put("type", new TypeTranslator());
        this.functionTranslators.put("ids", new IdsTranslator());
        this.functionTranslators.put("moreLike", new MoreLikeTranslator());
        this.functionTranslators.put("knn", new KNNTranslator());
    }

    @Override
    public String translate2Sql(Selector selector) {
        return this.translate2Sql(selector, new HashMap<String, Object>());
    }

    @Override
    public String translate2Sql(Selector selector, Map<String, Object> translationContext) {
        Validate.notNull((Object)selector, (String)"selector is null!", (Object[])new Object[0]);
        if (selector instanceof SelectorImpl) {
            return this.translate2Sql((SelectorImpl)selector, translationContext);
        }
        return this.translate2Sql((SetlectorImpl)selector, translationContext);
    }

    protected String translate2Sql(SelectorImpl selector, Map<String, Object> translationContext) {
        this.checkGrammer(selector);
        JsonObject jsonObject = new JsonObject();
        if (this.isAggregations(selector)) {
            this.translate2Aggs(selector, jsonObject, translationContext);
        } else {
            this.translate2Query(selector, jsonObject, translationContext);
        }
        return gson.toJson((JsonElement)jsonObject);
    }

    protected void checkGrammer(SelectorImpl selector) {
        if (selector.getTables().getTablesMetadata().getTables().size() > 1) {
            throw new MoqlTranslationException("The sql querys more than 1 table!");
        }
    }

    protected void translate2Query(SelectorImpl selector, JsonObject jsonObject, Map<String, Object> translationContext) {
        this.translateSelectClause(selector.getSelectorDefinition(), jsonObject, translationContext);
        if (selector.getLimit() != null) {
            this.translateLimitClause(selector.getLimit(), jsonObject, translationContext);
        }
        if (selector.getOrder() != null) {
            this.translateOrderClause(selector.getOrder(), (JsonElement)jsonObject, translationContext);
        }
        this.translate2CommonQuery(selector, jsonObject, translationContext);
    }

    protected void translate2Aggs(SelectorImpl selector, JsonObject jsonObject, Map<String, Object> translationContext) {
        jsonObject.addProperty("size", (Number)0);
        this.translate2CommonQuery(selector, jsonObject, translationContext);
        this.translate2Aggregations(selector, jsonObject, translationContext);
    }

    protected void translateSelectClause(SelectorDefinition selectorDefinition, JsonObject jsonObject, Map<String, Object> translationContext) {
        ColumnsMetadata columnsMetadata = ((SelectorMetadata)selectorDefinition).getColumns();
        if (this.isSelectAll(columnsMetadata)) {
            return;
        }
        JsonObject source = new JsonObject();
        JsonArray includes = new JsonArray();
        for (ColumnMetadata columnMetadata : columnsMetadata.getColumns()) {
            if (columnMetadata.getNestedSelector() != null) {
                throw new UnsupportedOperationException("Unsupported nested selector in select clause!");
            }
            String value = columnMetadata.getValue();
            includes.add(value);
        }
        source.add("includes", (JsonElement)includes);
        jsonObject.add("_source", (JsonElement)source);
    }

    protected boolean isSelectAll(ColumnsMetadata columnsMetadata) {
        ColumnMetadata columnMetadata;
        String value;
        List columnMetadatas = columnsMetadata.getColumns();
        return columnMetadatas.size() == 1 && (value = (columnMetadata = (ColumnMetadata)columnMetadatas.get(0)).getValue()).endsWith(".*");
    }

    protected void translateLimitClause(Limit limit, JsonObject jsonObject, Map<String, Object> translationContext) {
        if (limit == null) {
            return;
        }
        LimitMetadata limitMetadata = limit.getLimitMetadata();
        Object[] searchAfter = (Object[])translationContext.get("es.resultSortFeatures");
        if (searchAfter != null && searchAfter.length > 0) {
            jsonObject.add("search_after", (JsonElement)this.createSearchAfter(searchAfter));
        } else if (limit.getLimitMetadata().getOffset() != 0) {
            jsonObject.addProperty("from", (Number)limitMetadata.getOffset());
        }
        jsonObject.addProperty("size", (Number)limitMetadata.getValue());
    }

    protected JsonArray createSearchAfter(Object[] searchAfter) {
        JsonArray jsonSearchAfter = new JsonArray();
        for (int i = 0; i < searchAfter.length; ++i) {
            if (searchAfter[i] instanceof Number) {
                jsonSearchAfter.add((Number)searchAfter[i]);
                continue;
            }
            if (searchAfter[i] instanceof Boolean) {
                jsonSearchAfter.add((Boolean)searchAfter[i]);
                continue;
            }
            jsonSearchAfter.add((String)searchAfter[i]);
        }
        return jsonSearchAfter;
    }

    protected void translateOrderClause(Order order, JsonElement jsonElement, Map<String, Object> translationContext) {
        if (order == null) {
            return;
        }
        JsonArray sortObject = new JsonArray();
        OrderImpl orderImpl = (OrderImpl)order;
        Column[] columns = orderImpl.getOrderColumns();
        OrderType[] orderTypes = orderImpl.getOrderTypes();
        for (int i = 0; i < columns.length; ++i) {
            JsonObject orderObject = new JsonObject();
            JsonObject object = new JsonObject();
            object.addProperty("order", orderTypes[i].name().toLowerCase());
            orderObject.add(this.getOperandName(columns[i].getOperand()), (JsonElement)object);
            sortObject.add((JsonElement)orderObject);
        }
        this.putObject(jsonElement, "sort", (JsonElement)sortObject);
    }

    protected boolean isAggregations(SelectorImpl selector) {
        RecordSetOperator recordSetOperator = selector.getRecordSetOperator();
        if (recordSetOperator instanceof Group) {
            return true;
        }
        Columns columns = recordSetOperator.getColumns();
        if (columns.getColumnsMetadata().isDistinct()) {
            return true;
        }
        for (Column column : columns.getColumns()) {
            if (!(column.getOperand() instanceof AggregationFunction)) continue;
            return true;
        }
        return false;
    }

    protected void translate2Aggregations(SelectorImpl selector, JsonObject jsonObject, Map<String, Object> translationContext) {
        RecordSetOperator recordSetOperator = selector.getRecordSetOperator();
        if (recordSetOperator instanceof Group) {
            this.translate2GroupAggregations((GroupRecordSetOperator)recordSetOperator, jsonObject, selector.getLimit(), selector.getOrder(), translationContext);
        } else if (recordSetOperator.getColumns().getColumnsMetadata().isDistinct()) {
            this.translate2DistinctAggregations((ColumnsRecordSetOperator)recordSetOperator, jsonObject, selector.getLimit(), selector.getOrder(), translationContext);
        } else {
            this.translateColumnAggregations((ColumnsRecordSetOperator)recordSetOperator, jsonObject, translationContext);
        }
    }

    protected void translate2GroupAggregations(GroupRecordSetOperator groupRecordSetOperator, JsonObject jsonObject, Limit limit, Order order, Map<String, Object> translationContext) {
        Column[] columns = groupRecordSetOperator.getGroupColumns();
        JsonObject baseObject = jsonObject;
        jsonObject.add("aggs", (JsonElement)baseObject);
        int size = this.getLimitSize(limit);
        for (int i = 0; i < columns.length; ++i) {
            baseObject = this.translate2TermsAggs(columns[i], baseObject, size, order, translationContext);
            size = 0;
        }
        columns = groupRecordSetOperator.getNonGroupColumns();
        JsonObject aggsObject = new JsonObject();
        baseObject.add("aggs", (JsonElement)aggsObject);
        JsonArray orderArray = null;
        if (order != null) {
            orderArray = this.getOrderArray(baseObject);
        }
        for (int i = 0; i < columns.length; ++i) {
            OrderType orderType;
            if (columns[i] == null) continue;
            JsonObject aggregation = new JsonObject();
            this.translateFunctionAggregation((AggregationFunction)columns[i].getOperand(), aggregation, translationContext);
            if (aggregation.entrySet().size() > 0) {
                aggsObject.add(columns[i].getColumnMetadata().getName(), (JsonElement)aggregation);
            }
            if (order == null || (orderType = this.getOrderType(columns[i], order)) == null) continue;
            JsonObject orderObject = new JsonObject();
            orderObject.addProperty(columns[i].getColumnMetadata().getName(), orderType.name().toLowerCase());
            orderArray.add((JsonElement)orderObject);
        }
        if (order != null && orderArray.size() == 0) {
            this.removeOrderArray(baseObject);
        }
    }

    protected int getLimitSize(Limit limit) {
        if (limit == null) {
            return 0;
        }
        LimitMetadata metadata = limit.getLimitMetadata();
        return metadata.getValue();
    }

    protected JsonObject translate2TermsAggs(Column column, JsonObject jsonObject, int size, Order order, Map<String, Object> translationContext) {
        JsonObject aggsObject = new JsonObject();
        jsonObject.add("aggs", (JsonElement)aggsObject);
        JsonObject aggregation = new JsonObject();
        this.translateTermsAggregation(this.getOperandName(column.getOperand()), aggregation, size, order, translationContext);
        aggsObject.add(this.getOperandName(column.getOperand()), (JsonElement)aggregation);
        return aggregation;
    }

    protected void translateFunctionAggregation(AggregationFunction aggregationFunction, JsonObject jsonObject, Map<String, Object> translationContext) {
        JsonObject functionObject = new JsonObject();
        String functionName = this.getFunctionName(aggregationFunction);
        if (functionName == null) {
            return;
        }
        Operand operand = (Operand)aggregationFunction.getParameters().get(0);
        functionObject.addProperty("field", this.getOperandName(operand));
        jsonObject.add(functionName, (JsonElement)functionObject);
    }

    protected String getFunctionName(AggregationFunction aggregationFunction) {
        String functionName = aggregationFunction.getName();
        if (functionName.equals("count")) {
            Count count = (Count)aggregationFunction;
            if (count.isDistinct()) {
                return "cardinality";
            }
            return null;
        }
        return functionName;
    }

    protected void translateTermsAggregation(String fieldName, JsonObject jsonObject, int size, Order order, Map<String, Object> translationContext) {
        JsonArray orderArray;
        JsonObject termsObject = new JsonObject();
        termsObject.addProperty("field", fieldName);
        if (size != 0) {
            termsObject.addProperty("size", (Number)size);
        }
        if ((orderArray = this.translateTermsOrder(fieldName, order, translationContext)) != null) {
            termsObject.add("order", (JsonElement)orderArray);
        }
        jsonObject.add("terms", (JsonElement)termsObject);
    }

    protected JsonArray translateTermsOrder(String fieldName, Order order, Map<String, Object> translationContext) {
        if (order == null) {
            return null;
        }
        OrderImpl orderImpl = (OrderImpl)order;
        Column[] columns = orderImpl.getOrderColumns();
        OrderType[] orderTypes = orderImpl.getOrderTypes();
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getOperand() instanceof Count) {
                Count count = (Count)columns[i].getOperand();
                String name = this.getOperandName((Operand)count.getParameters().get(0));
                if (!name.equals(fieldName)) continue;
                this.add2OrderArray("_count", orderTypes[i], jsonArray);
                break;
            }
            String tmp = this.getOperandName(columns[i].getOperand());
            if (!tmp.equals(fieldName)) continue;
            this.add2OrderArray("_term", orderTypes[i], jsonArray);
            break;
        }
        if (jsonArray.size() == 0) {
            return null;
        }
        return jsonArray;
    }

    protected void add2OrderArray(String field, OrderType orderType, JsonArray jsonArray) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(field, orderType.name().toLowerCase());
        jsonArray.add((JsonElement)jsonObject);
    }

    protected JsonArray getOrderArray(JsonObject aggregation) {
        JsonObject termsObject = (JsonObject)aggregation.get("terms");
        JsonArray orderArray = (JsonArray)termsObject.get("order");
        if (orderArray == null) {
            orderArray = new JsonArray();
            termsObject.add("order", (JsonElement)orderArray);
        }
        return orderArray;
    }

    protected void removeOrderArray(JsonObject aggregation) {
        JsonObject termsObject = (JsonObject)aggregation.get("terms");
        termsObject.remove("order");
    }

    protected OrderType getOrderType(Column column, Order order) {
        OrderImpl orderImpl = (OrderImpl)order;
        Column[] columns = orderImpl.getOrderColumns();
        OrderType[] orderTypes = orderImpl.getOrderTypes();
        String columnName = column.getColumnMetadata().getName();
        for (int i = 0; i < columns.length; ++i) {
            String tmp = columns[i].getColumnMetadata().getName();
            if (!tmp.equals(columnName)) continue;
            return orderTypes[i];
        }
        return null;
    }

    protected void translate2DistinctAggregations(ColumnsRecordSetOperator columnsRecordSetOperator, JsonObject jsonObject, Limit limit, Order order, Map<String, Object> translationContext) {
        JsonObject baseObject = jsonObject;
        int size = this.getLimitSize(limit);
        for (Column column : columnsRecordSetOperator.getColumns().getColumns()) {
            baseObject = this.translate2TermsAggs(column, baseObject, size, order, translationContext);
            size = 0;
        }
    }

    protected void translateColumnAggregations(ColumnsRecordSetOperator columnsRecordSetOperator, JsonObject jsonObject, Map<String, Object> translationContext) {
        for (Column column : columnsRecordSetOperator.getColumns().getColumns()) {
            JsonObject aggsObject = new JsonObject();
            jsonObject.add("aggs", (JsonElement)aggsObject);
            if (!(column.getOperand() instanceof AggregationFunction)) continue;
            JsonObject aggregation = new JsonObject();
            this.translateFunctionAggregation((AggregationFunction)column.getOperand(), aggregation, translationContext);
            aggsObject.add(column.getColumnMetadata().getName(), (JsonElement)aggregation);
        }
    }

    protected void translate2CommonQuery(SelectorImpl selector, JsonObject jsonObject, Map<String, Object> translationContext) {
        JsonObject queryObject = new JsonObject();
        if (selector.getWhere() != null) {
            this.translateKnn(selector.getWhere().getOperand(), (JsonElement)jsonObject);
        }
        if (selector.getHaving() != null) {
            JsonObject jsonElement;
            if (selector.getWhere() != null) {
                jsonElement = this.translateWhereClause(selector.getWhere(), (JsonElement)queryObject, true, translationContext);
            } else {
                jsonElement = new JsonObject();
                queryObject.add("bool", (JsonElement)jsonElement);
            }
            this.translateHavingClause((HavingImpl)selector.getHaving(), (JsonElement)jsonElement, translationContext);
        } else {
            this.translateWhereClause(selector.getWhere(), (JsonElement)queryObject, false, translationContext);
        }
        if (queryObject.size() > 0) {
            jsonObject.add("query", (JsonElement)queryObject);
        }
    }

    protected boolean isLogicExpression(Operand operand) {
        AbstractOperationExpression expression;
        return operand instanceof AbstractOperationExpression && (expression = (AbstractOperationExpression)operand).getExpressionType() == ExpressionType.LOGIC;
    }

    protected JsonElement translateWhereClause(Condition condition, JsonElement jsonElement, boolean hasHaving, Map<String, Object> translationContext) {
        if (condition == null) {
            if (!hasHaving) {
                JsonObject matchAll = new JsonObject();
                this.putObject(jsonElement, "match_all", (JsonElement)matchAll);
            }
            return jsonElement;
        }
        Operand operand = condition.getOperand();
        if (this.isLogicExpression(operand)) {
            return this.shellLogicExpression(operand, jsonElement, translationContext);
        }
        if (hasHaving) {
            return this.shellHasHaving(operand, jsonElement, translationContext);
        }
        this.translateOperand(operand, jsonElement, false, translationContext);
        return jsonElement;
    }

    protected void translateKnn(Operand operand, JsonElement jsonElement) {
        if (operand instanceof AbstractOperationExpression) {
            AbstractOperationExpression expression = (AbstractOperationExpression)operand;
            if (expression.getExpressionType() == ExpressionType.LOGIC) {
                this.translateKnn(expression.getLeftOperand(), jsonElement);
                this.translateKnn(expression.getRightOperand(), jsonElement);
            } else if (expression.getExpressionType() == ExpressionType.RELATION && expression.getOperator() == RelationOperator.EXPR) {
                this.translateFunction((AbstractFunction)expression.getRightOperand(), jsonElement, null);
            }
        }
    }

    protected JsonElement shellLogicExpression(Operand operand, JsonElement jsonElement, Map<String, Object> translationContext) {
        JsonObject shellObject = new JsonObject();
        this.translateOperand(operand, (JsonElement)shellObject, false, translationContext);
        Iterator iterator = shellObject.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.putObject(jsonElement, (String)entry.getKey(), (JsonElement)entry.getValue());
            return (JsonElement)entry.getValue();
        }
        throw new IllegalArgumentException("Invalid operand!");
    }

    protected void putObject(JsonElement jsonElement, String name, JsonElement valueJson) {
        if (jsonElement instanceof JsonObject) {
            ((JsonObject)jsonElement).add(name, valueJson);
        } else {
            JsonObject jo = new JsonObject();
            jo.add(name, valueJson);
            ((JsonArray)jsonElement).add((JsonElement)jo);
        }
    }

    protected JsonElement shellHasHaving(Operand operand, JsonElement jsonElement, Map<String, Object> translationContext) {
        JsonObject boolObject = new JsonObject();
        JsonObject mustObject = new JsonObject();
        this.translateOperand(operand, (JsonElement)mustObject, false, translationContext);
        this.putObject((JsonElement)boolObject, "must", (JsonElement)mustObject);
        this.putObject(jsonElement, "bool", (JsonElement)boolObject);
        return boolObject;
    }

    protected void translateOperand(Operand operand, JsonElement jsonElement, boolean having, Map<String, Object> translationContext) {
        if (operand instanceof AbstractOperationExpression) {
            AbstractOperationExpression expression = (AbstractOperationExpression)operand;
            if (expression.getExpressionType() == ExpressionType.LOGIC) {
                this.translateLogicExpression(expression, jsonElement, having, translationContext);
            } else if (expression.getExpressionType() == ExpressionType.RELATION) {
                this.translateRelationExpression(expression, jsonElement, having, translationContext);
            } else if (expression.getExpressionType() == ExpressionType.ARITHMETIC) {
                throw new MoqlTranslationException(StringFormater.format((String)"The expression '{}' does not support!", (Object[])new Object[]{expression.getExpressionType().toString()}));
            }
        } else if (operand instanceof ParenExpression) {
            ParenExpression parenExpression = (ParenExpression)operand;
            this.translateParenExpression(parenExpression, jsonElement, having, translationContext);
        } else if (operand instanceof AbstractFunction) {
            AbstractFunction function = (AbstractFunction)operand;
            if (!"knn".equals(function.getName())) {
                this.translateFunction(function, jsonElement, translationContext);
            }
        } else {
            throw new MoqlTranslationException(StringFormater.format((String)"The operand '{}' does not support!", (Object[])new Object[]{operand.getOperandType().toString()}));
        }
    }

    protected void translateLogicExpression(AbstractOperationExpression expression, JsonElement jsonElement, boolean having, Map<String, Object> translationContext) {
        JsonObject boolObject = new JsonObject();
        if (expression.getOperator() == LogicOperator.NOT) {
            this.translateNotExpression((NotExpression)expression, (JsonElement)boolObject, having, translationContext);
        } else if (expression.getOperator() == LogicOperator.AND) {
            String operator = "must";
            if (having) {
                operator = "filter";
            }
            this.translateLogicBinaryExpression(operator, expression.getLeftOperand(), expression.getRightOperand(), (JsonElement)boolObject, having, translationContext);
        } else {
            this.translateLogicBinaryExpression("should", expression.getLeftOperand(), expression.getRightOperand(), (JsonElement)boolObject, having, translationContext);
        }
        this.putObject(jsonElement, "bool", (JsonElement)boolObject);
    }

    protected void translateNotExpression(NotExpression expression, JsonElement jsonElement, boolean having, Map<String, Object> translationContext) {
        JsonObject not = new JsonObject();
        if (expression.getRightOperand() instanceof IsExpression) {
            IsExpression isExpression = (IsExpression)expression.getRightOperand();
            this.translateIsExpression(isExpression.getLeftOperand(), jsonElement, true, translationContext);
        } else {
            this.translateOperand(expression.getRightOperand(), (JsonElement)not, having, translationContext);
            this.putObject(jsonElement, "must_not", (JsonElement)not);
        }
    }

    protected void translateLogicBinaryExpression(String operator, Operand lOperand, Operand rOperand, JsonElement jsonElement, boolean having, Map<String, Object> translationContext) {
        JsonArray logicArray = new JsonArray();
        this.translateOperand(lOperand, (JsonElement)logicArray, having, translationContext);
        this.translateOperand(rOperand, (JsonElement)logicArray, having, translationContext);
        this.putObject(jsonElement, operator, (JsonElement)logicArray);
    }

    protected void translateRelationExpression(AbstractOperationExpression expression, JsonElement jsonElement, boolean having, Map<String, Object> translationContext) {
        if (expression.getOperator() == RelationOperator.EQ) {
            this.translateEQExpression(expression.getLeftOperand(), expression.getRightOperand(), jsonElement, having, translationContext);
        } else if (expression.getOperator() == RelationOperator.GT) {
            this.translateLGExpression("gt", expression.getLeftOperand(), expression.getRightOperand(), jsonElement, translationContext);
        } else if (expression.getOperator() == RelationOperator.GE) {
            this.translateLGExpression("gte", expression.getLeftOperand(), expression.getRightOperand(), jsonElement, translationContext);
        } else if (expression.getOperator() == RelationOperator.LT) {
            this.translateLGExpression("lt", expression.getLeftOperand(), expression.getRightOperand(), jsonElement, translationContext);
        } else if (expression.getOperator() == RelationOperator.LE) {
            this.translateLGExpression("lte", expression.getLeftOperand(), expression.getRightOperand(), jsonElement, translationContext);
        } else if (expression.getOperator() == RelationOperator.NE) {
            this.translateNEExpression(expression.getLeftOperand(), expression.getRightOperand(), jsonElement, translationContext);
        } else if (expression.getOperator() == RelationOperator.BETWEEN) {
            this.translateBetweenExpression((BetweenExpression)expression, jsonElement, translationContext);
        } else if (expression.getOperator() == RelationOperator.LIKE) {
            this.translateLikeExpression(expression.getLeftOperand(), expression.getRightOperand(), jsonElement, translationContext);
        } else if (expression.getOperator() == RelationOperator.IN) {
            this.translateInExpression((InExpression)expression, jsonElement, translationContext);
        } else if (expression.getOperator() == RelationOperator.IS) {
            this.translateIsExpression(expression.getLeftOperand(), jsonElement, false, translationContext);
        } else {
            if (expression.getOperator() == RelationOperator.EXISTS) {
                throw new UnsupportedOperationException("Does't support 'exists' operator.Please use 'is' operator!");
            }
            this.translateOperand(expression.getRightOperand(), jsonElement, having, translationContext);
        }
    }

    protected void translateParenExpression(ParenExpression expression, JsonElement jsonElement, boolean having, Map<String, Object> translationContext) {
        this.translateOperand(expression.getOperand(), jsonElement, having, translationContext);
    }

    protected void translateEQExpression(Operand lOperand, Operand rOperand, JsonElement jsonElement, boolean having, Map<String, Object> translationContext) {
        JsonObject eq = new JsonObject();
        eq.addProperty(this.getOperandName(lOperand), this.getOperandName(rOperand));
        this.putObject(jsonElement, "term", (JsonElement)eq);
    }

    protected String getOperandName(Operand operand) {
        String name = operand.getName();
        if (operand instanceof MemberVariableExpression) {
            int index = name.indexOf(46);
            if (index != -1) {
                return name.substring(index + 1);
            }
        } else {
            if (operand instanceof StringConstant) {
                return name.substring(1, name.length() - 1);
            }
            if (operand instanceof Function) {
                return operand.toString();
            }
        }
        return name;
    }

    protected void translateLGExpression(String operator, Operand lOperand, Operand rOperand, JsonElement jsonElement, Map<String, Object> translationContext) {
        JsonObject range = new JsonObject();
        JsonObject cmp = new JsonObject();
        cmp.addProperty(operator, this.getOperandName(rOperand));
        range.add(this.getOperandName(lOperand), (JsonElement)cmp);
        this.putObject(jsonElement, "range", (JsonElement)range);
    }

    protected void translateNEExpression(Operand lOperand, Operand rOperand, JsonElement jsonElement, Map<String, Object> translationContext) {
        JsonObject boolObject = new JsonObject();
        JsonObject notObject = new JsonObject();
        JsonObject term = new JsonObject();
        term.addProperty(this.getOperandName(lOperand), this.getOperandName(rOperand));
        notObject.add("term", (JsonElement)term);
        boolObject.add("must_not", (JsonElement)notObject);
        this.putObject(jsonElement, "bool", (JsonElement)boolObject);
    }

    protected void translateBetweenExpression(BetweenExpression expression, JsonElement jsonElement, Map<String, Object> translationContext) {
        JsonObject range = new JsonObject();
        JsonObject cmp = new JsonObject();
        int i = 0;
        for (Operand rOperand : expression.getrOperands()) {
            if (i == 0) {
                cmp.addProperty("gte", this.getOperandName(rOperand));
                ++i;
                continue;
            }
            cmp.addProperty("lt", this.getOperandName(rOperand));
        }
        range.add(this.getOperandName(expression.getLeftOperand()), (JsonElement)cmp);
        this.putObject(jsonElement, "range", (JsonElement)range);
    }

    protected void translateLikeExpression(Operand lOperand, Operand rOperand, JsonElement jsonElement, Map<String, Object> translationContext) {
        JsonObject regex = new JsonObject();
        regex.addProperty(this.getOperandName(lOperand), LikeExpression.translatePattern2Regex((String)this.getOperandName(rOperand)));
        this.putObject(jsonElement, "regexp", (JsonElement)regex);
    }

    protected void translateInExpression(InExpression expression, JsonElement jsonElement, Map<String, Object> translationContext) {
        JsonObject terms = new JsonObject();
        JsonArray array = new JsonArray();
        for (Operand rOperand : expression.getrOperands()) {
            array.add(this.getOperandName(rOperand));
        }
        terms.add(this.getOperandName(expression.getLeftOperand()), (JsonElement)array);
        this.putObject(jsonElement, "terms", (JsonElement)terms);
    }

    protected void translateIsExpression(Operand lOperand, JsonElement jsonElement, boolean isNot, Map<String, Object> translationContext) {
        if (!isNot) {
            JsonObject boolObject = new JsonObject();
            JsonObject notObject = new JsonObject();
            JsonObject exists = new JsonObject();
            exists.addProperty("field", this.getOperandName(lOperand));
            this.putObject((JsonElement)notObject, "exists", (JsonElement)exists);
            this.putObject((JsonElement)boolObject, "must_not", (JsonElement)notObject);
            this.putObject(jsonElement, "bool", (JsonElement)boolObject);
        } else {
            JsonObject shouldObject = new JsonObject();
            JsonObject exists = new JsonObject();
            exists.addProperty("field", this.getOperandName(lOperand));
            this.putObject((JsonElement)shouldObject, "exists", (JsonElement)exists);
            this.putObject(jsonElement, "should", (JsonElement)shouldObject);
        }
    }

    protected void translateFunction(AbstractFunction function, JsonElement jsonObject, Map<String, Object> translationContext) {
        ESFunctionTranslator functionTranslator = this.functionTranslators.get(function.getName());
        if (functionTranslator == null) {
            throw new MoqlTranslationException(StringFormater.format((String)"The function '{}' does not support!", (Object[])new Object[]{function.getName()}));
        }
        functionTranslator.translate((Function)function, jsonObject);
    }

    protected void translateHavingClause(HavingImpl having, JsonElement jsonElement, Map<String, Object> translationContext) {
        JsonObject filterObject = new JsonObject();
        this.translateOperand(having.getCondition().getOperand(), (JsonElement)filterObject, true, translationContext);
        this.putObject(jsonElement, "filter", (JsonElement)filterObject);
    }

    protected String translate2Sql(SetlectorImpl setlector, Map<String, Object> translationContext) {
        throw new UnsupportedOperationException("pending...");
    }

    @Override
    public String translate2Condition(Filter filter, Map<String, Object> translationContext) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public String translate2Condition(Filter filter) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public void addFunctionTranslator(FunctionTranslator functionTranslator) {
        this.functionTranslators.put(functionTranslator.getFunctionName(), (ESFunctionTranslator)functionTranslator);
    }

    @Override
    public void addAllFunctionTranslator(List<FunctionTranslator> functiionTranslators) {
        for (FunctionTranslator functionTranslator : functiionTranslators) {
            this.functionTranslators.put(functionTranslator.getFunctionName(), (ESFunctionTranslator)functionTranslator);
        }
    }

    @Override
    public FunctionTranslator removeFunctionTranslator(String functionName) {
        return this.functionTranslators.remove(functionName);
    }

    @Override
    public List<FunctionTranslator> getFunctionTranslators() {
        return new LinkedList<FunctionTranslator>(this.functionTranslators.values());
    }
}

