/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql;

import java.util.Map;
import org.datayoo.moql.core.Cache;
import org.datayoo.moql.core.HavingImpl;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.OrderImpl;
import org.datayoo.moql.core.SelectorImpl;
import org.datayoo.moql.core.group.GroupRecordSetOperator;
import org.datayoo.moql.metadata.LimitMetadata;
import org.datayoo.moql.sql.MoqlGrammarTranslator;

public class OracleTranslator
extends MoqlGrammarTranslator {
    @Override
    protected String translateCache(Cache cache) {
        return "";
    }

    @Override
    protected String translate2Sql(SelectorImpl selector, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.translate2SelectClause(selector.getRecordSetOperator(), translationContext));
        if (selector.getLimit() != null) {
            sbuf.append(",rownum rn ");
        }
        sbuf.append(this.translate2FromClause(selector.getTables(), translationContext));
        if (selector.getWhere() != null || selector.getLimit() != null) {
            sbuf.append(this.translate2WhereClause(selector.getWhere(), translationContext));
        }
        if (selector.getRecordSetOperator() instanceof GroupRecordSetOperator) {
            sbuf.append(this.translate2GroupbyClause((GroupRecordSetOperator)selector.getRecordSetOperator(), translationContext));
        }
        if (selector.getHaving() != null) {
            sbuf.append(this.translate2HavingClause((HavingImpl)selector.getHaving(), translationContext));
        }
        if (selector.getOrder() != null) {
            sbuf.append(this.translate2OrderbyClause((OrderImpl)selector.getOrder(), translationContext));
        }
        if (selector.getLimit() != null) {
            return this.translate2Limit(sbuf.toString(), selector.getLimit());
        }
        return sbuf.toString();
    }

    protected String translate2Limit(String innerSql, Limit limit) {
        LimitMetadata limitMetadata = limit.getLimitMetadata();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("select * from (");
        sbuf.append(innerSql);
        sbuf.append(") where rn between ");
        sbuf.append(limitMetadata.getOffset());
        sbuf.append(" and ");
        sbuf.append(limitMetadata.getValue());
        return sbuf.toString();
    }
}

