/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.Filter;
import org.datayoo.moql.Operand;
import org.datayoo.moql.Selector;
import org.datayoo.moql.core.Cache;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.HavingImpl;
import org.datayoo.moql.core.Join;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.OrderImpl;
import org.datayoo.moql.core.Queryable;
import org.datayoo.moql.core.RecordSetOperator;
import org.datayoo.moql.core.SelectorImpl;
import org.datayoo.moql.core.SetlectorImpl;
import org.datayoo.moql.core.Table;
import org.datayoo.moql.core.Tables;
import org.datayoo.moql.core.group.GroupRecordSetOperator;
import org.datayoo.moql.core.table.SelectorTable;
import org.datayoo.moql.metadata.CacheMetadata;
import org.datayoo.moql.metadata.CombinationType;
import org.datayoo.moql.metadata.GroupMetadata;
import org.datayoo.moql.metadata.JoinMetadata;
import org.datayoo.moql.metadata.JoinType;
import org.datayoo.moql.metadata.LimitMetadata;
import org.datayoo.moql.metadata.OrderMetadata;
import org.datayoo.moql.metadata.OrderType;
import org.datayoo.moql.metadata.SetlectorMetadata;
import org.datayoo.moql.metadata.TableMetadata;
import org.datayoo.moql.operand.expression.AbstractOperationExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.ParenExpression;
import org.datayoo.moql.operand.expression.arithmetic.ArithmeticOperator;
import org.datayoo.moql.operand.expression.bit.BitwiseOperator;
import org.datayoo.moql.operand.expression.logic.LogicOperator;
import org.datayoo.moql.operand.expression.logic.NotExpression;
import org.datayoo.moql.operand.expression.relation.BetweenExpression;
import org.datayoo.moql.operand.expression.relation.ExistsExpression;
import org.datayoo.moql.operand.expression.relation.InExpression;
import org.datayoo.moql.operand.expression.relation.RelationOperator;
import org.datayoo.moql.operand.function.AbstractFunction;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.operand.selector.ColumnSelectorOperand;
import org.datayoo.moql.operand.selector.ValueSelectorOperand;
import org.datayoo.moql.sql.FunctionTranslator;
import org.datayoo.moql.sql.SqlTranslator;
import org.datayoo.moql.util.StringFormater;

public class MoqlGrammarTranslator
implements SqlTranslator {
    protected Map<String, FunctionTranslator> functionTranslators = new HashMap<String, FunctionTranslator>();

    @Override
    public String translate2Sql(Selector selector) {
        return this.translate2Sql(selector, new HashMap<String, Object>());
    }

    @Override
    public String translate2Sql(Selector selector, Map<String, Object> translationContext) {
        Validate.notNull((Object)selector, (String)"selector is null!", (Object[])new Object[0]);
        Validate.notNull(translationContext, (String)"translationContext is null!", (Object[])new Object[0]);
        if (selector instanceof SelectorImpl) {
            return this.translate2Sql((SelectorImpl)selector, translationContext);
        }
        return this.translate2Sql((SetlectorImpl)selector, translationContext);
    }

    protected String translate2Sql(SelectorImpl selector, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.translate2SelectClause(selector.getRecordSetOperator(), translationContext));
        sbuf.append(this.translate2FromClause(selector.getTables(), translationContext));
        if (selector.getWhere() != null) {
            sbuf.append(this.translate2WhereClause(selector.getWhere(), translationContext));
        }
        if (selector.getRecordSetOperator() instanceof GroupRecordSetOperator) {
            sbuf.append(this.translate2GroupbyClause((GroupRecordSetOperator)selector.getRecordSetOperator(), translationContext));
        }
        if (selector.getHaving() != null) {
            sbuf.append(this.translate2HavingClause((HavingImpl)selector.getHaving(), translationContext));
        }
        if (selector.getOrder() != null) {
            sbuf.append(this.translate2OrderbyClause((OrderImpl)selector.getOrder(), translationContext));
        }
        if (selector.getLimit() != null) {
            sbuf.append(this.translate2LimitClause(selector.getLimit(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translate2Sql(SetlectorImpl setlector, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        SetlectorMetadata setlectorMetadata = (SetlectorMetadata)setlector.getSelectorDefinition();
        int i = 0;
        for (Selector selector : setlector.getSets()) {
            if (i != 0) {
                sbuf.append(this.getCombinationType(setlectorMetadata.getCombinationType()));
                sbuf.append(" ");
                if (!setlectorMetadata.getColumns().isDistinct()) {
                    sbuf.append("all ");
                }
            }
            sbuf.append(this.translate2Sql(selector));
            ++i;
        }
        if (setlector.getOrder() != null) {
            sbuf.append(this.translate2OrderbyClause((OrderImpl)setlector.getOrder(), translationContext));
        }
        return sbuf.toString();
    }

    protected String getCombinationType(CombinationType combinationType) {
        if (combinationType.equals((Object)CombinationType.UNION)) {
            return "union";
        }
        if (combinationType.equals((Object)CombinationType.INTERSECT)) {
            return "intersect";
        }
        if (combinationType.equals((Object)CombinationType.EXCEPT)) {
            return "except";
        }
        if (combinationType.equals((Object)CombinationType.SYMEXCEPT)) {
            return "symexcept";
        }
        return "complementation";
    }

    @Override
    public String translate2Condition(Filter filter) {
        return this.translate2Condition(filter, new HashMap<String, Object>());
    }

    @Override
    public String translate2Condition(Filter filter, Map<String, Object> translationContext) {
        Validate.notNull((Object)filter, (String)"filter is null!", (Object[])new Object[0]);
        return this.translateOperand(((Condition)filter).getOperand(), translationContext);
    }

    protected String translate2SelectClause(RecordSetOperator recordSetOperator, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("select ");
        if (recordSetOperator.getCache() != null) {
            sbuf.append(this.translateCache(recordSetOperator.getCache()));
        }
        if (recordSetOperator.getColumns().getColumnsMetadata().isDistinct()) {
            sbuf.append("distinct ");
        }
        sbuf.append(this.translateColumns(recordSetOperator.getColumns(), translationContext));
        return sbuf.toString();
    }

    protected String translateCache(Cache cache) {
        StringBuffer sbuf = new StringBuffer();
        CacheMetadata cacheMetadata = cache.getCacheMetadata();
        sbuf.append("cache(");
        sbuf.append(cacheMetadata.getSize());
        sbuf.append(",");
        sbuf.append(cacheMetadata.getWashoutStrategy().toString().toLowerCase());
        sbuf.append(") ");
        return sbuf.toString();
    }

    protected String translate2LimitClause(Limit limit, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        LimitMetadata limitMetadata = limit.getLimitMetadata();
        sbuf.append("limit ");
        if (limitMetadata.getOffset() != 0) {
            sbuf.append(limitMetadata.getOffset());
            sbuf.append(",");
        }
        sbuf.append(limitMetadata.getValue());
        if (limitMetadata.isPercent()) {
            sbuf.append("%");
        }
        sbuf.append(" ");
        return sbuf.toString();
    }

    protected String translateColumns(Columns columns, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        for (Column column : columns.getColumns()) {
            if (column.isJustUsed4Order()) continue;
            if (i != 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.translateOperand(column.getOperand(), translationContext).trim());
            if (column.getColumnMetadata().isHasAlias()) {
                sbuf.append(" ");
                sbuf.append(column.getColumnMetadata().getName());
            }
            ++i;
        }
        sbuf.append(" ");
        return sbuf.toString();
    }

    protected String translate2FromClause(Tables tables, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        boolean multiTables = false;
        sbuf.append("from ");
        if (tables.getTablesMetadata().getTables().size() > 1) {
            multiTables = true;
        }
        sbuf.append(this.translateQueryable(tables.getQueryable(), multiTables, translationContext));
        return sbuf.toString();
    }

    protected String translateQueryable(Queryable queryable, boolean multiTables, Map<String, Object> translationContext) {
        if (queryable instanceof Table) {
            return this.translateTable((Table)queryable, translationContext);
        }
        return this.translateJoin((Join)queryable, multiTables, translationContext);
    }

    protected String translateTable(Table table, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        TableMetadata tableMetadata = table.getTableMetadata();
        if (table instanceof SelectorTable) {
            SelectorTable selectorTable = (SelectorTable)table;
            sbuf.append("(");
            sbuf.append(this.translate2Sql(selectorTable.getSelector()));
            sbuf.append(") ");
        } else {
            sbuf.append(tableMetadata.getValue());
            sbuf.append(" ");
        }
        sbuf.append(tableMetadata.getName());
        sbuf.append(" ");
        return sbuf.toString();
    }

    protected String translateJoin(Join join, boolean multiTables, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        JoinMetadata joinMetadata = join.getJoinMetadata();
        String leftQuery = this.translateQueryable(join.getLeftQueryable(), multiTables, translationContext);
        if (!multiTables) {
            sbuf.append(leftQuery);
            sbuf.append(this.getJoinType(joinMetadata.getJoinType()));
            sbuf.append(" ");
        } else {
            sbuf.append(leftQuery.trim());
            sbuf.append(", ");
        }
        sbuf.append(this.translateQueryable(join.getRightQueryable(), multiTables, translationContext));
        if (!multiTables && join.getOn() != null) {
            sbuf.append("on ");
            sbuf.append(this.translateOperand(join.getOn().getOperand(), translationContext));
        }
        return sbuf.toString();
    }

    protected String getJoinType(JoinType joinType) {
        if (joinType.equals((Object)JoinType.INNER)) {
            return "inner join";
        }
        if (joinType.equals((Object)JoinType.LEFT)) {
            return "left join";
        }
        if (joinType.equals((Object)JoinType.RIGHT)) {
            return "right join";
        }
        return "full join";
    }

    protected String translate2WhereClause(Condition condition, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("where ");
        sbuf.append(this.translateOperand(condition.getOperand(), translationContext));
        return sbuf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String translateOperand(Operand operand, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        if (operand instanceof AbstractOperationExpression) {
            AbstractOperationExpression expression = (AbstractOperationExpression)operand;
            if (expression.getExpressionType() == ExpressionType.LOGIC) {
                sbuf.append(this.translateLogicExpression(expression, translationContext));
                return sbuf.toString();
            } else if (expression.getExpressionType() == ExpressionType.RELATION) {
                sbuf.append(this.translateRelationExpression(expression, translationContext));
                return sbuf.toString();
            } else if (expression.getExpressionType() == ExpressionType.ARITHMETIC) {
                sbuf.append(this.translateArithmeticExpression(expression, translationContext));
                return sbuf.toString();
            } else {
                if (expression.getExpressionType() != ExpressionType.BITWISE) throw new IllegalArgumentException(StringFormater.format((String)"Doesn't support operand with type '{}'!", (Object[])new Object[]{expression.getExpressionType()}));
                sbuf.append(this.translateBitwiseExpression(expression, translationContext));
            }
            return sbuf.toString();
        } else if (operand instanceof ParenExpression) {
            ParenExpression parenExpression = (ParenExpression)operand;
            sbuf.append(this.translateParenExpression(parenExpression, translationContext));
            return sbuf.toString();
        } else if (operand instanceof ColumnSelectorOperand) {
            ColumnSelectorOperand selectorOperand = (ColumnSelectorOperand)operand;
            sbuf.append(this.translate2Sql(selectorOperand.getColumnSelector()));
            return sbuf.toString();
        } else if (operand instanceof ValueSelectorOperand) {
            ValueSelectorOperand selectorOperand = (ValueSelectorOperand)operand;
            sbuf.append("(");
            sbuf.append(this.translate2Sql(selectorOperand.getValueSelector()).trim());
            sbuf.append(") ");
            return sbuf.toString();
        } else if (operand instanceof AbstractFunction) {
            AbstractFunction function = (AbstractFunction)operand;
            sbuf.append(this.translateFunction(function, translationContext));
            return sbuf.toString();
        } else {
            sbuf.append(operand.getName());
            sbuf.append(" ");
        }
        return sbuf.toString();
    }

    protected String translateNotExpression(NotExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("not ");
        sbuf.append(this.translateOperand(expression.getRightOperand(), translationContext));
        return sbuf.toString();
    }

    protected String translateBinaryExpression(String operator, Operand lOperand, Operand rOperand, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.translateOperand(lOperand, translationContext));
        sbuf.append(operator);
        sbuf.append(' ');
        sbuf.append(this.translateOperand(rOperand, translationContext));
        return sbuf.toString();
    }

    protected String translateLogicExpression(AbstractOperationExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        if (expression.getOperator() == LogicOperator.NOT) {
            sbuf.append(this.translateNotExpression((NotExpression)expression, translationContext));
        } else if (expression.getOperator() == LogicOperator.AND) {
            sbuf.append(this.translateBinaryExpression("and", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else {
            sbuf.append(this.translateBinaryExpression("or", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translateRelationExpression(AbstractOperationExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        if (expression.getOperator() == RelationOperator.EQ) {
            sbuf.append(this.translateBinaryExpression("=", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.GT) {
            sbuf.append(this.translateBinaryExpression(">", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.GE) {
            sbuf.append(this.translateBinaryExpression(">=", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.LT) {
            sbuf.append(this.translateBinaryExpression("<", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.LE) {
            sbuf.append(this.translateBinaryExpression("<=", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.NE) {
            sbuf.append(this.translateBinaryExpression("<>", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.BETWEEN) {
            sbuf.append(this.translateBetweenExpression((BetweenExpression)expression, translationContext));
        } else if (expression.getOperator() == RelationOperator.LIKE) {
            sbuf.append(this.translateBinaryExpression("like", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.IN) {
            sbuf.append(this.translateInExpression((InExpression)expression, translationContext));
        } else if (expression.getOperator() == RelationOperator.IS) {
            sbuf.append(this.translateBinaryExpression("is", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.EXISTS) {
            sbuf.append(this.translateExistsExpression((ExistsExpression)expression, translationContext));
        } else {
            sbuf.append(this.translateOperand(expression.getRightOperand(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translateParenExpression(ParenExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("(");
        sbuf.append(this.translateOperand(expression.getOperand(), translationContext).trim());
        sbuf.append(") ");
        return sbuf.toString();
    }

    protected String translateBetweenExpression(BetweenExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.translateOperand(expression.getLeftOperand(), translationContext));
        sbuf.append("between ");
        int i = 0;
        for (Operand rOperand : expression.getrOperands()) {
            sbuf.append(this.translateOperand(rOperand, translationContext));
            if (i != 0) continue;
            sbuf.append("and ");
            ++i;
        }
        return sbuf.toString();
    }

    protected String translateInExpression(InExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.translateOperand(expression.getLeftOperand(), translationContext));
        sbuf.append("in (");
        int i = 0;
        for (Operand rOperand : expression.getrOperands()) {
            if (i != 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.translateOperand(rOperand, translationContext).trim());
            ++i;
        }
        sbuf.append(") ");
        return sbuf.toString();
    }

    protected String translateExistsExpression(ExistsExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("exists(");
        sbuf.append(this.translateOperand(expression.getRightOperand(), translationContext).trim());
        sbuf.append(") ");
        return sbuf.toString();
    }

    protected String translateArithmeticExpression(AbstractOperationExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        if (expression.getOperator() == ArithmeticOperator.ADD) {
            sbuf.append(this.translateBinaryExpression("+", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == ArithmeticOperator.SUBTRACT) {
            sbuf.append(this.translateBinaryExpression("-", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == ArithmeticOperator.MULTIPLY) {
            sbuf.append(this.translateBinaryExpression("*", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == ArithmeticOperator.DIVIDE) {
            sbuf.append(this.translateBinaryExpression("/", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == ArithmeticOperator.MODULAR) {
            sbuf.append(this.translateBinaryExpression("%", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else {
            sbuf.append(this.translateBinaryExpression("^", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translateBitwiseExpression(AbstractOperationExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        if (expression.getOperator() == BitwiseOperator.LSHIFT) {
            sbuf.append(this.translateBinaryExpression("<<", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == BitwiseOperator.RSHIFT) {
            sbuf.append(this.translateBinaryExpression(">>", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == BitwiseOperator.BITWISEAND) {
            sbuf.append(this.translateBinaryExpression("&", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == BitwiseOperator.BITWISEOR) {
            sbuf.append(this.translateBinaryExpression("|", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == BitwiseOperator.BITWISEXOR) {
            sbuf.append(this.translateBinaryExpression("^", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else {
            sbuf.append("~ ");
            sbuf.append(this.translateOperand(expression.getRightOperand(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translateFunction(AbstractFunction function, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        FunctionTranslator functionTranslator = this.functionTranslators.get(function.getName());
        if (functionTranslator == null) {
            sbuf.append(function.toString());
        } else {
            sbuf.append(functionTranslator.translate((Function)function));
        }
        sbuf.append(" ");
        return sbuf.toString();
    }

    protected String translate2GroupbyClause(GroupRecordSetOperator groupRecordSetOperator, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        List groupMetadatas = groupRecordSetOperator.getGroupMetadatas();
        sbuf.append("group by ");
        int i = 0;
        for (Column column : groupRecordSetOperator.getGroupColumns()) {
            if (i != 0) {
                sbuf.append(",");
            }
            GroupMetadata groupMetadata = (GroupMetadata)groupMetadatas.get(i);
            try {
                int index = Integer.valueOf(groupMetadata.getColumn());
                sbuf.append(index);
            }
            catch (Throwable t) {
                sbuf.append(this.translateOperand(column.getOperand(), translationContext));
            }
            ++i;
        }
        sbuf.append(" ");
        return sbuf.toString();
    }

    protected String translate2HavingClause(HavingImpl having, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("having ");
        sbuf.append(this.translateOperand(having.getCondition().getOperand(), translationContext));
        return sbuf.toString();
    }

    protected String translate2OrderbyClause(OrderImpl order, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("order by ");
        Column[] columns = order.getOrderColumns();
        OrderType[] orderTypes = order.getOrderTypes();
        List orderMetadatas = order.getOrderMetadatas();
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                sbuf.append(", ");
            }
            OrderMetadata orderMetadata = (OrderMetadata)orderMetadatas.get(i);
            try {
                int index = Integer.valueOf(orderMetadata.getColumn());
                sbuf.append(index);
            }
            catch (Throwable t) {
                sbuf.append(orderMetadata.getColumn());
            }
            sbuf.append(" ");
            sbuf.append(orderTypes[i].name().toLowerCase());
        }
        sbuf.append(" ");
        return sbuf.toString();
    }

    @Override
    public void addFunctionTranslator(FunctionTranslator functionTranslator) {
        Validate.notNull((Object)functionTranslator, (String)"functionTranslator is null!", (Object[])new Object[0]);
        this.functionTranslators.put(functionTranslator.getFunctionName(), functionTranslator);
    }

    @Override
    public void addAllFunctionTranslator(List<FunctionTranslator> functionTranslators) {
        Validate.notNull(functionTranslators, (String)"functionTranslators is null!", (Object[])new Object[0]);
        for (FunctionTranslator functionTranslator : functionTranslators) {
            this.addFunctionTranslator(functionTranslator);
        }
    }

    @Override
    public FunctionTranslator removeFunctionTranslator(String functionName) {
        Validate.notEmpty((CharSequence)functionName, (String)"functionName is empty!", (Object[])new Object[0]);
        return this.functionTranslators.remove(functionName);
    }

    @Override
    public List<FunctionTranslator> getFunctionTranslators() {
        return new LinkedList<FunctionTranslator>(this.functionTranslators.values());
    }
}

