/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql.es;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.sql.es.AbstractESFunctionTranslator;

public class MatchTranslator
extends AbstractESFunctionTranslator {
    public static final String FUNCTION_NAME = "match";

    public MatchTranslator() {
        super(FUNCTION_NAME);
    }

    @Override
    protected void innerTranslate(Function function, JsonElement jsonObject) {
        if (function.getParameterCount() != 2) {
            throw new IllegalArgumentException("Error function! The match function's format should be match(fields,queryString)!");
        }
        JsonObject match = new JsonObject();
        List parameters = function.getParameters();
        String fieldString = this.getOperandName((Operand)parameters.get(0));
        String[] fields = fieldString.split(",");
        if (fields.length == 1) {
            match.addProperty(this.getOperandName(fields[0]), this.getOperandName((Operand)parameters.get(1)));
            this.putObject(jsonObject, FUNCTION_NAME, match);
        } else {
            JsonArray array = new JsonArray();
            for (int i = 0; i < fields.length; ++i) {
                array.add(this.getOperandName(fields[i]));
            }
            match.addProperty("query", this.getOperandName((Operand)parameters.get(1)));
            match.add("fields", (JsonElement)array);
            this.putObject(jsonObject, "multi_match", match);
        }
    }
}

