/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql.es;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.sql.es.AbstractESFunctionTranslator;

public class FuzzyTranslator
extends AbstractESFunctionTranslator {
    public static final String FUNCTION_NAME = "fuzzy";

    public FuzzyTranslator() {
        super(FUNCTION_NAME);
    }

    @Override
    protected void innerTranslate(Function function, JsonElement jsonObject) {
        if (function.getParameterCount() != 2 && function.getParameterCount() != 5) {
            throw new IllegalArgumentException("Error function! The fuzzy function's format should be fuzzy(field, value) or fuzzy(field,value,fuzziness,prefix_length,max_expansions)!");
        }
        JsonObject fuzzy = new JsonObject();
        List parameters = function.getParameters();
        String fieldString = this.getOperandName((Operand)parameters.get(0));
        String field = this.getOperandName(fieldString);
        if (parameters.size() == 2) {
            fuzzy.addProperty(field, this.getOperandName((Operand)parameters.get(1)));
        } else {
            JsonObject inFuzzy = new JsonObject();
            inFuzzy.addProperty("value", this.getOperandName((Operand)parameters.get(1)));
            inFuzzy.addProperty("fuzziness", (Number)((Long)((Operand)parameters.get(3)).getValue()));
            inFuzzy.addProperty("prefix_length", (Number)((Long)((Operand)parameters.get(4)).getValue()));
            inFuzzy.addProperty("max_expansions", (Number)((Long)((Operand)parameters.get(5)).getValue()));
            this.putObject((JsonElement)fuzzy, field, inFuzzy);
        }
        this.putObject(jsonObject, FUNCTION_NAME, fuzzy);
    }
}

