/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.Filter;
import org.datayoo.moql.Operand;
import org.datayoo.moql.Selector;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Columns;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.Join;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.OrderImpl;
import org.datayoo.moql.core.Queryable;
import org.datayoo.moql.core.RecordSetOperator;
import org.datayoo.moql.core.SelectorImpl;
import org.datayoo.moql.core.Table;
import org.datayoo.moql.core.Tables;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.metadata.ColumnsMetadata;
import org.datayoo.moql.metadata.JoinMetadata;
import org.datayoo.moql.metadata.LimitMetadata;
import org.datayoo.moql.metadata.OrderMetadata;
import org.datayoo.moql.metadata.OrderType;
import org.datayoo.moql.metadata.TableMetadata;
import org.datayoo.moql.operand.PseudoOperand;
import org.datayoo.moql.operand.constant.Constant;
import org.datayoo.moql.operand.constant.LongConstant;
import org.datayoo.moql.operand.expression.AbstractOperationExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.arithmetic.ModularExpression;
import org.datayoo.moql.operand.expression.logic.LogicOperator;
import org.datayoo.moql.operand.expression.logic.NotExpression;
import org.datayoo.moql.operand.expression.relation.BetweenExpression;
import org.datayoo.moql.operand.expression.relation.EqualExpression;
import org.datayoo.moql.operand.expression.relation.ExistsExpression;
import org.datayoo.moql.operand.expression.relation.InExpression;
import org.datayoo.moql.operand.expression.relation.LikeExpression;
import org.datayoo.moql.operand.expression.relation.RelationOperator;
import org.datayoo.moql.sql.FunctionTranslator;
import org.datayoo.moql.sql.SqlTranslator;
import org.datayoo.moql.util.StringFormater;

public class MongoDBTranslator
implements SqlTranslator {
    protected Map<String, FunctionTranslator> functionTranslators = new HashMap<String, FunctionTranslator>();

    @Override
    public String translate2Sql(Selector selector) {
        return this.translate2Sql(selector, new HashMap<String, Object>());
    }

    @Override
    public String translate2Sql(Selector selector, Map<String, Object> translationContext) {
        Validate.notNull((Object)selector, (String)"selector is null!", (Object[])new Object[0]);
        if (selector instanceof SelectorImpl) {
            return this.translate2Sql((SelectorImpl)selector, translationContext);
        }
        throw new IllegalArgumentException("Just support the selector type is SelectorImpl");
    }

    @Override
    public String translate2Condition(Filter filter) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public String translate2Condition(Filter filter, Map<String, Object> translationContext) {
        throw new UnsupportedOperationException("");
    }

    protected String translate2Sql(SelectorImpl selector, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("db.");
        sbuf.append(this.getTableName(selector.getTables(), translationContext));
        if (this.isDistinct(selector.getRecordSetOperator())) {
            sbuf.append(this.translate2DistinctClause(selector.getRecordSetOperator()));
        } else {
            sbuf.append(".find(");
            String condition = null;
            String projection = null;
            if (selector.getWhere() != null) {
                condition = this.translateCondition(selector.getWhere(), translationContext);
            }
            if (condition.length() > 2) {
                sbuf.append(condition);
            }
            if ((projection = this.translateProjection(selector, translationContext)).length() > 0) {
                sbuf.append(" , ");
                sbuf.append(projection);
            }
            sbuf.append(")");
            if (selector.getOrder() != null) {
                sbuf.append(this.translate2SortClause((OrderImpl)selector.getOrder(), translationContext));
            }
            if (selector.getLimit() != null) {
                sbuf.append(this.translate2LimitClause(selector.getLimit(), translationContext));
            }
        }
        return sbuf.toString();
    }

    protected String getTableName(Tables tables, Map<String, Object> translationContext) {
        TableMetadata tableMetadata;
        Queryable queryable = tables.getQueryable();
        if (queryable instanceof Table) {
            tableMetadata = ((Table)queryable).getTableMetadata();
        } else {
            Join join = (Join)queryable;
            tableMetadata = (TableMetadata)join.getJoinMetadata().getLQueryable();
        }
        return tableMetadata.getName();
    }

    protected boolean isDistinct(RecordSetOperator recordSetOperator) {
        return recordSetOperator.getColumns().getColumnsMetadata().isDistinct();
    }

    protected String translate2DistinctClause(RecordSetOperator recordSetOperator) {
        StringBuffer sbuf = new StringBuffer();
        ColumnsMetadata columnsMetadata = recordSetOperator.getColumns().getColumnsMetadata();
        if (columnsMetadata.isDistinct()) {
            sbuf.append(".distinct(");
            sbuf.append(((ColumnMetadata)columnsMetadata.getColumns().get(0)).getName());
            sbuf.append(")");
        }
        return sbuf.toString();
    }

    protected String translateColumns(Columns columns, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        if (columns.getColumns().size() == 1 && ((Column)columns.getColumns().get(0)).getOperand() instanceof PseudoOperand) {
            return sbuf.toString();
        }
        int i = 0;
        sbuf.append('{');
        for (Column column : columns.getColumns()) {
            if (column.isJustUsed4Order()) continue;
            if (i != 0) {
                sbuf.append(", ");
            }
            sbuf.append(column.getColumnMetadata().getName());
            sbuf.append(":1");
            ++i;
        }
        sbuf.append('}');
        return sbuf.toString();
    }

    protected String translateCondition(Condition condition, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('{');
        sbuf.append(this.translateOperand(condition.getOperand(), translationContext));
        sbuf.append('}');
        return sbuf.toString();
    }

    protected String translateProjection(SelectorImpl selector, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('{');
        sbuf.append('}');
        return sbuf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String translateOperand(Operand operand, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        if (operand instanceof AbstractOperationExpression) {
            AbstractOperationExpression expression = (AbstractOperationExpression)operand;
            if (expression.getExpressionType() == ExpressionType.LOGIC) {
                sbuf.append(this.translateLogicExpression(expression, translationContext));
                return sbuf.toString();
            } else {
                if (expression.getExpressionType() != ExpressionType.RELATION) throw new IllegalArgumentException(StringFormater.format((String)"Doesn't support operand with type '{}'!", (Object[])new Object[]{expression.getExpressionType()}));
                sbuf.append(this.translateRelationExpression(expression, translationContext));
            }
            return sbuf.toString();
        } else {
            if (!(operand instanceof Constant)) throw new IllegalArgumentException(StringFormater.format((String)"Doesn't support operand with type '{}'!", (Object[])new Object[]{operand.getOperandType()}));
            sbuf.append(operand.getName());
        }
        return sbuf.toString();
    }

    protected String translateLogicExpression(AbstractOperationExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        if (expression.getOperator() == LogicOperator.NOT) {
            sbuf.append(this.translateNotExpression((NotExpression)expression, translationContext));
        } else if (expression.getOperator() == LogicOperator.AND) {
            sbuf.append(this.translateLogicExpression("$and", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else {
            sbuf.append(this.translateLogicExpression("$or", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translateNotExpression(NotExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        Operand operand = expression.getRightOperand();
        if (operand instanceof AbstractOperationExpression) {
            AbstractOperationExpression rExpression = (AbstractOperationExpression)expression.getRightOperand();
            if (rExpression.getExpressionType() == ExpressionType.LOGIC) {
                throw new IllegalArgumentException("Logic expression doesn't support 'not' operator!");
            }
        } else {
            throw new IllegalArgumentException(StringFormater.format((String)"The operand with type '{}' doesn't support 'not' operator!", (Object[])new Object[]{operand.getOperandType()}));
        }
        if (expression.getRightOperand() instanceof InExpression) {
            this.translateInExpression("$nin", (InExpression)expression.getRightOperand(), translationContext);
        } else if (expression.getRightOperand() instanceof ExistsExpression) {
            this.translateExistsExpression((ExistsExpression)expression.getRightOperand(), false, translationContext);
        } else {
            String operandExpression = this.translateOperand(expression.getRightOperand(), translationContext);
            int index = operandExpression.indexOf(58);
            sbuf.append(operandExpression.substring(0, index));
            sbuf.append(" {$not: ");
            sbuf.append(operandExpression.substring(index));
            sbuf.append('}');
        }
        return sbuf.toString();
    }

    protected String translateLogicExpression(String operator, Operand lOperand, Operand rOperand, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("{");
        sbuf.append(operator);
        sbuf.append(": [");
        sbuf.append(this.translateOperand(lOperand, translationContext));
        sbuf.append(',');
        sbuf.append(this.translateOperand(rOperand, translationContext));
        sbuf.append("]}");
        return sbuf.toString();
    }

    protected String translateBinaryExpression(String operator, Operand lOperand, Operand rOperand, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('{');
        sbuf.append(this.translateOperand(lOperand, translationContext));
        sbuf.append('{');
        sbuf.append(operator);
        sbuf.append(": ");
        sbuf.append(this.translateOperand(rOperand, translationContext));
        sbuf.append("}}");
        return sbuf.toString();
    }

    protected String translateRelationExpression(AbstractOperationExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        if (expression.getOperator() == RelationOperator.EQ) {
            sbuf.append(this.translateEqualExpression((EqualExpression)expression, translationContext));
        } else if (expression.getOperator() == RelationOperator.GT) {
            sbuf.append(this.translateBinaryExpression("$gt", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.GE) {
            sbuf.append(this.translateBinaryExpression("$gte", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.LT) {
            sbuf.append(this.translateBinaryExpression("$lt", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.LE) {
            sbuf.append(this.translateBinaryExpression("$lte", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.NE) {
            sbuf.append(this.translateBinaryExpression("$ne", expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.BETWEEN) {
            sbuf.append(this.translateBetweenExpression((BetweenExpression)expression, translationContext));
        } else if (expression.getOperator() == RelationOperator.LIKE) {
            sbuf.append(this.translateLikeExpression((LikeExpression)expression, translationContext));
        } else if (expression.getOperator() == RelationOperator.IN) {
            sbuf.append(this.translateInExpression("$in", (InExpression)expression, translationContext));
        } else if (expression.getOperator() == RelationOperator.IS) {
            sbuf.append(this.translateBinaryExpression(null, expression.getLeftOperand(), expression.getRightOperand(), translationContext));
        } else if (expression.getOperator() == RelationOperator.EXISTS) {
            sbuf.append(this.translateExistsExpression((ExistsExpression)expression, true, translationContext));
        } else {
            sbuf.append(this.translateOperand(expression.getRightOperand(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translateEqualExpression(EqualExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        Operand lOperand = expression.getLeftOperand();
        Operand rOperand = expression.getRightOperand();
        if (lOperand instanceof ModularExpression) {
            ModularExpression modularExpression = (ModularExpression)lOperand;
            return this.translateModularExpression(modularExpression.getLeftOperand(), (LongConstant)modularExpression.getRightOperand(), (LongConstant)rOperand, translationContext);
        }
        sbuf.append('{');
        sbuf.append(this.translateOperand(lOperand, translationContext));
        sbuf.append(": ");
        sbuf.append(this.translateOperand(rOperand, translationContext));
        sbuf.append('}');
        return sbuf.toString();
    }

    protected String translateModularExpression(Operand operand, LongConstant divisor, LongConstant remainder, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('{');
        sbuf.append(this.translateOperand(operand, translationContext));
        sbuf.append(": {$mod : [");
        sbuf.append(divisor.getValue());
        sbuf.append(',');
        sbuf.append(remainder.getValue());
        sbuf.append("]}");
        return sbuf.toString();
    }

    protected String translateLikeExpression(LikeExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('{');
        sbuf.append(this.translateOperand(expression.getLeftOperand(), translationContext));
        sbuf.append(": ");
        String pattern = this.translateOperand(expression.getRightOperand(), translationContext);
        pattern.substring(1, pattern.length() - 1);
        sbuf.append('/');
        if (pattern.length() > 1 && pattern.charAt(0) != '%') {
            sbuf.append('^');
        }
        sbuf.append(pattern);
        sbuf.append("/}");
        return sbuf.toString();
    }

    protected String translateBetweenExpression(BetweenExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('{');
        sbuf.append(this.translateOperand(expression.getLeftOperand(), translationContext));
        sbuf.append(": {");
        boolean i = false;
        for (Operand rOperand : expression.getrOperands()) {
            if (!i) {
                sbuf.append("$gte: ");
            } else {
                sbuf.append(", $lte: ");
            }
            sbuf.append(this.translateOperand(rOperand, translationContext));
        }
        sbuf.append("}}");
        return sbuf.toString();
    }

    protected String translateInExpression(String operator, InExpression expression, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('{');
        sbuf.append(this.translateOperand(expression.getLeftOperand(), translationContext));
        sbuf.append(": {");
        sbuf.append(operator);
        sbuf.append(": [");
        int i = 0;
        for (Operand rOperand : expression.getrOperands()) {
            if (i != 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.translateOperand(rOperand, translationContext).trim());
            ++i;
        }
        sbuf.append("]}}");
        return sbuf.toString();
    }

    protected String translateExistsExpression(ExistsExpression expression, boolean exist, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('{');
        sbuf.append(this.translateOperand(expression.getRightOperand(), translationContext).trim());
        sbuf.append(": {$exist: ");
        if (exist) {
            sbuf.append("true");
        } else {
            sbuf.append("false");
        }
        sbuf.append("}}");
        return sbuf.toString();
    }

    protected boolean hasJoin(SelectorImpl selector) {
        Queryable queryable = selector.getTables().getQueryable();
        return queryable instanceof Join;
    }

    protected String translateQueryable(Queryable queryable, boolean multiTables, Map<String, Object> translationContext) {
        if (queryable instanceof Table) {
            return null;
        }
        return this.translateJoin((Join)queryable, multiTables, translationContext);
    }

    protected String translateJoin(Join join, boolean multiTables, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        JoinMetadata joinMetadata = join.getJoinMetadata();
        String leftQuery = this.translateQueryable(join.getLeftQueryable(), multiTables, translationContext);
        if (!multiTables) {
            sbuf.append(leftQuery);
            sbuf.append(" ");
        } else {
            sbuf.append(leftQuery.trim());
            sbuf.append(", ");
        }
        sbuf.append(this.translateQueryable(join.getRightQueryable(), multiTables, translationContext));
        if (!multiTables && join.getOn() != null) {
            sbuf.append("on ");
            sbuf.append(this.translateOperand(join.getOn().getOperand(), translationContext));
        }
        return sbuf.toString();
    }

    protected String translate2SortClause(OrderImpl order, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(".sort({");
        Column[] columns = order.getOrderColumns();
        OrderType[] orderTypes = order.getOrderTypes();
        List orderMetadatas = order.getOrderMetadatas();
        int type = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                sbuf.append(", ");
            }
            OrderMetadata orderMetadata = (OrderMetadata)orderMetadatas.get(i);
            sbuf.append(orderMetadata.getColumn());
            sbuf.append(": ");
            type = orderTypes[i] == OrderType.ASC ? 1 : -1;
            sbuf.append(type);
        }
        sbuf.append("})");
        return sbuf.toString();
    }

    protected String translate2LimitClause(Limit limit, Map<String, Object> translationContext) {
        StringBuffer sbuf = new StringBuffer();
        LimitMetadata limitMetadata = limit.getLimitMetadata();
        sbuf.append(".limit(");
        sbuf.append(limitMetadata.getValue());
        sbuf.append(')');
        if (limitMetadata.getOffset() != 0) {
            sbuf.append(".skip(");
            sbuf.append(limitMetadata.getOffset());
            sbuf.append(")");
        }
        return sbuf.toString();
    }

    @Override
    public void addFunctionTranslator(FunctionTranslator functionTranslator) {
        Validate.notNull((Object)functionTranslator, (String)"functionTranslator is null!", (Object[])new Object[0]);
        this.functionTranslators.put(functionTranslator.getFunctionName(), functionTranslator);
    }

    @Override
    public void addAllFunctionTranslator(List<FunctionTranslator> functionTranslators) {
        Validate.notNull(functionTranslators, (String)"functionTranslators is null!", (Object[])new Object[0]);
        for (FunctionTranslator functionTranslator : functionTranslators) {
            this.addFunctionTranslator(functionTranslator);
        }
    }

    @Override
    public FunctionTranslator removeFunctionTranslator(String functionName) {
        Validate.notEmpty((CharSequence)functionName, (String)"functionName is empty!", (Object[])new Object[0]);
        return this.functionTranslators.remove(functionName);
    }

    @Override
    public List<FunctionTranslator> getFunctionTranslators() {
        return new LinkedList<FunctionTranslator>(this.functionTranslators.values());
    }
}

