/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.querier.milvus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.milvus.client.MilvusClient;
import io.milvus.client.MilvusServiceClient;
import io.milvus.grpc.DataType;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.FieldSchema;
import io.milvus.grpc.IDs;
import io.milvus.grpc.LongArray;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchResultData;
import io.milvus.grpc.SearchResults;
import io.milvus.grpc.StringArray;
import io.milvus.param.ConnectParam;
import io.milvus.param.R;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.response.FieldDataWrapper;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.MoqlException;
import org.datayoo.moql.MoqlRuntimeException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.Selector;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.core.Column;
import org.datayoo.moql.core.Condition;
import org.datayoo.moql.core.Group;
import org.datayoo.moql.core.Limit;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.core.RecordSetMetadata;
import org.datayoo.moql.core.RecordSetOperator;
import org.datayoo.moql.core.SelectorImpl;
import org.datayoo.moql.core.SetlectorImpl;
import org.datayoo.moql.core.Tables;
import org.datayoo.moql.core.factory.MoqlFactoryImpl;
import org.datayoo.moql.core.table.CommonTable;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.metadata.ConditionMetadata;
import org.datayoo.moql.metadata.LimitMetadata;
import org.datayoo.moql.metadata.OperationMetadata;
import org.datayoo.moql.metadata.QueryableMetadata;
import org.datayoo.moql.metadata.RelationOperationMetadata;
import org.datayoo.moql.metadata.SelectorMetadata;
import org.datayoo.moql.metadata.TableMetadata;
import org.datayoo.moql.metadata.TablesMetadata;
import org.datayoo.moql.operand.OperandFactory;
import org.datayoo.moql.operand.expression.AbstractOperationExpression;
import org.datayoo.moql.operand.expression.ParenExpression;
import org.datayoo.moql.operand.expression.logic.AndExpression;
import org.datayoo.moql.operand.expression.logic.NotExpression;
import org.datayoo.moql.operand.expression.logic.OrExpression;
import org.datayoo.moql.operand.expression.relation.InExpression;
import org.datayoo.moql.operand.expression.relation.OperandExpression;
import org.datayoo.moql.operand.factory.OperandFactoryImpl;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.parser.MoqlParser;
import org.datayoo.moql.querier.DataQuerier;
import org.datayoo.moql.querier.SupplementReader;
import org.datayoo.moql.querier.milvus.BuilderProxy;
import org.datayoo.moql.querier.milvus.ConnectionBuilderHelper;
import org.datayoo.moql.querier.milvus.ConsistencyLevel;
import org.datayoo.moql.querier.milvus.Ef;
import org.datayoo.moql.querier.milvus.GracefulTime;
import org.datayoo.moql.querier.milvus.GuaranteeTimestamp;
import org.datayoo.moql.querier.milvus.NProbe;
import org.datayoo.moql.querier.milvus.PartitionBy;
import org.datayoo.moql.querier.milvus.RoundDecimal;
import org.datayoo.moql.querier.milvus.SearchK;
import org.datayoo.moql.querier.milvus.TravelTimestamp;
import org.datayoo.moql.querier.milvus.VMatch;

public class MilvusQuerier
implements DataQuerier {
    public static final String RESERVED_FUNC_VMATCH = "vMatch";
    public static final String RESERVED_FUNC_PARTITIONBY = "partitionBy";
    public static final String RESERVED_FUNC_CONSISTENCYLEVEL = "consistencyLevel";
    public static final String RESERVED_FUNC_GRACEFUL_TIME = "gracefulTime";
    public static final String RESERVED_FUNC_GUARANTEE_TIMESTAMP = "guaranteeTimestamp";
    public static final String RESERVED_FUNC_ROUND_DECIMAL = "roundDecimal";
    public static final String RESERVED_FUNC_TRAVEL_TIMESTAMP = "travelTimestamp";
    public static final String RESERVED_FUNC_NPROBE = "nProbe";
    public static final String RESERVED_FUNC_EF = "ef";
    public static final String RESERVED_FUNC_SEARCHK = "searchK";
    protected static MoqlFactoryImpl moqlFactory = new MoqlFactoryImpl();
    protected MilvusClient milvusClient;

    public MilvusQuerier() {
    }

    public MilvusQuerier(MilvusClient milvusClient) {
        Validate.notNull((Object)milvusClient, (String)"milvusClient is null!", (Object[])new Object[0]);
        this.milvusClient = milvusClient;
    }

    public void connect(String[] serverIps, Properties properties) throws IOException {
        Validate.notEmpty((Object[])serverIps, (String)"serverIps is null!", (Object[])new Object[0]);
        ConnectParam.Builder builder = ConnectionBuilderHelper.createConnectionBuilder(serverIps[0], properties);
        this.milvusClient = new MilvusServiceClient(builder.build());
    }

    public void disconnect() throws IOException {
        if (this.milvusClient != null) {
            try {
                this.milvusClient.close();
            }
            finally {
                this.milvusClient = null;
            }
        }
    }

    public RecordSet query(String sql) throws IOException {
        return this.query(sql, null, null);
    }

    public RecordSet query(String sql, Properties queryProps) throws IOException {
        return this.query(sql, queryProps, null);
    }

    public RecordSet query(String sql, SupplementReader supplementReader) throws IOException {
        return this.query(sql, null, supplementReader);
    }

    public RecordSet query(String sql, Properties queryProps, SupplementReader supplementReader) throws IOException {
        Validate.notEmpty((CharSequence)sql, (String)"sql is empty!", (Object[])new Object[0]);
        try {
            SelectorDefinition selectorDefinition = MoqlParser.parseMoql((String)sql);
            this.decorateSelectorDefinition(selectorDefinition);
            BuilderProxy builderProxy = this.createBuilder(selectorDefinition);
            if (builderProxy.isSearchMode()) {
                SearchParam searchParam = (SearchParam)builderProxy.build();
                R result = this.milvusClient.search(searchParam);
                return this.toSearchRecordSet((SelectorMetadata)selectorDefinition, (R<SearchResults>)result);
            }
            QueryParam queryParam = (QueryParam)builderProxy.build();
            R result = this.milvusClient.query(queryParam);
            return this.toQueryRecordSet((SelectorMetadata)selectorDefinition, (R<QueryResults>)result);
        }
        catch (MoqlException e) {
            throw new IOException("Parse failed!", e);
        }
    }

    protected void decorateSelectorDefinition(SelectorDefinition selectorDefinition) {
        if (selectorDefinition instanceof SelectorMetadata) {
            ColumnMetadata columnMetadata;
            SelectorMetadata selectorMetadata = (SelectorMetadata)selectorDefinition;
            List columnMetadatas = selectorMetadata.getColumns().getColumns();
            if (columnMetadatas.size() == 1 && (columnMetadata = (ColumnMetadata)columnMetadatas.get(0)).getValue().equals("*")) {
                String collectionName = this.getCollectionName(selectorMetadata.getTables());
                List<FieldSchema> fieldSchemas = this.getFieldSchemas(collectionName);
                selectorMetadata.getColumns().setColumns(this.getCollectionFields(fieldSchemas));
                if (selectorMetadata.getWhere() == null) {
                    selectorMetadata.setWhere(this.buildDefaultConditionMetadata(fieldSchemas));
                }
            }
        } else {
            throw new UnsupportedOperationException("");
        }
    }

    protected String getCollectionName(TablesMetadata tablesMetadata) {
        QueryableMetadata queryableMetadata = (QueryableMetadata)tablesMetadata.getTables().get(0);
        if (!(queryableMetadata instanceof TableMetadata)) {
            throw new UnsupportedOperationException("Unsupport multi tables operation!");
        }
        return ((TableMetadata)queryableMetadata).getName();
    }

    protected List<FieldSchema> getFieldSchemas(String collection) {
        R respDescribeCollection = this.milvusClient.describeCollection(DescribeCollectionParam.newBuilder().withCollectionName(collection).build());
        return ((DescribeCollectionResponse)respDescribeCollection.getData()).getSchema().getFieldsList();
    }

    protected List<ColumnMetadata> getCollectionFields(List<FieldSchema> fieldSchemas) {
        LinkedList<ColumnMetadata> columnMetadatas = new LinkedList<ColumnMetadata>();
        for (FieldSchema fieldSchema : fieldSchemas) {
            ColumnMetadata columnMetadata = new ColumnMetadata(fieldSchema.getName(), fieldSchema.getName());
            columnMetadata.setDataType((Object)fieldSchema.getDataType());
            columnMetadatas.add(columnMetadata);
        }
        return columnMetadatas;
    }

    protected ConditionMetadata buildDefaultConditionMetadata(List<FieldSchema> fieldSchemas) {
        for (FieldSchema fieldSchema : fieldSchemas) {
            DataType dataType = fieldSchema.getDataType();
            if (dataType == DataType.Float || dataType == DataType.Double || dataType == DataType.Int8 || dataType == DataType.Int16 || dataType == DataType.Int32 || dataType == DataType.Int64) {
                RelationOperationMetadata operationMetadata = new RelationOperationMetadata(">", fieldSchema.getName(), "0");
                return new ConditionMetadata((OperationMetadata)operationMetadata);
            }
            if (dataType == DataType.Bool) {
                RelationOperationMetadata operationMetadata = new RelationOperationMetadata("==", fieldSchema.getName(), "true");
                return new ConditionMetadata((OperationMetadata)operationMetadata);
            }
            if (dataType != DataType.String) continue;
            RelationOperationMetadata operationMetadata = new RelationOperationMetadata("!=", fieldSchema.getName(), " ");
            return new ConditionMetadata((OperationMetadata)operationMetadata);
        }
        return null;
    }

    public SearchParam buildSearchParam(String sql) throws IOException {
        try {
            SelectorDefinition selectorDefinition = MoqlParser.parseMoql((String)sql);
            this.decorateSelectorDefinition(selectorDefinition);
            BuilderProxy builderProxy = this.createBuilder(selectorDefinition);
            return (SearchParam)builderProxy.build();
        }
        catch (MoqlException e) {
            throw new IOException("Parse failed!", e);
        }
    }

    public QueryParam buildQueryParam(String sql) throws IOException {
        try {
            SelectorDefinition selectorDefinition = MoqlParser.parseMoql((String)sql);
            this.decorateSelectorDefinition(selectorDefinition);
            BuilderProxy builderProxy = this.createBuilder(selectorDefinition);
            return (QueryParam)builderProxy.build();
        }
        catch (MoqlException e) {
            throw new IOException("Parse failed!", e);
        }
    }

    protected RecordSet toSearchRecordSet(SelectorMetadata selectorMetadata, R<SearchResults> result) {
        if (result.getData() == null) {
            throw new MoqlRuntimeException((Throwable)result.getException());
        }
        SearchResultData searchResultData = ((SearchResults)result.getData()).getResults();
        List columnMetadatas = selectorMetadata.getColumns().getColumns();
        int[] posMappings = this.posMappings(columnMetadatas, searchResultData.getFieldsDataList());
        RecordSetMetadata recordSetMetadata = new RecordSetMetadata(this.getOutputColumns(columnMetadatas, this.getIdType(searchResultData)), null);
        return new RecordSetImpl((RecordSetDefinition)recordSetMetadata, new Date(), new Date(), this.toRecords(searchResultData, posMappings));
    }

    protected DataType getIdType(SearchResultData searchResultData) {
        IDs iDs = searchResultData.getIds();
        if (iDs.hasIntId()) {
            return DataType.Int64;
        }
        return DataType.String;
    }

    protected RecordSet toQueryRecordSet(SelectorMetadata selectorMetadata, R<QueryResults> result) {
        if (result.getData() == null) {
            throw new MoqlRuntimeException((Throwable)result.getException());
        }
        QueryResults queryResults = (QueryResults)result.getData();
        List columnMetadatas = selectorMetadata.getColumns().getColumns();
        int[] posMappings = this.posMappings(columnMetadatas, ((QueryResults)result.getData()).getFieldsDataList());
        RecordSetMetadata recordSetMetadata = new RecordSetMetadata(columnMetadatas, null);
        return new RecordSetImpl((RecordSetDefinition)recordSetMetadata, new Date(), new Date(), this.toRecords(queryResults, posMappings));
    }

    protected int[] posMappings(List<ColumnMetadata> columnMetadatas, List<FieldData> fieldDatas) {
        int[] posMappings = new int[columnMetadatas.size()];
        int i = 0;
        for (FieldData fieldData : fieldDatas) {
            posMappings[i++] = this.findPos(columnMetadatas, fieldData.getFieldName());
        }
        return posMappings;
    }

    protected int findPos(List<ColumnMetadata> columnMetadatas, String name) {
        int i = 0;
        for (ColumnMetadata columnMetadata : columnMetadatas) {
            if (columnMetadata.getName().equals(name)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException(String.format("There is no column named '%s'!", name));
    }

    protected List getOutputColumns(List<ColumnMetadata> columnMetadatas, DataType idType) {
        ColumnMetadata columnMetadata = new ColumnMetadata("id", "id");
        columnMetadatas.add(0, columnMetadata);
        columnMetadata.setDataType((Object)idType);
        columnMetadata = new ColumnMetadata("idScore", "idScore");
        columnMetadata.setDataType((Object)DataType.Float);
        columnMetadatas.add(1, columnMetadata);
        return columnMetadatas;
    }

    protected List<Object[]> toRecords(SearchResultData resultData, int[] posMappings) {
        LinkedList<Object[]> records = new LinkedList<Object[]>();
        int fieldCount = resultData.getFieldsDataCount() + 2;
        Iterator idIt = this.getIdIterator(resultData.getIds());
        Iterator idScoreIt = resultData.getScoresList().iterator();
        List<Iterator> fieldIterators = this.getFieldIterators(resultData.getFieldsDataList());
        while (idIt.hasNext()) {
            Object[] record = new Object[fieldCount];
            record[0] = idIt.next();
            record[1] = idScoreIt.next();
            int i = 0;
            for (Iterator it : fieldIterators) {
                record[posMappings[i++] + 2] = it.next();
            }
            records.add(record);
        }
        return records;
    }

    protected List<Object[]> toRecords(QueryResults queryResults, int[] posMappings) {
        LinkedList<Object[]> records = new LinkedList<Object[]>();
        List<Iterator> fieldIterators = this.getFieldIterators(queryResults.getFieldsDataList());
        while (true) {
            Object[] record = new Object[fieldIterators.size()];
            int i = 0;
            int hasValue = 0;
            for (Iterator it : fieldIterators) {
                if (!it.hasNext()) {
                    ++i;
                    continue;
                }
                record[posMappings[i++]] = it.next();
                ++hasValue;
            }
            if (hasValue == 0) break;
            records.add(record);
        }
        return records;
    }

    protected Iterator getIdIterator(IDs ids) {
        if (ids.hasIntId()) {
            LongArray longArray = ids.getIntId();
            return longArray.getDataList().iterator();
        }
        StringArray stringArray = ids.getStrId();
        return stringArray.getDataList().iterator();
    }

    protected List<Iterator> getFieldIterators(List<FieldData> fieldDatas) {
        LinkedList<Iterator> fieldIterators = new LinkedList<Iterator>();
        for (FieldData fieldData : fieldDatas) {
            FieldDataWrapper dataWrapper = new FieldDataWrapper(fieldData);
            fieldIterators.add(dataWrapper.getFieldData().iterator());
        }
        return fieldIterators;
    }

    protected BuilderProxy createBuilder(SelectorDefinition selectorDefinition) throws MoqlException {
        Selector selector = moqlFactory.createSelector(selectorDefinition);
        if (selector instanceof SetlectorImpl) {
            throw new UnsupportedOperationException("Unsupport 'set' operation!");
        }
        SelectorImpl selectorImpl = (SelectorImpl)selector;
        if (selectorImpl.getRecordSetOperator() instanceof Group) {
            throw new UnsupportedOperationException("Unsupport groupBy clause operation!");
        }
        if (selectorImpl.getHaving() != null) {
            throw new UnsupportedOperationException("Unsupport having clause operation!");
        }
        if (selectorImpl.getOrder() != null) {
            throw new UnsupportedOperationException("Unsupport order clause operation!");
        }
        BuilderProxy builder = new BuilderProxy();
        this.buildFromClause(builder, selectorImpl.getTables());
        this.buildSelectClause(builder, selectorImpl.getRecordSetOperator());
        HashMap paramMap = new HashMap();
        if (selectorImpl.getWhere() != null) {
            this.buildWhereClause(builder, selectorImpl.getWhere());
        }
        if (selectorImpl.getLimit() != null) {
            this.buildLimitClause(builder, selectorImpl.getLimit());
        }
        if (paramMap.size() > 0) {
            Gson gson = new GsonBuilder().create();
            builder.withParams(gson.toJson(paramMap));
        }
        return builder;
    }

    protected void buildFromClause(BuilderProxy builder, Tables tables) {
        if (!(tables.getQueryable() instanceof CommonTable)) {
            throw new UnsupportedOperationException("Unsupport multi tables operation!");
        }
        CommonTable commonTable = (CommonTable)tables.getQueryable();
        builder.withCollectionName(commonTable.getTableMetadata().getName());
    }

    protected void buildSelectClause(BuilderProxy builder, RecordSetOperator recordSetOperator) {
        LinkedList<String> outputFields = new LinkedList<String>();
        for (Column column : recordSetOperator.getColumns().getColumns()) {
            ColumnMetadata columnMetadata = column.getColumnMetadata();
            if (columnMetadata.getNestedSelector() != null) {
                throw new UnsupportedOperationException("Unsupport nested select clause!");
            }
            if (columnMetadata.getCaseMetadata() != null) {
                throw new UnsupportedOperationException("Unsupport case clause!");
            }
            outputFields.add(columnMetadata.getValue());
        }
        builder.withOutFields(outputFields);
    }

    protected void buildWhereClause(BuilderProxy builder, Condition condition) throws MoqlException {
        StringBuilder stringBuilder = new StringBuilder();
        this.buildOperand(builder, condition.getOperand(), stringBuilder);
        if (stringBuilder.length() > 0) {
            builder.withExpr(stringBuilder.toString());
        }
    }

    protected void buildOperand(BuilderProxy builder, Operand operand, StringBuilder stringBuilder) throws MoqlException {
        if (operand instanceof ParenExpression) {
            ParenExpression parenExpression = (ParenExpression)operand;
            this.buildOperand(builder, parenExpression.getOperand(), stringBuilder);
        } else if (operand instanceof OperandExpression) {
            OperandExpression operandExpression = (OperandExpression)operand;
            this.buildOperand(builder, operandExpression.getRightOperand(), stringBuilder);
        } else if (operand instanceof NotExpression || operand instanceof OrExpression || operand instanceof AndExpression) {
            AbstractOperationExpression logicExpression = (AbstractOperationExpression)operand;
            StringBuilder temp1 = new StringBuilder();
            this.buildOperand(builder, logicExpression.getLeftOperand(), temp1);
            if (temp1.length() > 0) {
                stringBuilder.append((CharSequence)temp1);
            }
            StringBuilder temp2 = new StringBuilder();
            this.buildOperand(builder, logicExpression.getRightOperand(), temp2);
            if (temp2.length() > 0) {
                if (temp1.length() > 0) {
                    stringBuilder.append(' ');
                    stringBuilder.append(logicExpression.getOperator());
                    stringBuilder.append(' ');
                }
                stringBuilder.append((CharSequence)temp2);
            }
        } else if (operand instanceof InExpression) {
            InExpression inExpression = (InExpression)operand;
            stringBuilder.append(inExpression.getLeftOperand().toString());
            stringBuilder.append(" in ");
            String v = inExpression.getRightOperand().toString();
            StringBuilder temp = new StringBuilder();
            temp.append('[');
            temp.append(v.substring(1, v.length() - 1));
            temp.append(']');
            stringBuilder.append((CharSequence)temp);
        } else if (operand instanceof Function) {
            this.buildFunction(builder, (Function)operand, stringBuilder);
        } else {
            stringBuilder.append(operand.toString());
        }
    }

    protected void buildFunction(BuilderProxy builder, Function function, StringBuilder stringBuilder) {
        if (function.getName().equals(RESERVED_FUNC_PARTITIONBY)) {
            PartitionBy partitionBy = (PartitionBy)function;
            builder.withPartitionNames(partitionBy.getPartitions());
        } else if (function.getName().equals(RESERVED_FUNC_VMATCH)) {
            VMatch vMatch = (VMatch)function;
            builder.withVectorFieldName(vMatch.getVectorName());
            builder.withVectors(vMatch.getVectorArray());
            builder.withMetricType(vMatch.getMetricType());
        } else if (function.getName().equals(RESERVED_FUNC_CONSISTENCYLEVEL)) {
            ConsistencyLevel consistencyLevel = (ConsistencyLevel)function;
            builder.withConsistencyLevel(consistencyLevel.getConsistencyLevel());
        } else if (function.getName().equals(RESERVED_FUNC_GRACEFUL_TIME)) {
            GracefulTime gracefulTime = (GracefulTime)function;
            builder.withGracefulTime(gracefulTime.getGracefulTime());
        } else if (function.getName().equals(RESERVED_FUNC_GUARANTEE_TIMESTAMP)) {
            GuaranteeTimestamp guaranteeTimestamp = (GuaranteeTimestamp)function;
            builder.withGuaranteeTimestamp(guaranteeTimestamp.getGuaranteeTimestamp());
        } else if (function.getName().equals(RESERVED_FUNC_ROUND_DECIMAL)) {
            RoundDecimal roundDecimal = (RoundDecimal)function;
            builder.withRoundDecimal(roundDecimal.getRoundDecimal());
        } else if (function.getName().equals(RESERVED_FUNC_TRAVEL_TIMESTAMP)) {
            TravelTimestamp travelTimestamp = (TravelTimestamp)function;
            builder.withTravelTimestamp(travelTimestamp.getTravelTimestamp());
        } else if (function.getName().equals(RESERVED_FUNC_NPROBE)) {
            NProbe nProbe = (NProbe)function;
            builder.withNProbe(nProbe.getnProbe());
        } else if (function.getName().equals(RESERVED_FUNC_EF)) {
            Ef ef = (Ef)function;
            builder.withEf(ef.getEf());
        } else if (function.getName().equals(RESERVED_FUNC_SEARCHK)) {
            SearchK searchK = (SearchK)function;
            builder.withSearchK(searchK.getSearchK());
        }
    }

    protected void buildLimitClause(BuilderProxy builder, Limit limit) {
        LimitMetadata limitMetadata = limit.getLimitMetadata();
        builder.withTopK(limitMetadata.getValue());
        if (limitMetadata.getOffset() != 0) {
            builder.withOffset(limitMetadata.getOffset());
        }
    }

    static {
        ClassLoader classLoader = MilvusQuerier.class.getClassLoader();
        OperandFactoryImpl operandFactory = new OperandFactoryImpl();
        operandFactory.registFunction(RESERVED_FUNC_VMATCH, VMatch.class.getName(), classLoader);
        operandFactory.registFunction(RESERVED_FUNC_PARTITIONBY, PartitionBy.class.getName(), classLoader);
        operandFactory.registFunction(RESERVED_FUNC_CONSISTENCYLEVEL, ConsistencyLevel.class.getName(), classLoader);
        operandFactory.registFunction(RESERVED_FUNC_GRACEFUL_TIME, GracefulTime.class.getName(), classLoader);
        operandFactory.registFunction(RESERVED_FUNC_GUARANTEE_TIMESTAMP, GuaranteeTimestamp.class.getName(), classLoader);
        operandFactory.registFunction(RESERVED_FUNC_TRAVEL_TIMESTAMP, TravelTimestamp.class.getName(), classLoader);
        operandFactory.registFunction(RESERVED_FUNC_ROUND_DECIMAL, RoundDecimal.class.getName(), classLoader);
        operandFactory.registFunction(RESERVED_FUNC_NPROBE, NProbe.class.getName(), classLoader);
        operandFactory.registFunction(RESERVED_FUNC_EF, Ef.class.getName(), classLoader);
        operandFactory.registFunction(RESERVED_FUNC_SEARCHK, SearchK.class.getName(), classLoader);
        moqlFactory.setOperandFactory((OperandFactory)operandFactory);
    }
}

