/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.querier.milvus;

import io.milvus.param.ConnectParam;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;

public abstract class ConnectionBuilderHelper {
    public static final String PROP_PORT = "milvus.connection.port";
    public static final String PROP_URI = "milvus.connection.uri";
    public static final String PROP_IDLE_TIMEOUT = "milvus.connection.idleTimeout";
    public static final String PROP_CONNECTION_TIMEOUT = "milvus.connection.connectionTimeout";
    public static final String PROP_KEEPALIVE_TIMEOUT = "milvus.connection.keepaliveTimeout";
    public static final String PROP_USER = "milvus.connection.user";
    public static final String PROP_PASSWORD = "milvus.connection.password";

    public static ConnectParam.Builder createConnectionBuilder(String host, Properties properties) {
        ConnectParam.Builder builder = ConnectParam.newBuilder();
        if (properties != null && properties.size() > 0) {
            String uri = properties.getProperty(PROP_URI);
            if (uri == null) {
                Validate.notEmpty((CharSequence)host, (String)"host is empty!", (Object[])new Object[0]);
                builder.withHost(host);
                String port = properties.getProperty(PROP_PORT);
                if (port != null) {
                    builder.withPort(Integer.valueOf(port).intValue());
                }
            } else {
                builder.withUri(uri);
            }
            ConnectionBuilderHelper.fillProps(builder, properties);
        } else {
            Validate.notEmpty((CharSequence)host, (String)"host is empty!", (Object[])new Object[0]);
            builder.withHost(host);
        }
        return builder;
    }

    protected static void fillProps(ConnectParam.Builder builder, Properties properties) {
        String v = properties.getProperty(PROP_USER);
        if (v != null) {
            builder.withAuthorization(v, properties.getProperty(PROP_PASSWORD));
        }
        if ((v = properties.getProperty(PROP_IDLE_TIMEOUT)) != null) {
            builder.withIdleTimeout(Long.valueOf(v).longValue(), TimeUnit.SECONDS);
        }
        if ((v = properties.getProperty(PROP_CONNECTION_TIMEOUT)) != null) {
            builder.withConnectTimeout(Long.valueOf(v).longValue(), TimeUnit.SECONDS);
        }
        if ((v = properties.getProperty(PROP_KEEPALIVE_TIMEOUT)) != null) {
            builder.withKeepAliveTimeout(Long.valueOf(v).longValue(), TimeUnit.SECONDS);
        }
    }
}

