/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.querier.milvus;

import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.param.MetricType;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuilderProxy {
    protected SearchParam.Builder searchParamBuilder;
    protected QueryParam.Builder queryParamBuilder;
    protected Map<String, Object> paramMap = new HashMap<String, Object>();
    protected boolean search = false;

    public BuilderProxy() {
        this.searchParamBuilder = SearchParam.newBuilder();
        this.searchParamBuilder.withConsistencyLevel(ConsistencyLevelEnum.STRONG);
        this.paramMap.put("offset", 0);
        this.queryParamBuilder = QueryParam.newBuilder();
        this.queryParamBuilder.withOffset(Long.valueOf(0L));
        this.queryParamBuilder.withConsistencyLevel(ConsistencyLevelEnum.STRONG);
    }

    public BuilderProxy withCollectionName(String collectionName) {
        this.searchParamBuilder.withCollectionName(collectionName);
        this.queryParamBuilder.withCollectionName(collectionName);
        return this;
    }

    public BuilderProxy withOutFields(List<String> fields) {
        this.searchParamBuilder.withOutFields(fields);
        this.queryParamBuilder.withOutFields(fields);
        return this;
    }

    public BuilderProxy withExpr(String expr) {
        expr = expr.replace('\'', '\"');
        this.searchParamBuilder.withExpr(expr);
        this.queryParamBuilder.withExpr(expr);
        return this;
    }

    public BuilderProxy withPartitionNames(List<String> partitionNames) {
        this.searchParamBuilder.withPartitionNames(partitionNames);
        this.queryParamBuilder.withPartitionNames(partitionNames);
        return this;
    }

    public BuilderProxy withVectorFieldName(String vectorFieldName) {
        this.search = true;
        this.searchParamBuilder.withVectorFieldName(vectorFieldName);
        return this;
    }

    public BuilderProxy withVectors(List<?> vectors) {
        this.searchParamBuilder.withVectors(vectors);
        return this;
    }

    public BuilderProxy withMetricType(MetricType metricType) {
        this.searchParamBuilder.withMetricType(metricType);
        return this;
    }

    public BuilderProxy withConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
        this.searchParamBuilder.withConsistencyLevel(consistencyLevel);
        this.queryParamBuilder.withConsistencyLevel(consistencyLevel);
        return this;
    }

    public BuilderProxy withGracefulTime(Long gracefulTime) {
        this.searchParamBuilder.withGracefulTime(gracefulTime);
        this.queryParamBuilder.withGracefulTime(gracefulTime);
        return this;
    }

    public BuilderProxy withGuaranteeTimestamp(Long ts) {
        this.searchParamBuilder.withGuaranteeTimestamp(ts);
        this.queryParamBuilder.withGuaranteeTimestamp(ts);
        return this;
    }

    public BuilderProxy withRoundDecimal(Integer decimal) {
        this.searchParamBuilder.withRoundDecimal(decimal);
        return this;
    }

    public BuilderProxy withTravelTimestamp(Long ts) {
        this.searchParamBuilder.withTravelTimestamp(ts);
        this.queryParamBuilder.withTravelTimestamp(ts);
        return this;
    }

    public BuilderProxy withNProbe(Long nProbe) {
        this.paramMap.put("nProbe", nProbe);
        return this;
    }

    public BuilderProxy withEf(Long ef) {
        this.paramMap.put("ef", ef);
        return this;
    }

    public BuilderProxy withSearchK(Long searchK) {
        this.paramMap.put("search_k", searchK);
        return this;
    }

    public BuilderProxy withTopK(int topK) {
        this.searchParamBuilder.withTopK(Integer.valueOf(topK));
        this.queryParamBuilder.withLimit(Long.valueOf(topK));
        return this;
    }

    public BuilderProxy withOffset(int offset) {
        this.paramMap.put("offset", offset);
        this.queryParamBuilder.withOffset(Long.valueOf(offset));
        return this;
    }

    public BuilderProxy withParams(String params) {
        this.searchParamBuilder.withParams(params);
        return this;
    }

    public Object build() {
        if (this.search) {
            return this.searchParamBuilder.build();
        }
        return this.queryParamBuilder.build();
    }

    public boolean isSearchMode() {
        return this.search;
    }
}

