/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.datayoo.moql.io.DefaultResourceLoader;
import org.datayoo.moql.io.Resource;
import org.datayoo.moql.xml.ErrorChecker;
import org.datayoo.moql.xml.XmlAccessException;
import org.datayoo.moql.xml.XmlDocumentFormater;
import org.datayoo.moql.xml.XmlElementFormater;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;

public class DefaultDocumentFormater<T>
implements XmlDocumentFormater<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDocumentFormater.class);
    private XmlElementFormater<T> formater;
    private String encoding = "UTF-8";
    private boolean validation = false;

    @Override
    public void exportObjectToFile(String fileName, T object) throws XmlAccessException {
        if (logger.isDebugEnabled()) {
            logger.debug("Export object '{}' to file '{}'!", (Object)this.formater.getClass().getCanonicalName(), (Object)fileName);
        }
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        Resource resource = resourceLoader.getResource(fileName);
        OutputStream fos = null;
        try {
            fos = resource.getOutputStream();
            this.exportObject(fos, object);
            logger.debug("Export object successed!");
        }
        catch (XmlAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlAccessException(e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                throw new XmlAccessException(e);
            }
        }
        logger.debug("Export object successed!");
    }

    @Override
    public String exportObjectToString(T object) throws XmlAccessException {
        if (logger.isDebugEnabled()) {
            logger.debug("Export object '{}'!", (Object)this.formater.getClass().getCanonicalName());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.exportObject(bos, object);
            logger.debug("Export object successed!");
            String string = bos.toString();
            return string;
        }
        catch (XmlAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlAccessException(e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                throw new XmlAccessException(e);
            }
        }
    }

    @Override
    public void exportObject(OutputStream os, T object) throws XmlAccessException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        if (this.encoding != null) {
            format.setEncoding(this.encoding);
        }
        XMLWriter writer = null;
        try {
            writer = new XMLWriter(os, format);
            Element element = this.formater.exportObjectToElement(null, object);
            writer.write(element.getDocument());
        }
        catch (Exception e) {
            throw new XmlAccessException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new XmlAccessException(e);
            }
        }
    }

    @Override
    public T importObjectFromFile(String fileName) throws XmlAccessException {
        if (logger.isDebugEnabled()) {
            logger.debug("Import object '{}' from file '{}'!", (Object)this.formater.getClass().getCanonicalName(), (Object)fileName);
        }
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        Resource resource = resourceLoader.getResource(fileName);
        InputStream fis = null;
        try {
            fis = resource.getInputStream();
            T t = this.importObject(fis);
            return t;
        }
        catch (XmlAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlAccessException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                throw new XmlAccessException(e);
            }
            if (fis != null) {
                logger.debug("Import object successed!");
            }
        }
    }

    @Override
    public T importObjectFromString(String xmlData) throws XmlAccessException {
        if (logger.isDebugEnabled()) {
            logger.debug("Import object '{}' from string!", (Object)this.formater.getClass().getCanonicalName());
        }
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(xmlData.getBytes());
        }
        catch (Exception e) {
            throw new XmlAccessException(e.getMessage(), e);
        }
        try {
            T e = this.importObject(bis);
            return e;
        }
        catch (XmlAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlAccessException(e);
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException e) {
                throw new XmlAccessException(e);
            }
            if (bis != null) {
                logger.debug("Import object successed!");
            }
        }
    }

    @Override
    public T importObject(InputStream is) throws XmlAccessException {
        Document document;
        SAXReader reader = new SAXReader();
        if (this.encoding != null) {
            reader.setEncoding(this.encoding);
        }
        try {
            if (this.validation) {
                reader.setValidation(true);
                reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                ErrorChecker checker = new ErrorChecker();
                reader.setErrorHandler((ErrorHandler)checker);
            }
            document = reader.read(is);
        }
        catch (Exception e) {
            throw new XmlAccessException("Read failed!", e);
        }
        return this.formater.importObjectFromElement(document.getRootElement());
    }

    public XmlElementFormater<T> getFormater() {
        return this.formater;
    }

    public void setFormater(XmlElementFormater<T> formater) {
        this.formater = formater;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }
}

