/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.util;

import java.util.HashMap;
import java.util.Map;

public abstract class StringFormater {
    static final char PLACEHOLDER_START = '{';
    static final char PLACEHOLDER_STOP = '}';
    static final String PLACEHOLDER_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';
    static final char BRACKET_START = '[';
    static final char BRACKET_STOP = ']';
    static final String ELEMENT_SEPARATOR = ", ";

    public static final String format(String stringPattern, Object ... argArray) {
        if (stringPattern == null) {
            return null;
        }
        if (argArray == null) {
            return stringPattern;
        }
        int offset = 0;
        StringBuffer sbuf = new StringBuffer(stringPattern.length() + 50);
        for (int i = 0; i < argArray.length; ++i) {
            int index = stringPattern.indexOf(PLACEHOLDER_STR, offset);
            if (index != -1) {
                if (index > 0 && stringPattern.charAt(index - 1) == '\\') {
                    if (index <= 1 || stringPattern.charAt(index - 1) != '\\') {
                        --i;
                        sbuf.append(stringPattern.substring(offset, index - 1));
                        sbuf.append('{');
                        offset = index + 1;
                        continue;
                    }
                    sbuf.append(stringPattern.substring(offset, index - 1));
                    StringFormater.deeplyAppendParameter(sbuf, argArray[i], new HashMap<Object, Object>());
                    offset = index + 2;
                    continue;
                }
                sbuf.append(stringPattern.substring(offset, index));
                StringFormater.deeplyAppendParameter(sbuf, argArray[i], new HashMap<Object, Object>());
                offset = index + 2;
                continue;
            }
            if (offset == 0) {
                return stringPattern;
            }
            sbuf.append(stringPattern.substring(offset, stringPattern.length()));
            return sbuf.toString();
        }
        sbuf.append(stringPattern.substring(offset, stringPattern.length()));
        return sbuf.toString();
    }

    private static void deeplyAppendParameter(StringBuffer sbuf, Object o, Map<Object, Object> seenMap) {
        if (o == null) {
            sbuf.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            sbuf.append(o);
        } else if (o instanceof boolean[]) {
            StringFormater.appendBooleanArray(sbuf, (boolean[])o);
        } else if (o instanceof byte[]) {
            StringFormater.appendByteArray(sbuf, (byte[])o);
        } else if (o instanceof char[]) {
            StringFormater.appendCharArray(sbuf, (char[])o);
        } else if (o instanceof short[]) {
            StringFormater.appendShortArray(sbuf, (short[])o);
        } else if (o instanceof int[]) {
            StringFormater.appendIntArray(sbuf, (int[])o);
        } else if (o instanceof long[]) {
            StringFormater.appendLongArray(sbuf, (long[])o);
        } else if (o instanceof float[]) {
            StringFormater.appendFloatArray(sbuf, (float[])o);
        } else if (o instanceof double[]) {
            StringFormater.appendDoubleArray(sbuf, (double[])o);
        } else {
            StringFormater.appendObjectArray(sbuf, (Object[])o, seenMap);
        }
    }

    private static void appendObjectArray(StringBuffer sbuf, Object[] a, Map<Object, Object> seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a)) {
            seenMap.put(a, null);
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                StringFormater.deeplyAppendParameter(sbuf, a[i], seenMap);
                if (i == len - 1) continue;
                sbuf.append(ELEMENT_SEPARATOR);
            }
            seenMap.remove(a);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void appendBooleanArray(StringBuffer sbuf, boolean[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(ELEMENT_SEPARATOR);
        }
        sbuf.append(']');
    }

    private static void appendByteArray(StringBuffer sbuf, byte[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(ELEMENT_SEPARATOR);
        }
        sbuf.append(']');
    }

    private static void appendCharArray(StringBuffer sbuf, char[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(ELEMENT_SEPARATOR);
        }
        sbuf.append(']');
    }

    private static void appendShortArray(StringBuffer sbuf, short[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(ELEMENT_SEPARATOR);
        }
        sbuf.append(']');
    }

    private static void appendIntArray(StringBuffer sbuf, int[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(ELEMENT_SEPARATOR);
        }
        sbuf.append(']');
    }

    private static void appendLongArray(StringBuffer sbuf, long[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(ELEMENT_SEPARATOR);
        }
        sbuf.append(']');
    }

    private static void appendFloatArray(StringBuffer sbuf, float[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(ELEMENT_SEPARATOR);
        }
        sbuf.append(']');
    }

    private static void appendDoubleArray(StringBuffer sbuf, double[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(ELEMENT_SEPARATOR);
        }
        sbuf.append(']');
    }
}

