/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.MoqlException;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.antlr.FilterLexer;
import org.datayoo.moql.antlr.FilterParser;
import org.datayoo.moql.antlr.SelectorLexer;
import org.datayoo.moql.antlr.SelectorParser;
import org.datayoo.moql.metadata.ConditionMetadata;
import org.datayoo.moql.metadata.JoinMetadata;
import org.datayoo.moql.metadata.QueryableMetadata;
import org.datayoo.moql.metadata.SelectorMetadata;
import org.datayoo.moql.metadata.SetlectorMetadata;
import org.datayoo.moql.metadata.TableMetadata;
import org.datayoo.moql.metadata.xml.FilterFormater;
import org.datayoo.moql.metadata.xml.SelectorFormater;
import org.datayoo.moql.util.StringFormater;
import org.datayoo.moql.util.TlcMoqlMode;
import org.datayoo.moql.xml.DefaultDocumentFormater;
import org.datayoo.moql.xml.XmlAccessException;

public abstract class MoqlParser {
    public static SelectorDefinition parseMoql(String moql) throws MoqlException {
        return MoqlParser.parseMoql(moql, false);
    }

    public static SelectorDefinition parseMoql(String moql, boolean moqlMode) throws MoqlException {
        Validate.notEmpty((CharSequence)moql, (String)"Parameter 'moql' is empty!", (Object[])new Object[0]);
        try {
            TlcMoqlMode.setMoqlMode(moqlMode);
            ANTLRInputStream is = new ANTLRInputStream((InputStream)new ByteArrayInputStream(moql.getBytes()));
            SelectorLexer lexer = new SelectorLexer((CharStream)is);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            SelectorParser parser = new SelectorParser((TokenStream)tokens);
            return parser.selector();
        }
        catch (Exception e) {
            throw new MoqlException(StringFormater.format("Parse moql '{}' failed!", moql), e);
        }
    }

    public static ConditionMetadata parseCondition(String condition) throws MoqlException {
        Validate.notEmpty((CharSequence)condition, (String)"Parameter 'condition' is empty!", (Object[])new Object[0]);
        try {
            ANTLRInputStream is = new ANTLRInputStream((InputStream)new ByteArrayInputStream(condition.getBytes()));
            FilterLexer lexer = new FilterLexer((CharStream)is);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            FilterParser parser = new FilterParser((TokenStream)tokens);
            return new ConditionMetadata(parser.searchCondition());
        }
        catch (Exception e) {
            throw new MoqlException(StringFormater.format("Parse condition '{}' failed!", condition), e);
        }
    }

    public static String translateMoql2Xml(String moql) throws MoqlException {
        SelectorDefinition definition = MoqlParser.parseMoql(moql);
        return MoqlParser.translateMetadata2Xml(definition);
    }

    public static String translateMetadata2Xml(SelectorDefinition definition) throws XmlAccessException {
        Validate.notNull((Object)definition, (String)"Parameter 'definition' is null!", (Object[])new Object[0]);
        DefaultDocumentFormater<SelectorDefinition> documentFormater = new DefaultDocumentFormater<SelectorDefinition>();
        SelectorFormater selectorFormater = new SelectorFormater();
        documentFormater.setFormater(selectorFormater);
        return documentFormater.exportObjectToString(definition);
    }

    public static SelectorDefinition translateXml2SelectorDefinition(String xmlData) throws MoqlException {
        Validate.notEmpty((CharSequence)xmlData, (String)"xmlData is empty!", (Object[])new Object[0]);
        DefaultDocumentFormater<SelectorDefinition> documentFormater = new DefaultDocumentFormater<SelectorDefinition>();
        SelectorFormater selectorFormater = new SelectorFormater();
        documentFormater.setFormater(selectorFormater);
        return (SelectorDefinition)documentFormater.importObjectFromString(xmlData);
    }

    public static ConditionMetadata translateXml2ConditionMetadata(String xmlData) throws MoqlException {
        Validate.notEmpty((CharSequence)xmlData, (String)"xmlData is empty!", (Object[])new Object[0]);
        DefaultDocumentFormater<ConditionMetadata> documentFormater = new DefaultDocumentFormater<ConditionMetadata>();
        FilterFormater filterFormater = new FilterFormater();
        documentFormater.setFormater(filterFormater);
        return (ConditionMetadata)documentFormater.importObjectFromString(xmlData);
    }

    public static String translateCondition2Xml(String condition) throws MoqlException {
        ConditionMetadata conditioneMetadata = MoqlParser.parseCondition(condition);
        return MoqlParser.translateMetadata2Xml(conditioneMetadata);
    }

    public static String translateMetadata2Xml(ConditionMetadata conditionMetadata) throws XmlAccessException {
        Validate.notNull((Object)conditionMetadata, (String)"conditionMetadata is null!", (Object[])new Object[0]);
        DefaultDocumentFormater<ConditionMetadata> documentFormater = new DefaultDocumentFormater<ConditionMetadata>();
        FilterFormater filterFormater = new FilterFormater();
        documentFormater.setFormater(filterFormater);
        return documentFormater.exportObjectToString(conditionMetadata);
    }

    public static Set<String> getRelatedTables(SelectorDefinition selectorDefinition) {
        HashSet<String> relatedTables = new HashSet<String>();
        MoqlParser.getRelatedTables(selectorDefinition, relatedTables);
        return relatedTables;
    }

    protected static void getRelatedTables(SelectorDefinition selectorDefinition, Set<String> relatedTables) {
        if (selectorDefinition instanceof SetlectorMetadata) {
            SetlectorMetadata setlectorMetadata = (SetlectorMetadata)selectorDefinition;
            for (SelectorDefinition sd : setlectorMetadata.getSets()) {
                MoqlParser.getRelatedTables(sd, relatedTables);
            }
        } else {
            SelectorMetadata selectorMetadata = (SelectorMetadata)selectorDefinition;
            for (QueryableMetadata queryableMetadata : selectorMetadata.getTables().getTables()) {
                MoqlParser.getRelatedTables(queryableMetadata, relatedTables);
            }
        }
    }

    protected static void getRelatedTables(QueryableMetadata queryableMetadata, Set<String> relatedTables) {
        if (queryableMetadata instanceof JoinMetadata) {
            JoinMetadata joinMetadata = (JoinMetadata)queryableMetadata;
            MoqlParser.getRelatedTables(joinMetadata.getLQueryable(), relatedTables);
            MoqlParser.getRelatedTables(joinMetadata.getRQueryable(), relatedTables);
        } else {
            TableMetadata tableMetadata = (TableMetadata)queryableMetadata;
            relatedTables.add(tableMetadata.getValue());
        }
    }
}

