/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.datayoo.moql.io.ClassPathResource;
import org.datayoo.moql.io.FileSystemResource;
import org.datayoo.moql.io.Resource;
import org.datayoo.moql.io.ResourceLoader;
import org.datayoo.moql.io.UrlResource;
import org.datayoo.moql.util.ClassLoaderUtils;

public class DefaultResourceLoader
implements ResourceLoader {
    private ClassLoader classLoader;

    public DefaultResourceLoader() {
        this.classLoader = ClassLoaderUtils.getDefaultClassLoader();
    }

    public DefaultResourceLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Resource getResource(String location) {
        int index = location.indexOf(":");
        if (index == -1 || index == 1) {
            return new FileSystemResource(location);
        }
        if (location.startsWith("classpath:")) {
            return new ClassPathResource(location.substring("classpath:".length()), this.getClassLoader());
        }
        try {
            URL url = new URL(location);
            return new UrlResource(url);
        }
        catch (MalformedURLException ex) {
            return new ClassPathResource(location, this.getClassLoader());
        }
    }
}

