/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.nativeFunc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.MoqlException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.OperateException;
import org.datayoo.moql.engine.MoqlEngine;
import org.datayoo.moql.operand.nativeFunc.AbstractNativeFunction;
import org.datayoo.moql.util.StringFormater;
import org.dom4j.Element;

public class NativeDynamicField
extends AbstractNativeFunction {
    public static final String FUNCTION_NAME = "_fe";
    protected Operand operand;

    public NativeDynamicField(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
        this.constantReturn = false;
        Operand param = parameters.get(0);
        String exp = (String)param.operate((EntityMap)null);
        try {
            this.operand = MoqlEngine.createOperand(exp);
        }
        catch (MoqlException e) {
            throw new IllegalArgumentException("parameter is invalid!", e);
        }
    }

    @Override
    protected Object innerOperate(EntityMap entityMap) {
        Object o = this.operand.operate(entityMap);
        if (!(o instanceof String)) {
            throw new IllegalArgumentException(StringFormater.format((String)"The value of '{}' is not a string!", (Object[])new Object[]{this.operand.toString()}));
        }
        return this.getField((String)o);
    }

    protected Object getField(String field) {
        if (this.target instanceof Map) {
            return this.operate((Map)this.target, field);
        }
        if (this.target instanceof JsonObject) {
            return this.operate((JsonObject)this.target, field);
        }
        if (this.target instanceof Element) {
            return this.operate((Element)this.target, field);
        }
        return this.operate(this.target, field);
    }

    protected Object operate(Map map, String field) {
        return map.get(field);
    }

    protected Object operate(JsonObject jsonObject, String field) {
        JsonElement value = jsonObject.get(field);
        if (value == null || value.isJsonNull()) {
            return null;
        }
        if (value instanceof JsonPrimitive) {
            JsonPrimitive jp = (JsonPrimitive)value;
            if (jp.isString()) {
                return jp.getAsString();
            }
            if (jp.isBoolean()) {
                return jp.getAsBoolean();
            }
            if (jp.isNumber()) {
                return this.getNumber(jp);
            }
        }
        return value;
    }

    protected Object getNumber(JsonPrimitive value) {
        String v = value.getAsString();
        if (v.indexOf(46) == -1) {
            return value.getAsLong();
        }
        return value.getAsDouble();
    }

    protected Object operate(Element element, String field) {
        List list = element.elements(field);
        if (list == null) {
            return null;
        }
        if (list.size() > 1) {
            return list;
        }
        return list.get(0);
    }

    protected Object operate(Object o, String field) {
        if (o.getClass().isArray()) {
            return this.operateArray(o, field);
        }
        Field f = this.getField(o, field);
        try {
            return f.get(o);
        }
        catch (Exception e) {
            throw new OperateException(StringFormater.format((String)"Invoke field '{}' in class '{}' failed!", (Object[])new Object[]{field, o.getClass().getName()}), e);
        }
    }

    protected Object operateArray(Object o, String field) {
        if (field.equals("length")) {
            return Array.getLength(o);
        }
        throw new UnsupportedOperationException("");
    }

    protected Field getField(Object targetObject, String field) {
        Class<?> objClazz = targetObject.getClass();
        try {
            Field f = objClazz.getDeclaredField(field);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            throw new OperateException(StringFormater.format((String)"Get field '{}' from class '{}' failed!", (Object[])new Object[]{field, objClazz.getName()}), e);
        }
    }

    @Override
    protected Object innerOperate(Object[] entityArray) {
        Object o = this.operand.operate(entityArray);
        if (!(o instanceof String)) {
            throw new IllegalArgumentException(StringFormater.format((String)"The value of '{}' is not a string!", (Object[])new Object[0]));
        }
        return this.getField((String)o);
    }
}

