/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function.factory;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.datayoo.moql.MoqlRuntimeException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.Abs;
import org.datayoo.moql.operand.function.Avg;
import org.datayoo.moql.operand.function.Cbrt;
import org.datayoo.moql.operand.function.Ceil;
import org.datayoo.moql.operand.function.Cos;
import org.datayoo.moql.operand.function.Count;
import org.datayoo.moql.operand.function.ElementMatch;
import org.datayoo.moql.operand.function.Exp;
import org.datayoo.moql.operand.function.First;
import org.datayoo.moql.operand.function.Floor;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.operand.function.Joint;
import org.datayoo.moql.operand.function.Kurtosis;
import org.datayoo.moql.operand.function.Last;
import org.datayoo.moql.operand.function.Log;
import org.datayoo.moql.operand.function.Log10;
import org.datayoo.moql.operand.function.Lu;
import org.datayoo.moql.operand.function.Max;
import org.datayoo.moql.operand.function.Median;
import org.datayoo.moql.operand.function.MemberFunction;
import org.datayoo.moql.operand.function.Min;
import org.datayoo.moql.operand.function.Mode;
import org.datayoo.moql.operand.function.NotNull;
import org.datayoo.moql.operand.function.Percent;
import org.datayoo.moql.operand.function.Percentile;
import org.datayoo.moql.operand.function.Pow;
import org.datayoo.moql.operand.function.Range;
import org.datayoo.moql.operand.function.Regex;
import org.datayoo.moql.operand.function.Round;
import org.datayoo.moql.operand.function.SemiVariance;
import org.datayoo.moql.operand.function.Sin;
import org.datayoo.moql.operand.function.Skewness;
import org.datayoo.moql.operand.function.Sqrt;
import org.datayoo.moql.operand.function.StandardDeviation;
import org.datayoo.moql.operand.function.Sum;
import org.datayoo.moql.operand.function.Tan;
import org.datayoo.moql.operand.function.Trunc;
import org.datayoo.moql.operand.function.Variance;
import org.datayoo.moql.operand.function.decorator.DecorateFunction;
import org.datayoo.moql.operand.function.decorator.GroupOrdinal;
import org.datayoo.moql.operand.function.decorator.MultiDimTranslation;
import org.datayoo.moql.operand.function.decorator.OtherCaculation;
import org.datayoo.moql.operand.function.decorator.RowTransposition;
import org.datayoo.moql.operand.function.decorator.TotalCaculation;
import org.datayoo.moql.operand.function.factory.FunctionFactory;
import org.datayoo.moql.operand.nativeFunc.NativeDynamicField;
import org.datayoo.moql.util.StringFormater;

public class FunctionFactoryImpl
implements FunctionFactory {
    protected Map<String, FunctionBean> nativeFunctionMap = new HashMap<String, FunctionBean>();
    protected Map<String, FunctionBean> functionMap = new HashMap<String, FunctionBean>();

    public FunctionFactoryImpl() {
        this.nativeFunctionMap.put("_fe".toLowerCase(), new FunctionBean("_fe", NativeDynamicField.class.getName(), true));
        this.functionMap.put("lu".toLowerCase(), new FunctionBean("lu", Lu.class.getName(), true));
        this.functionMap.put("count".toLowerCase(), new FunctionBean("count", Count.class.getName(), true));
        this.functionMap.put("avg".toLowerCase(), new FunctionBean("avg", Avg.class.getName(), true));
        this.functionMap.put("min".toLowerCase(), new FunctionBean("min", Min.class.getName(), true));
        this.functionMap.put("max".toLowerCase(), new FunctionBean("max", Max.class.getName(), true));
        this.functionMap.put("sum".toLowerCase(), new FunctionBean("sum", Sum.class.getName(), true));
        this.functionMap.put("first".toLowerCase(), new FunctionBean("first", First.class.getName(), true));
        this.functionMap.put("last".toLowerCase(), new FunctionBean("last", Last.class.getName(), true));
        this.functionMap.put("joint".toLowerCase(), new FunctionBean("joint", Joint.class.getName(), true));
        this.functionMap.put("notNull".toLowerCase(), new FunctionBean("notNull", NotNull.class.getName(), true));
        this.functionMap.put("percentile".toLowerCase(), new FunctionBean("percentile", Percentile.class.getName(), true));
        this.functionMap.put("median".toLowerCase(), new FunctionBean("median", Median.class.getName(), true));
        this.functionMap.put("mode".toLowerCase(), new FunctionBean("mode", Mode.class.getName(), true));
        this.functionMap.put("range".toLowerCase(), new FunctionBean("range", Range.class.getName(), true));
        this.functionMap.put("kurtosis".toLowerCase(), new FunctionBean("kurtosis", Kurtosis.class.getName(), true));
        this.functionMap.put("skewness".toLowerCase(), new FunctionBean("skewness", Skewness.class.getName(), true));
        this.functionMap.put("variance".toLowerCase(), new FunctionBean("variance", Variance.class.getName(), true));
        this.functionMap.put("standardDeviation".toLowerCase(), new FunctionBean("standardDeviation", StandardDeviation.class.getName(), true));
        this.functionMap.put("semiVariance".toLowerCase(), new FunctionBean("semiVariance", SemiVariance.class.getName(), true));
        this.functionMap.put("regex".toLowerCase(), new FunctionBean("regex", Regex.class.getName(), true));
        this.functionMap.put("percent".toLowerCase(), new FunctionBean("percent", Percent.class.getName(), true));
        this.functionMap.put("ceil".toLowerCase(), new FunctionBean("ceil", Ceil.class.getName(), true));
        this.functionMap.put("floor".toLowerCase(), new FunctionBean("floor", Floor.class.getName(), true));
        this.functionMap.put("trunc".toLowerCase(), new FunctionBean("round", Trunc.class.getName(), true));
        this.functionMap.put("round".toLowerCase(), new FunctionBean("round", Round.class.getName(), true));
        this.functionMap.put("abs".toLowerCase(), new FunctionBean("abs", Abs.class.getName(), true));
        this.functionMap.put("cbrt".toLowerCase(), new FunctionBean("cbrt", Cbrt.class.getName(), true));
        this.functionMap.put("cos".toLowerCase(), new FunctionBean("cos", Cos.class.getName(), true));
        this.functionMap.put("exp".toLowerCase(), new FunctionBean("exp", Exp.class.getName(), true));
        this.functionMap.put("log".toLowerCase(), new FunctionBean("log", Log.class.getName(), true));
        this.functionMap.put("log10".toLowerCase(), new FunctionBean("log10", Log10.class.getName(), true));
        this.functionMap.put("pow".toLowerCase(), new FunctionBean("pow", Pow.class.getName(), true));
        this.functionMap.put("sin".toLowerCase(), new FunctionBean("sin", Sin.class.getName(), true));
        this.functionMap.put("sqrt".toLowerCase(), new FunctionBean("sqrt", Sqrt.class.getName(), true));
        this.functionMap.put("tan".toLowerCase(), new FunctionBean("tan", Tan.class.getName(), true));
        this.functionMap.put("elementMatch".toLowerCase(), new FunctionBean("elementMatch", ElementMatch.class.getName(), true));
        this.functionMap.put("groupOrdinal".toLowerCase(), new FunctionBean("groupOrdinal", GroupOrdinal.class.getName(), true));
        this.functionMap.put("rowTransposition".toLowerCase(), new FunctionBean("rowTransposition", RowTransposition.class.getName(), true));
        this.functionMap.put("totalCaculation".toLowerCase(), new FunctionBean("totalCaculation", TotalCaculation.class.getName(), true));
        this.functionMap.put("otherCaculation".toLowerCase(), new FunctionBean("otherCaculation", OtherCaculation.class.getName(), true));
        this.functionMap.put("multiDimTranslation".toLowerCase(), new FunctionBean("multiDimTranslation", MultiDimTranslation.class.getName(), true));
    }

    @Override
    public Function createFunction(String name, List<Operand> parameters) {
        Function func;
        Validate.notEmpty((CharSequence)name, (String)"Parameter name is empty!", (Object[])new Object[0]);
        FunctionBean bean = this.nativeFunctionMap.get(name.toLowerCase());
        if (bean == null && (bean = this.functionMap.get(name.toLowerCase())) == null) {
            return new MemberFunction(name, parameters);
        }
        try {
            func = (Function)bean.getCstr().newInstance(parameters);
            if (func instanceof DecorateFunction) {
                DecorateFunction decorateFunction = (DecorateFunction)func;
                decorateFunction.setFunctionFactory(this);
            }
        }
        catch (Exception e) {
            throw new MoqlRuntimeException(StringFormater.format((String)"Create function '{}' failed!", (Object[])new Object[]{name}), (Throwable)e);
        }
        return func;
    }

    @Override
    public void importFunction(InputStream is) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public String registFunction(String name, String className) {
        return this.registFunction(name, className, null);
    }

    @Override
    public String registFunction(String name, String className, ClassLoader classLoader) {
        Validate.notEmpty((CharSequence)name, (String)"Parameter name is empty!", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)name, (String)"Parameter className is empty!", (Object[])new Object[0]);
        name = name.toLowerCase();
        FunctionBean bean = this.functionMap.get(name);
        if (bean != null) {
            if (bean.isReadonly()) {
                throw new IllegalArgumentException(String.format("Function %s is read only. Cann't be overwritten!", name));
            }
            this.functionMap.put(name, new FunctionBean(name, className, false, classLoader));
            return bean.getClassName();
        }
        this.functionMap.put(name, new FunctionBean(name, className, false, classLoader));
        return className;
    }

    @Override
    public String forceRegistFunction(String name, String className, ClassLoader classLoader) {
        Validate.notEmpty((CharSequence)name, (String)"Parameter name is empty!", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)name, (String)"Parameter className is empty!", (Object[])new Object[0]);
        name = name.toLowerCase();
        FunctionBean bean = this.functionMap.get(name);
        if (bean != null) {
            this.functionMap.put(name, new FunctionBean(name, className, false, classLoader));
            return bean.getClassName();
        }
        this.functionMap.put(name, new FunctionBean(name, className, false, classLoader));
        return className;
    }

    @Override
    public String forceRegistFunction(String name, String className) {
        return this.forceRegistFunction(name, className, null);
    }

    @Override
    public String unregistFunction(String name) {
        Validate.notEmpty((CharSequence)name, (String)"Parameter name is empty!", (Object[])new Object[0]);
        FunctionBean bean = this.functionMap.get(name);
        if (bean != null) {
            if (bean.isReadonly()) {
                return null;
            }
            return bean.getClassName();
        }
        return null;
    }

    @Override
    public String getFunction(String name) {
        FunctionBean functionBean = this.functionMap.get(name);
        if (functionBean == null) {
            return null;
        }
        return functionBean.getClassName();
    }

    @Override
    public Map<String, String> getAllFunctions() {
        HashMap<String, String> allFunctions = new HashMap<String, String>();
        for (Map.Entry<String, FunctionBean> entry : this.functionMap.entrySet()) {
            allFunctions.put(entry.getKey(), entry.getValue().getClassName());
        }
        return allFunctions;
    }

    static class FunctionBean {
        private String name;
        private String className;
        private boolean readonly = false;
        private ClassLoader classLoader;
        private Constructor<?> cstr;

        public FunctionBean(String name, String className, boolean readonly) {
            this.name = name;
            this.className = className;
            this.readonly = readonly;
        }

        public FunctionBean(String name, String className, boolean readonly, ClassLoader classLoader) {
            this.name = name;
            this.className = className;
            this.readonly = readonly;
            this.classLoader = classLoader;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public synchronized Constructor<?> getCstr() {
            if (this.cstr == null) {
                try {
                    ClassLoader classLoader = this.classLoader;
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    Class<?> clazz = classLoader.loadClass(this.className);
                    this.cstr = clazz.getConstructor(List.class);
                }
                catch (Exception e) {
                    throw new MoqlRuntimeException(StringFormater.format((String)"Load function '{}' class = '{}' failed!", (Object[])new Object[]{this.name, this.className}), (Throwable)e);
                }
            }
            return this.cstr;
        }
    }
}

