/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.math.BigDecimal;
import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.constant.ConstantType;
import org.datayoo.moql.operand.function.AggregationFunction;

public class Sum
extends AggregationFunction {
    public static final String FUNCTION_NAME = "sum";
    protected Operand operand;
    protected BigDecimal sum = new BigDecimal(0);
    protected ConstantType sumType = null;

    public Sum(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
        this.operand = parameters.get(0);
    }

    @Override
    public void increment(EntityMap entityMap) {
        Object obj = this.operand.operate(entityMap);
        if (obj == null) {
            return;
        }
        BigDecimal num = this.toBigDecimal(obj);
        if (num.scale() > 0) {
            this.sumType = ConstantType.DOUBLE;
        }
        this.sum = this.sum.add(num);
    }

    @Override
    public void increment(Object[] entityArray) {
        Object obj = this.operand.operate(entityArray);
        if (obj == null) {
            return;
        }
        BigDecimal num = this.toBigDecimal(obj);
        if (num.scale() > 0) {
            this.sumType = ConstantType.DOUBLE;
        }
        this.sum = this.sum.add(num);
    }

    @Override
    public Object getValue() {
        if (this.sumType == ConstantType.DOUBLE) {
            return this.sum.doubleValue();
        }
        return this.sum.longValue();
    }

    @Override
    public synchronized void clear() {
        this.sum = new BigDecimal(0);
    }
}

