/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.AbstractFunction;

public class Pow
extends AbstractFunction {
    public static final String FUNCTION_NAME = "pow";
    protected Operand operand;
    protected double power;

    public Pow(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
        this.operand = parameters.get(0);
        Object object = parameters.get(1).operate((EntityMap)null);
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("Parameter 'distinct' should be 'Number' type!");
        }
        Number num = (Number)object;
        this.power = num.doubleValue();
    }

    @Override
    protected Object innerOperate(EntityMap entityMap) {
        Object obj = this.operand.operate(entityMap);
        return this.innerOperateProc(obj);
    }

    protected Object innerOperateProc(Object obj) {
        if (obj == null) {
            return null;
        }
        double val = 0.0;
        if (obj instanceof Number) {
            Number num = (Number)obj;
            val = num.doubleValue();
        } else {
            val = Double.valueOf(obj.toString());
        }
        return Math.pow(val, this.power);
    }

    @Override
    protected Object innerOperate(Object[] entityArray) {
        Object obj = this.operand.operate(entityArray);
        return this.innerOperateProc(obj);
    }
}

