/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.AggregationFunction;

public class Percentile
extends AggregationFunction {
    public static final String FUNCTION_NAME = "percentile";
    protected org.apache.commons.math3.stat.descriptive.rank.Percentile percentile;
    protected Set<Double> numbers = new HashSet<Double>();

    public Percentile(List<Operand> parameters) {
        super(FUNCTION_NAME, -1, parameters);
        if (parameters.size() == 0 || parameters.size() > 2) {
            throw new IllegalArgumentException("Invalid format! The format is 'percentile(field [, p])'");
        }
        if (parameters.size() == 1) {
            this.percentile = new org.apache.commons.math3.stat.descriptive.rank.Percentile();
        }
    }

    @Override
    public void increment(EntityMap entityMap) {
        Number num;
        Object obj;
        if (this.percentile == null) {
            obj = ((Operand)this.parameters.get(1)).operate(entityMap);
            num = this.toNumber(obj);
            this.percentile = new org.apache.commons.math3.stat.descriptive.rank.Percentile(num.doubleValue());
        }
        if ((obj = ((Operand)this.parameters.get(0)).operate(entityMap)) == null) {
            return;
        }
        num = this.toNumber(obj);
        this.numbers.add(num.doubleValue());
    }

    @Override
    public void increment(Object[] entityArray) {
        Number num;
        Object obj;
        if (this.percentile == null) {
            obj = ((Operand)this.parameters.get(1)).operate(entityArray);
            num = this.toNumber(obj);
            this.percentile = new org.apache.commons.math3.stat.descriptive.rank.Percentile(num.doubleValue());
        }
        if ((obj = ((Operand)this.parameters.get(0)).operate(entityArray)) == null) {
            return;
        }
        num = this.toNumber(obj);
        this.numbers.add(num.doubleValue());
    }

    @Override
    public Object getValue() {
        double[] values = new double[this.numbers.size()];
        int i = 0;
        for (Double num : this.numbers) {
            values[i++] = num;
        }
        return this.percentile.evaluate(values);
    }

    @Override
    public void clear() {
        this.numbers.clear();
    }
}

