/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.AggregationFunction;

public class Median
extends AggregationFunction {
    public static final String FUNCTION_NAME = "median";
    protected Operand operand;
    protected org.apache.commons.math3.stat.descriptive.rank.Median median = new org.apache.commons.math3.stat.descriptive.rank.Median();
    protected Set<Double> numbers = new HashSet<Double>();

    public Median(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
        this.operand = parameters.get(0);
    }

    @Override
    public void increment(EntityMap entityMap) {
        Object obj = this.operand.operate(entityMap);
        if (obj == null) {
            return;
        }
        Number num = this.toNumber(obj);
        this.numbers.add(num.doubleValue());
    }

    @Override
    public void increment(Object[] entityArray) {
        Object obj = this.operand.operate(entityArray);
        if (obj == null) {
            return;
        }
        Number num = this.toNumber(obj);
        this.numbers.add(num.doubleValue());
    }

    @Override
    public Object getValue() {
        double[] values = new double[this.numbers.size()];
        int i = 0;
        for (Double num : this.numbers) {
            values[i++] = num;
        }
        return this.median.evaluate(values);
    }

    @Override
    public void clear() {
        this.numbers.clear();
    }
}

