/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.MoqlException;
import org.datayoo.moql.MoqlRuntimeException;
import org.datayoo.moql.Operand;
import org.datayoo.moql.env.MoqlEnv;
import org.datayoo.moql.operand.OperandFactory;
import org.datayoo.moql.operand.function.AbstractFunction;
import org.datayoo.tripod.FieldMetadata;
import org.datayoo.tripod.IdfCounter;
import org.datayoo.tripod.IdfCounterImpl;
import org.datayoo.tripod.TermEntity;
import org.datayoo.tripod.engine.Tripod;
import org.datayoo.tripod.parser.TripodExpressionParser;

public class Lu
extends AbstractFunction {
    public static final String FUNCTION_NAME = "lu";
    protected static FieldMetadata defaultFieldMetadata = new FieldMetadata("lu", 1);
    protected Tripod tripod;
    protected Operand[] matchedFields;

    public Lu(List<Operand> parameters) {
        super(FUNCTION_NAME, -1, parameters);
        this.constantReturn = false;
        if (parameters.size() == 0 || parameters.size() > 3) {
            throw new IllegalArgumentException("Invalid format! The format is 'lu(lucene [, idfCounterEnvName])'");
        }
        String lucene = parameters.get(0).operate((EntityMap)null).toString();
        IdfCounterImpl idfCounter = null;
        if (parameters.size() == 2) {
            String idfCounterName = parameters.get(1).operate((EntityMap)null).toString();
            idfCounter = (IdfCounter)MoqlEnv.getEnvProp(idfCounterName);
        }
        if (idfCounter == null) {
            idfCounter = new IdfCounterImpl();
        }
        Set fieldSet = TripodExpressionParser.extractSegmentFields((String)lucene);
        fieldSet.add(FUNCTION_NAME);
        OperandFactory operandFactory = (OperandFactory)MoqlEnv.getEnvProp("org.moql.operandfactory");
        this.matchedFields = new Operand[fieldSet.size()];
        int i = 0;
        for (String field : fieldSet) {
            try {
                this.matchedFields[i++] = operandFactory.createOperand(field);
            }
            catch (MoqlException e) {
                throw new MoqlRuntimeException(String.format("Create operand '%s' failed!", field), (Throwable)e);
            }
        }
        LinkedList<FieldMetadata> allFields = new LinkedList<FieldMetadata>();
        allFields.add(defaultFieldMetadata);
        this.tripod = new Tripod(FUNCTION_NAME, allFields, defaultFieldMetadata, (IdfCounter)idfCounter, lucene);
    }

    @Override
    protected Object innerOperate(EntityMap entityMap) {
        HashMap<String, TermEntity[]> dataMap = new HashMap<String, TermEntity[]>();
        for (Operand field : this.matchedFields) {
            Object v = field.operate(entityMap);
            if (v == null) continue;
            if (!(v instanceof TermEntity[])) {
                throw new IllegalArgumentException(String.format("The field %s's type is invalid!", field));
            }
            dataMap.put(field.toString(), (TermEntity[])v);
        }
        if (dataMap.size() == 0) {
            return 0;
        }
        return this.tripod.match(dataMap);
    }

    @Override
    public void bind(String[] entityNames) {
        boolean i = false;
        for (Operand field : this.matchedFields) {
            field.bind(entityNames);
        }
        this.binded = true;
    }

    @Override
    protected Object innerOperate(Object[] entityArray) {
        HashMap<String, TermEntity[]> dataMap = new HashMap<String, TermEntity[]>();
        for (Operand field : this.matchedFields) {
            Object v = field.operate(entityArray);
            if (v == null) continue;
            if (!(v instanceof TermEntity[])) {
                throw new IllegalArgumentException(String.format("The field %s's type is invalid!", field.toString()));
            }
            dataMap.put(field.toString(), (TermEntity[])v);
        }
        return this.tripod.match(dataMap);
    }
}

