/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.ArrayList;
import java.util.List;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.OperandType;
import org.datayoo.moql.operand.AbstractOperand;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.operand.function.FunctionType;
import org.datayoo.moql.util.StringFormater;

public abstract class AbstractFunction
extends AbstractOperand
implements Function {
    protected int parameterCount = 0;
    protected List<Operand> parameters = new ArrayList<Operand>();
    protected FunctionType functionType = FunctionType.COMMON;
    protected String functionString;
    protected Object constantReturnValue = this;

    protected AbstractFunction(String name, int parameterCount, List<Operand> parameters) {
        this.operandType = OperandType.FUNCTION;
        if (parameterCount != -1 && (parameters == null ? parameterCount != 0 : parameters.size() != parameterCount)) {
            throw new IllegalArgumentException(StringFormater.format((String)"Function '{}' need {} parameters!", (Object[])new Object[]{name, parameterCount}));
        }
        if (parameters != null) {
            this.parameters = parameters;
        }
        this.name = name;
        this.parameterCount = parameterCount;
        this.initializeFunction();
    }

    protected AbstractFunction(String name, List<Operand> parameters) {
        this.operandType = OperandType.FUNCTION;
        if (parameters != null) {
            this.parameterCount = parameters.size();
            this.parameters = parameters;
        }
        this.name = name;
        this.initializeFunction();
    }

    protected void initializeFunction() {
        this.functionString = this.buildFunctionString();
        this.constantReturn = this.determineConstantsReturn(this.parameters);
    }

    protected String buildFunctionString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.name);
        sbuf.append('(');
        int i = 0;
        for (Operand operand : this.parameters) {
            if (i != 0) {
                sbuf.append(',');
            }
            sbuf.append(operand.toString());
            ++i;
        }
        sbuf.append(')');
        return sbuf.toString();
    }

    protected boolean determineConstantsReturn(List<Operand> parameters) {
        if (parameters.size() == 0) {
            return false;
        }
        for (Operand operand : parameters) {
            if (operand.isConstantReturn()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object operate(EntityMap entityMap) {
        if (this.constantReturn) {
            if (this.constantReturnValue == this) {
                this.constantReturnValue = this.innerOperate(entityMap);
            }
            return this.constantReturnValue;
        }
        return this.innerOperate(entityMap);
    }

    protected abstract Object innerOperate(EntityMap var1);

    @Override
    public void bind(String[] entityNames) {
        for (Operand parameter : this.parameters) {
            parameter.bind(entityNames);
        }
        this.binded = true;
    }

    @Override
    public Object operate(Object[] entityArray) {
        if (this.constantReturn) {
            if (this.constantReturnValue == this) {
                this.constantReturnValue = this.innerOperate(entityArray);
            }
            return this.constantReturnValue;
        }
        return this.innerOperate(entityArray);
    }

    protected abstract Object innerOperate(Object[] var1);

    @Override
    public FunctionType getFunctionType() {
        return this.functionType;
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public List<Operand> getParameters() {
        return new ArrayList<Operand>(this.parameters);
    }

    @Override
    public String toString() {
        return this.functionString;
    }

    public int hashCode() {
        return this.functionString.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Function) {
            return this.functionString.equals(obj.toString());
        }
        return false;
    }
}

